/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import java.net.URI;
import java.net.URISyntaxException;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.metadata.iso.citation.ContactImpl;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.resources.Utilities;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.util.InternationalString;

public class ResponsiblePartyImpl
extends MetadataEntity
implements ResponsibleParty {
    private static final long serialVersionUID = -2477962229031486552L;
    static final InternationalString OGC_NAME = new SimpleInternationalString("Open Geospatial Consortium");
    public static ResponsibleParty OGC;
    public static ResponsibleParty OPEN_GIS;
    public static ResponsibleParty EPSG;
    public static ResponsibleParty GEOTIFF;
    public static ResponsibleParty ESRI;
    public static ResponsibleParty ORACLE;
    public static ResponsibleParty SUN_MICROSYSTEMS;
    public static ResponsibleParty GEOTOOLS;
    private String individualName;
    private InternationalString organisationName;
    private InternationalString positionName;
    private Contact contactInfo;
    private Role role;

    public static ResponsibleParty OGC(Role role, OnLineResource resource) {
        ContactImpl contact = new ContactImpl(resource);
        contact.freeze();
        ResponsiblePartyImpl ogc = new ResponsiblePartyImpl(role);
        ogc.setOrganisationName(OGC_NAME);
        ogc.setContactInfo(contact);
        ogc.freeze();
        return ogc;
    }

    public static ResponsibleParty OGC(Role role, OnLineFunction function, URI onlineResource) {
        OnLineResourceImpl resource = new OnLineResourceImpl(onlineResource);
        resource.setFunction(function);
        resource.freeze();
        return ResponsiblePartyImpl.OGC(role, resource);
    }

    static ResponsibleParty OGC(Role role, OnLineFunction function, String onlineResource) {
        try {
            return ResponsiblePartyImpl.OGC(role, function, new URI(onlineResource));
        }
        catch (URISyntaxException badContact) {
            Utilities.unexpectedException("org.geotools.metadata.iso", "ResponsibleParty", "OGC", badContact);
            return OGC;
        }
    }

    public ResponsiblePartyImpl() {
    }

    public ResponsiblePartyImpl(ResponsibleParty source) {
        if (source != null) {
            this.setIndividualName(source.getIndividualName());
            this.setOrganisationName(source.getOrganisationName());
            this.setPositionName(source.getPositionName());
            this.setContactInfo(source.getContactInfo());
            this.setRole(source.getRole());
        }
    }

    public ResponsiblePartyImpl(Role role) {
        this.setRole(role);
    }

    public String getIndividualName() {
        return this.individualName;
    }

    public synchronized void setIndividualName(String newValue) {
        this.checkWritePermission();
        this.individualName = newValue;
    }

    public InternationalString getOrganisationName() {
        return this.organisationName;
    }

    public synchronized void setOrganisationName(InternationalString newValue) {
        this.checkWritePermission();
        this.organisationName = newValue;
    }

    public InternationalString getPositionName() {
        return this.positionName;
    }

    public synchronized void setPositionName(InternationalString newValue) {
        this.checkWritePermission();
        this.positionName = newValue;
    }

    public Contact getContactInfo() {
        return this.contactInfo;
    }

    public synchronized void setContactInfo(Contact newValue) {
        this.checkWritePermission();
        this.contactInfo = newValue;
    }

    public Role getRole() {
        return this.role;
    }

    public synchronized void setRole(Role newValue) {
        this.checkWritePermission();
        this.role = newValue;
    }

    protected void freeze() {
        super.freeze();
        this.organisationName = (InternationalString)ResponsiblePartyImpl.unmodifiable(this.organisationName);
        this.positionName = (InternationalString)ResponsiblePartyImpl.unmodifiable(this.positionName);
        this.contactInfo = (Contact)ResponsiblePartyImpl.unmodifiable(this.contactInfo);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            ResponsiblePartyImpl that = (ResponsiblePartyImpl)object;
            return Utilities.equals(this.individualName, that.individualName) && Utilities.equals(this.organisationName, that.organisationName) && Utilities.equals(this.positionName, that.positionName) && Utilities.equals(this.contactInfo, that.contactInfo) && Utilities.equals(this.role, that.role);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 1136540584;
        if (this.individualName != null) {
            code ^= this.individualName.hashCode();
        }
        if (this.contactInfo != null) {
            code ^= this.contactInfo.hashCode();
        }
        return code;
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.individualName != null) {
            buffer.append(this.individualName);
            if (this.role != null) {
                buffer.append(" (");
                buffer.append(this.role.name().toLowerCase().replace('_', ' '));
                buffer.append(')');
            }
        }
        if (this.organisationName != null) {
            ResponsiblePartyImpl.appendLineSeparator(buffer);
            buffer.append((Object)this.organisationName);
        }
        if (this.contactInfo != null) {
            ResponsiblePartyImpl.appendLineSeparator(buffer);
            buffer.append(this.contactInfo);
        }
        return buffer.toString();
    }

    static {
        ResponsiblePartyImpl r = new ResponsiblePartyImpl(Role.RESOURCE_PROVIDER);
        r.setOrganisationName(OGC_NAME);
        r.setContactInfo(ContactImpl.OGC);
        r.freeze();
        OGC = r;
        r = new ResponsiblePartyImpl(Role.RESOURCE_PROVIDER);
        r.setOrganisationName(new SimpleInternationalString("OpenGIS consortium"));
        r.setContactInfo(ContactImpl.OPEN_GIS);
        r.freeze();
        OPEN_GIS = r;
        r = new ResponsiblePartyImpl(Role.PRINCIPAL_INVESTIGATOR);
        r.setOrganisationName(new SimpleInternationalString("European Petroleum Survey Group"));
        r.setContactInfo(ContactImpl.EPSG);
        r.freeze();
        EPSG = r;
        r = new ResponsiblePartyImpl(Role.PRINCIPAL_INVESTIGATOR);
        r.setOrganisationName(new SimpleInternationalString("GeoTIFF"));
        r.setContactInfo(ContactImpl.GEOTIFF);
        r.freeze();
        GEOTIFF = r;
        r = new ResponsiblePartyImpl(Role.OWNER);
        r.setOrganisationName(new SimpleInternationalString("ESRI"));
        r.setContactInfo(ContactImpl.ESRI);
        r.freeze();
        ESRI = r;
        r = new ResponsiblePartyImpl(Role.OWNER);
        r.setOrganisationName(new SimpleInternationalString("Oracle"));
        r.setContactInfo(ContactImpl.ORACLE);
        r.freeze();
        ORACLE = r;
        r = new ResponsiblePartyImpl(Role.PRINCIPAL_INVESTIGATOR);
        r.setOrganisationName(new SimpleInternationalString("Sun Microsystems"));
        r.setContactInfo(ContactImpl.SUN_MICROSYSTEMS);
        r.freeze();
        SUN_MICROSYSTEMS = r;
        r = new ResponsiblePartyImpl(Role.PRINCIPAL_INVESTIGATOR);
        r.setOrganisationName(new SimpleInternationalString("Geotools"));
        r.setContactInfo(ContactImpl.GEOTOOLS);
        r.freeze();
        GEOTOOLS = r;
    }
}

