/*
 * Decompiled with CFR 0.152.
 */
package jams.components.optimizer.nn;

import jams.components.optimizer.nn.ActivationFunction;
import jams.components.optimizer.nn.GenericFunction;
import jams.components.optimizer.nn.LogisticFunction;
import jams.components.optimizer.nn.NeuralConnection;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Vector;

public class Neuron {
    protected double activation;
    protected double delta;
    protected double error;
    protected double lastInput;
    protected double input;
    protected long ID;
    protected Vector ActivationFunctions = new Vector();
    protected Vector<NeuralConnection> OutputConnection = new Vector();
    protected Vector<NeuralConnection> InputConnection = new Vector();
    protected boolean defaultNeuron = false;
    public static double learningRate = 0.0;

    public Neuron() {
        this.initalize();
    }

    public Neuron(boolean setDefaults) {
        if (setDefaults) {
            this.addFilter(new GenericFunction(new LogisticFunction(0.5)));
            this.defaultNeuron = true;
        } else {
            this.initalize();
        }
    }

    public void setID(long ID) {
        this.ID = ID;
    }

    public void initalize() {
        this.activation = 0.0;
        this.delta = 0.0;
        this.lastInput = 0.0;
    }

    public void reset() {
        this.activation = 0.0;
        this.input = 0.0;
        this.delta = 0.0;
    }

    public void addToInput(double value) {
        this.input += value;
    }

    public void addFilter(GenericFunction af) {
        this.ActivationFunctions.add(af);
    }

    public GenericFunction getFilter(int i) {
        return (GenericFunction)this.ActivationFunctions.get(i);
    }

    public void propagate() {
        this.calc(this.input);
        this.input = 0.0;
        for (int i = 0; i < this.OutputConnection.size(); ++i) {
            NeuralConnection connection = this.OutputConnection.get(i);
            connection.dest.addToInput(this.activation * connection.Weight);
        }
    }

    public void backpropagate() {
        this.calcDelta(this.lastInput, this.error, 1.0);
        this.error = 0.0;
        for (int i = 0; i < this.InputConnection.size(); ++i) {
            NeuralConnection connection = this.InputConnection.get(i);
            connection.src.addToError(this.delta * connection.Weight);
        }
    }

    protected double calc(double value) {
        this.lastInput = this.input;
        if (this.ActivationFunctions.size() == 0) {
            this.activation = this.input;
            return this.activation;
        }
        this.activation = 0.0;
        Enumeration e = this.ActivationFunctions.elements();
        while (e.hasMoreElements()) {
            GenericFunction gc = (GenericFunction)e.nextElement();
            ActivationFunction af = gc.getFunction();
            this.activation += af.calculate(value);
        }
        return this.activation;
    }

    protected double calcDelta(double value, double error, double buffer) {
        this.delta = 0.0;
        if (this.ActivationFunctions.size() == 0) {
            this.delta = error;
            return this.delta;
        }
        Enumeration e = this.ActivationFunctions.elements();
        while (e.hasMoreElements()) {
            GenericFunction gc = (GenericFunction)e.nextElement();
            ActivationFunction af = gc.getDFunction();
            this.delta += af.calculate(value) * error * buffer;
        }
        return this.delta;
    }

    public int getOutgoingConnectionCount() {
        return this.OutputConnection.size();
    }

    public NeuralConnection getConnection(int index) {
        return this.OutputConnection.get(index);
    }

    public double updateWeightDelta() {
        for (int i = 0; i < this.InputConnection.size(); ++i) {
            NeuralConnection connection = this.InputConnection.get(i);
            connection.Weight_Delta += this.delta * connection.src.getActivation() * learningRate;
        }
        return 0.0;
    }

    public double adjustWeight() {
        for (int i = 0; i < this.InputConnection.size(); ++i) {
            NeuralConnection connection = this.InputConnection.get(i);
            connection.update();
        }
        return 0.0;
    }

    public void AddConnection(Neuron Predecessors, Neuron Successor, double weight) {
        NeuralConnection connection = new NeuralConnection();
        connection.Weight = weight;
        connection.Weight_Delta = 0.0;
        connection.src = Predecessors;
        connection.dest = Successor;
        connection.oldWeightDelta = 0.0;
        Predecessors.OutputConnection.add(connection);
        Successor.InputConnection.add(connection);
    }

    public void AddConnection(Neuron Successor, double weight) {
        NeuralConnection connection = new NeuralConnection();
        connection.Weight = weight;
        connection.Weight_Delta = 0.0;
        connection.src = this;
        connection.dest = Successor;
        connection.oldWeightDelta = 0.0;
        this.OutputConnection.add(connection);
        Successor.InputConnection.add(connection);
    }

    public void addToError(double delta) {
        this.error += delta;
    }

    public int getFilterCount() {
        return this.ActivationFunctions.size();
    }

    public double getInput() {
        return this.input;
    }

    public long getID() {
        return this.ID;
    }

    public double getDelta() {
        return this.delta;
    }

    public double getActivation() {
        return this.activation;
    }

    public void resetFunctions() {
        this.ActivationFunctions.clear();
    }

    public void writeData(FileWriter f) {
    }
}

