/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.unijena.jams.JAMS;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSGUIComponent;

@JAMSComponentDescription(title="JAMS execution info frame", author="Sven Kralisch", date="17. June 2006", description="This visual component creates a panel with progress bar and log information")
public class JAMSExecInfo
extends JAMSGUIComponent {
    private JProgressBar jamsProgressBar;
    private JPanel progressPanel;
    private Runnable updatePBar;
    private JScrollPane scrollPanel;
    private JTextArea logArea;
    private int counter;
    private JPanel panel;

    public JPanel getPanel() {
        this.createPanel();
        return this.panel;
    }

    public void init() {
        if (this.panel != null) {
            this.counter = 0;
            this.jamsProgressBar.setMaximum((int)this.getContext().getNumberOfIterations());
            this.jamsProgressBar.setValue(this.counter);
        } else {
            this.updatePBar = new Runnable(){

                @Override
                public void run() {
                }
            };
        }
    }

    private void createPanel() {
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BorderLayout());
        this.jamsProgressBar = new JProgressBar();
        this.jamsProgressBar.setMinimum(0);
        this.jamsProgressBar.setString("Execution progress");
        this.jamsProgressBar.setStringPainted(true);
        this.jamsProgressBar.setIndeterminate(false);
        this.updatePBar = new Runnable(){

            @Override
            public void run() {
                JAMSExecInfo.this.jamsProgressBar.setValue(++JAMSExecInfo.this.counter);
                JAMSExecInfo.this.jamsProgressBar.setString(Math.round(JAMSExecInfo.this.jamsProgressBar.getPercentComplete() * 100.0) + "%");
            }
        };
        this.progressPanel.add((Component)this.jamsProgressBar, "Center");
        this.progressPanel.setPreferredSize(new Dimension(0, 40));
        this.panel.add((Component)this.progressPanel, "North");
        this.scrollPanel = new JScrollPane();
        this.logArea = new JTextArea();
        this.logArea.setColumns(20);
        this.logArea.setRows(5);
        this.logArea.setLineWrap(false);
        this.logArea.setEditable(false);
        this.logArea.setFont(JAMS.STANDARD_FONT);
        this.scrollPanel.setViewportView(this.logArea);
        this.panel.add((Component)this.scrollPanel, "Center");
        this.logArea.append(this.getModel().getRuntime().getInfoLog());
        this.logArea.append(this.getModel().getRuntime().getErrorLog());
        this.getModel().getRuntime().addInfoLogObserver(new Observer(){

            @Override
            public void update(Observable obs, Object obj) {
                JAMSExecInfo.this.logArea.append(obj.toString());
            }
        });
        this.getModel().getRuntime().addErrorLogObserver(new Observer(){

            @Override
            public void update(Observable obs, Object obj) {
                JAMSExecInfo.this.logArea.append(obj.toString());
            }
        });
    }

    public void run() {
        SwingUtilities.invokeLater(this.updatePBar);
    }

    public void cleanup() {
    }
}

