/*
 * Decompiled with CFR 0.152.
 */
package jams.components.efficiencies;

import org.unijena.jams.model.JAMSModel;

public class IndexOfAgreement {
    public static double calc_IOA(double[] prediction, double[] validation, double pow, JAMSModel model) {
        int td_size = prediction.length;
        int vd_size = validation.length;
        if (td_size != vd_size) {
            model.getRuntime().println("Data sets in ioa does not match!");
            return -99999.0;
        }
        int steps = 0;
        double sum_td = 0.0;
        double sum_vd = 0.0;
        if (td_size != vd_size) {
            model.getRuntime().println("Test Data and Verification Data are not consistent!");
            return -9999.0;
        }
        steps = td_size;
        for (int i = 0; i < steps; ++i) {
            sum_td += prediction[i];
            sum_vd += validation[i];
        }
        double mean_td = sum_td / (double)steps;
        double mean_vd = sum_vd / (double)steps;
        double td_vd = 0.0;
        double vd_mean = 0.0;
        for (int i = 0; i < steps; ++i) {
            td_vd += Math.pow(Math.abs(validation[i] - prediction[i]), pow);
            vd_mean += Math.pow(Math.abs(validation[i] - mean_vd), pow);
        }
        double ad_test = 0.0;
        double ad_veri = 0.0;
        double abs_sqDevi = 0.0;
        for (int i = 0; i < steps; ++i) {
            abs_sqDevi += Math.pow(Math.abs(prediction[i] - mean_vd) + Math.abs(validation[i] - mean_vd), pow);
        }
        double ioa = 1.0 - td_vd / abs_sqDevi;
        return ioa;
    }
}

