/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.gui.input;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.unijena.jams.gui.input.InputComponent;

public class FileInput
extends JPanel
implements InputComponent {
    private static final long serialVersionUID = -2171698332789577245L;
    static final int BUTTON_SIZE = 21;
    private JTextField textField;
    private JButton addButton;
    private JFileChooser jfc;

    public FileInput(boolean dirsOnly) {
        this();
        if (dirsOnly) {
            this.jfc.setFileSelectionMode(1);
        }
    }

    public FileInput() {
        BorderLayout layout = new BorderLayout();
        layout.setHgap(5);
        this.setLayout(layout);
        this.textField = new JTextField();
        this.add((Component)this.textField, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        buttonPanel.setPreferredSize(new Dimension(26, 26));
        buttonPanel.setLayout(new FlowLayout());
        this.add((Component)buttonPanel, "East");
        this.addButton = new JButton("...");
        this.addButton.setPreferredSize(new Dimension(21, 21));
        this.addButton.setMargin(new Insets(10, 10, 10, 10));
        this.jfc = new JFileChooser();
        buttonPanel.add(this.addButton);
        this.add((Component)this.addButton, "East");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int result = FileInput.this.jfc.showOpenDialog(FileInput.this);
                if (result == 0) {
                    String stringValue = FileInput.this.jfc.getSelectedFile().getAbsolutePath();
                    FileInput.this.textField.setText(stringValue);
                }
            }
        });
    }

    public void setFile(String fileName) {
        if (fileName == null) {
            fileName = "";
        }
        this.textField.setText(fileName);
        File file = new File(fileName).getParentFile();
        this.jfc.setCurrentDirectory(file);
    }

    public String getFile() {
        return this.textField.getText();
    }

    @Override
    public String getValue() {
        return this.getFile();
    }

    @Override
    public void setValue(String value) {
        this.setFile(value);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setRange(double lower, double upper) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
    }

    @Override
    public boolean verify() {
        return true;
    }

    @Override
    public int getErrorCode() {
        return 0;
    }
}

