/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;

public class FilterAttributeExtractor
implements FilterVisitor {
    protected Set attributeNames = new HashSet();

    public Set getAttributeNameSet() {
        return Collections.unmodifiableSet(this.attributeNames);
    }

    public String[] getAttributeNames() {
        return this.attributeNames.toArray(new String[this.attributeNames.size()]);
    }

    public void clear() {
        this.attributeNames = new HashSet();
    }

    public void visit(Filter filter) {
        if (filter instanceof BetweenFilter) {
            this.visit((BetweenFilter)filter);
        } else if (filter instanceof CompareFilter) {
            this.visit((CompareFilter)filter);
        } else if (filter instanceof GeometryFilter) {
            this.visit((GeometryFilter)filter);
        } else if (filter instanceof LikeFilter) {
            this.visit((LikeFilter)filter);
        } else if (filter instanceof LogicFilter) {
            this.visit((LogicFilter)filter);
        } else if (filter instanceof NullFilter) {
            this.visit((NullFilter)filter);
        } else if (filter instanceof FidFilter) {
            this.visit((FidFilter)filter);
        }
    }

    public void visit(BetweenFilter filter) {
        if (filter.getLeftValue() != null) {
            filter.getLeftValue().accept((FilterVisitor)this);
        }
        if (filter.getRightValue() != null) {
            filter.getRightValue().accept((FilterVisitor)this);
        }
        if (filter.getMiddleValue() != null) {
            filter.getMiddleValue().accept((FilterVisitor)this);
        }
    }

    public void visit(CompareFilter filter) {
        if (filter.getLeftValue() != null) {
            filter.getLeftValue().accept((FilterVisitor)this);
        }
        if (filter.getRightValue() != null) {
            filter.getRightValue().accept((FilterVisitor)this);
        }
    }

    public void visit(GeometryFilter filter) {
        if (filter.getLeftGeometry() != null) {
            filter.getLeftGeometry().accept((FilterVisitor)this);
        }
        if (filter.getRightGeometry() != null) {
            filter.getRightGeometry().accept((FilterVisitor)this);
        }
    }

    public void visit(LikeFilter filter) {
        if (filter.getValue() != null) {
            filter.getValue().accept((FilterVisitor)this);
        }
    }

    public void visit(LogicFilter filter) {
        Iterator it = filter.getFilterIterator();
        while (it.hasNext()) {
            Filter f = (Filter)it.next();
            f.accept((FilterVisitor)this);
        }
    }

    public void visit(NullFilter filter) {
        if (filter.getNullCheckValue() != null) {
            filter.getNullCheckValue().accept((FilterVisitor)this);
        }
    }

    public void visit(FidFilter filter) {
    }

    public void visit(AttributeExpression expression) {
        this.attributeNames.add(expression.getAttributePath());
    }

    public void visit(Expression expression) {
        if (expression instanceof AttributeExpression) {
            this.visit((AttributeExpression)expression);
        } else if (expression instanceof LiteralExpression) {
            this.visit((LiteralExpression)expression);
        } else if (expression instanceof MathExpression) {
            this.visit((MathExpression)expression);
        } else if (expression instanceof FunctionExpression) {
            this.visit((FunctionExpression)expression);
        }
    }

    public void visit(LiteralExpression expression) {
    }

    public void visit(MathExpression expression) {
        if (expression.getLeftValue() != null) {
            expression.getLeftValue().accept((FilterVisitor)this);
        }
        if (expression.getRightValue() != null) {
            expression.getRightValue().accept((FilterVisitor)this);
        }
    }

    public void visit(FunctionExpression expression) {
        Expression[] args = expression.getArgs();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            args[i].accept((FilterVisitor)this);
        }
    }
}

