/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.gui.input;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.unijena.jams.gui.input.InputComponent;

public class IntegerInput
extends JPanel
implements InputComponent {
    private static final long serialVersionUID = 3847882766368890438L;
    JTextField text = new JTextField();

    public IntegerInput() {
        this.setRange(-2.147483648E9, 2.147483647E9);
        this.setLayout(new BorderLayout());
        this.add((Component)this.text, "West");
    }

    @Override
    public String getValue() {
        return this.text.getText();
    }

    @Override
    public void setValue(String value) {
        this.text.setText(value);
    }

    @Override
    public JComponent getComponent() {
        return this.text;
    }

    @Override
    public void setRange(double lower, double upper) {
        this.setInputVerifier(new LongIntervalVerifier((long)lower, (long)upper));
    }

    @Override
    public boolean verify() {
        return this.getInputVerifier().verify(this.text);
    }

    @Override
    public int getErrorCode() {
        return ((LongIntervalVerifier)this.getInputVerifier()).result;
    }

    class LongIntervalVerifier
    extends InputVerifier {
        long lower;
        long upper;
        int result;

        public LongIntervalVerifier(long lower, long upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public boolean verify(JComponent input) {
            try {
                long value = Long.parseLong(((JTextField)input).getText());
                if (value >= this.lower && value <= this.upper) {
                    boolean result = false;
                    return true;
                }
                int result = -2;
                return false;
            }
            catch (NumberFormatException nfe) {
                int result = -1;
                return false;
            }
        }
    }
}

