/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui.spreadsheet;

import jams.components.gui.spreadsheet.CTSConfigurator;
import jams.components.gui.spreadsheet.JAMSTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSStringArray;
import org.unijena.jams.gui.LHelper;
import org.unijena.jams.model.JAMSGUIComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class JAMSSpreadSheet
extends JAMSGUIComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Column Name Array")
    public JAMSStringArray headers;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array with data of one row")
    public JAMSDouble[] rowarray;
    private final String title = "JAMSSpreadSheet v0.90";
    private JPanel panel = new JPanel();
    private String panelname = "spreadsheet";
    private int numberOfColumns = 0;
    private boolean timeRuns = false;
    private boolean ctsIsOpen = false;
    private Vector<Vector> data = new Vector();
    private Vector<String> colnames = new Vector();
    private double[] rowdata;
    GridBagLayout panellayout = new GridBagLayout();
    GridBagConstraints grid = new GridBagConstraints();
    private JScrollPane scrollpane = new JScrollPane();
    private JButton calcbutton = new JButton("Calculate");
    private JButton openbutton = new JButton("Import");
    private JButton savebutton = new JButton("Export");
    private JButton plotButton = new JButton("Time Plot");
    private JLabel headerlabel = new JLabel();
    private JLabel titleLabel = new JLabel("JAMSSpreadSheet v0.90");
    private JLabel calclabel = new JLabel("calclabel");
    private JLabel label2 = new JLabel();
    private JLabel opensavealert = new JLabel("");
    private JLabel plotalert = new JLabel();
    private JCheckBox onthefly = new JCheckBox("On the fly", false);
    private JTextField editField = new JTextField();
    private JAMSTableModel tmodel;
    JTable table;
    private String[] calclist = new String[]{"Sum    ", "Mean   "};
    JComboBox calculations = new JComboBox<String>(this.calclist);
    private int kindofcalc = 0;
    ActionListener calcbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAMSSpreadSheet.this.kindofcalc = JAMSSpreadSheet.this.calculations.getSelectedIndex();
            if (JAMSSpreadSheet.this.kindofcalc == 0) {
                JAMSSpreadSheet.this.calclabel.setText("Sum: " + JAMSSpreadSheet.this.calcsum());
            }
            if (JAMSSpreadSheet.this.kindofcalc == 1) {
                JAMSSpreadSheet.this.calclabel.setText("Mean: " + JAMSSpreadSheet.this.calcmean());
            }
        }
    };
    ActionListener saveAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAMSSpreadSheet.this.save();
        }
    };
    ActionListener openAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int result = LHelper.showYesNoCancelDlg((Component)JAMSSpreadSheet.this.getModel().getRuntime().getFrame(), (String)"Do you want to save this sheet before?", (String)"Attention");
            if (result == 0) {
                JAMSSpreadSheet.this.save();
                JAMSSpreadSheet.this.open();
            }
            if (result == 1) {
                JAMSSpreadSheet.this.open();
            }
        }
    };
    ActionListener plotAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAMSSpreadSheet.this.openCTS();
        }
    };

    public JPanel getPanel() {
        return this.panel;
    }

    public void init() {
        this.tmodel = new JAMSTableModel();
        this.createPanel();
        this.updateGUI();
    }

    public void save() {
        int colcount = this.tmodel.getColumnCount();
        int rowcount = this.tmodel.getRowCount();
        String[] columnNames = this.tmodel.getCoulumnNameArray();
        try {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showSaveDialog(this.panel);
            File file = chooser.getSelectedFile();
            FileWriter filewriter = new FileWriter(file);
            for (int j = 0; j < colcount; ++j) {
                filewriter.write(columnNames[j], 0, columnNames[j].length());
                filewriter.write("\t");
            }
            filewriter.write("\r\n#");
            filewriter.write("\r\n");
            for (int k = 0; k < rowcount; ++k) {
                for (int i = 0; i < colcount; ++i) {
                    String value = this.table.getValueAt(k, i).toString();
                    filewriter.write(value, 0, value.length());
                    filewriter.write("\t");
                }
                filewriter.write("\r\n");
            }
            filewriter.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public void open() {
        String text = "";
        String rowtext = "";
        String itemtext = "";
        String[] headerBuff = new String[256];
        int colNumber = 0;
        double[] rowBuffer = null;
        String[] headers = null;
        Vector<double[]> arrayVector = new Vector<double[]>();
        Vector<JAMSCalendar> timeVector = new Vector<JAMSCalendar>();
        boolean headerSet = false;
        int line = 0;
        int k = 0;
        this.tmodel = new JAMSTableModel();
        this.tmodel.setTimeRuns(true);
        this.timeRuns = true;
        try {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showOpenDialog(this.panel);
            File file = chooser.getSelectedFile();
            FileReader fReader = new FileReader(file);
            StringBuffer stBuff = new StringBuffer();
            char[] c = new char[100];
            while (fReader.ready()) {
                int i = fReader.read(c, 0, c.length);
                stBuff.append(c, 0, i);
            }
            fReader.close();
            text = stBuff.toString();
        }
        catch (IOException ex) {
            System.out.println("Lesen fehlgeschlagen!");
        }
        StringTokenizer row = new StringTokenizer(text, "\r\n");
        while (row.hasMoreTokens()) {
            rowtext = row.nextToken();
            StringTokenizer item = new StringTokenizer(rowtext, "\t");
            while (item.hasMoreTokens()) {
                itemtext = item.nextToken();
                try {
                    if (line == 0) {
                        headerBuff[k] = itemtext;
                        ++colNumber;
                    } else if (line == 1) {
                        headers = new String[colNumber];
                        for (int l = 0; l < colNumber; ++l) {
                            headers[l] = headerBuff[l];
                        }
                        rowBuffer = null;
                    } else if (k == 0) {
                        JAMSCalendar timeval = new JAMSCalendar();
                        timeval.setValue(itemtext);
                        timeVector.add(timeval);
                    } else {
                        rowBuffer[k - 1] = new Double(itemtext);
                    }
                }
                catch (NullPointerException ne) {
                    // empty catch block
                }
                ++k;
            }
            if (rowBuffer != null) {
                arrayVector.add(rowBuffer);
            }
            rowBuffer = new double[colNumber - 1];
            k = 0;
            ++line;
        }
        this.tmodel = new JAMSTableModel();
        this.tmodel.setTimeRuns(true);
        this.timeRuns = true;
        this.tmodel.setTimeVector(timeVector);
        this.tmodel.setNewDataVector(arrayVector);
        String headertest = "";
        this.tmodel.setColumnNames(headers);
        this.updateGUI();
    }

    private void openCTS() {
        CTSConfigurator cts = new CTSConfigurator(this.getModel().getRuntime().getFrame(), this.table);
    }

    private void createEmptyTimePlot(int graphCount) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        TimeSeries[] ts = new TimeSeries[graphCount];
        Vector timevector = new Vector();
        String yAxisName = "";
        for (int k = 0; k < graphCount; ++k) {
            ts[k] = new TimeSeries("timeseriesname", Second.class);
        }
        try {
            JFreeChart testchart = ChartFactory.createTimeSeriesChart((String)this.getInstanceName(), (String)"time", (String)yAxisName, (XYDataset)dataset, (boolean)false, (boolean)false, (boolean)false);
            ChartPanel chartPanel = new ChartPanel(testchart);
            JDialog frame = new JDialog();
            frame.setLayout(new FlowLayout());
            frame.add((Component)chartPanel);
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception pe) {
            System.err.println(pe.toString() + " plot failure");
        }
    }

    private double calcsum() {
        double sum = 0.0;
        int[] rows = this.table.getSelectedRows();
        int ix = rows.length;
        int[] columns = this.table.getSelectedColumns();
        int kx = columns.length;
        for (int k = 0; k < kx; ++k) {
            for (int i = 0; i < ix; ++i) {
                if (this.table.getValueAt(rows[i], columns[k]).getClass() != String.class) {
                    sum += ((Double)this.table.getValueAt(rows[i], columns[k])).doubleValue();
                    continue;
                }
                sum += 0.0;
            }
        }
        return sum;
    }

    private double calcmean() {
        double sum = 0.0;
        int[] rows = this.table.getSelectedRows();
        int ix = rows.length;
        int[] columns = this.table.getSelectedColumns();
        int kx = columns.length;
        for (int k = 0; k < kx; ++k) {
            for (int i = 0; i < ix; ++i) {
                if (this.table.getValueAt(rows[i], columns[k]).getClass() != String.class) {
                    sum += ((Double)this.table.getValueAt(rows[i], columns[k])).doubleValue();
                    continue;
                }
                sum += 0.0;
            }
        }
        double mean = 0.0;
        if (ix == 1) {
            mean = sum / (double)kx;
        }
        if (kx == 1) {
            mean = sum / (double)ix;
        }
        if (kx != 1 && ix != 1) {
            mean = sum / (double)(kx * ix);
        }
        return sum;
    }

    public String getPanelName() {
        String name = this.panelname;
        return name;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
    }

    public void setColumnNameArray(String[] names) {
        this.tmodel.setColumnNames(names);
    }

    public void addRowArray(double[] data) {
    }

    public void updateValue(double value, int rowIndex, int columnIndex) {
    }

    public void updateGUI() {
        this.table.setModel(this.tmodel);
        this.scrollpane.setViewportView(this.table);
        this.panel.repaint();
    }

    public void makeTable() {
        this.table = this.table = new JTable(this.tmodel);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(true);
        this.table.setDragEnabled(false);
        this.table.setCellSelectionEnabled(true);
    }

    public void createPanel() {
        this.panel.setLayout(new BorderLayout(10, 10));
        JPanel controlpanel = new JPanel();
        controlpanel.setLayout(new GridLayout(8, 1, 24, 24));
        JPanel headerpanel = new JPanel();
        headerpanel.setLayout(new GridLayout(1, 2));
        if (this.time != null) {
            this.tmodel.setTimeRuns(true);
            String[] colheads = new String[this.headers.getValue().length + 1];
            colheads[0] = "Time [yyyy-mm-dd hh:ss]";
            for (int i = 1; i <= this.headers.getValue().length; ++i) {
                colheads[i] = this.headers.getValue()[i - 1];
            }
            this.setColumnNameArray(colheads);
        } else {
            this.setColumnNameArray(this.headers.getValue());
        }
        this.makeTable();
        controlpanel.add(this.openbutton);
        controlpanel.add(this.savebutton);
        controlpanel.add(this.onthefly);
        controlpanel.add(this.plotButton);
        this.openbutton.addActionListener(this.openAction);
        this.savebutton.addActionListener(this.saveAction);
        this.plotButton.addActionListener(this.plotAction);
        headerpanel.add(this.titleLabel);
        headerpanel.add(this.headerlabel);
        this.panel.add((Component)headerpanel, "North");
        this.panel.add((Component)this.scrollpane, "Center");
        this.panel.add((Component)controlpanel, "East");
    }

    private GridBagConstraints makegrid(int xpos, int ypos, int width, int height) {
        GridBagConstraints grid = new GridBagConstraints();
        grid.gridx = xpos;
        grid.gridy = ypos;
        grid.gridwidth = width;
        grid.gridheight = height;
        grid.insets = new Insets(0, 0, 0, 0);
        return grid;
    }

    public void addCurrentTime() {
        this.tmodel.addTime(this.time);
    }

    public void addTime(JAMSCalendar time) {
        this.tmodel.addTime(time);
    }

    public void run() {
        if (this.time == null) {
            this.rowdata = new double[this.rowarray.length];
            for (int i = 0; i < this.rowarray.length; ++i) {
                this.rowdata[i] = this.rowarray[i].getValue();
            }
            this.timeRuns = false;
        } else {
            this.timeRuns = true;
            this.addCurrentTime();
        }
        this.tmodel.addRowArray(this.rowarray);
        if (this.onthefly.isSelected()) {
            this.updateGUI();
        }
    }

    public void cleanup() {
        this.updateGUI();
    }
}

