/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.coverage.grid.AbstractGridCoverage2DReader;
import org.geotools.factory.FactoryConfigurationError;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.map.event.MapBoundsEvent;
import org.geotools.map.event.MapBoundsListener;
import org.geotools.map.event.MapLayerEvent;
import org.geotools.map.event.MapLayerListEvent;
import org.geotools.map.event.MapLayerListListener;
import org.geotools.map.event.MapLayerListener;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.CRSUtilities;
import org.geotools.styling.Style;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class DefaultMapContext
implements MapContext {
    public static final Logger LOGGER = Logger.getLogger("org.geotools.map");
    List layerList = new ArrayList(10);
    CoordinateReferenceSystem crs = null;
    ReferencedEnvelope areaOfInterest = null;
    protected EventListenerList listenerList = null;
    protected MapLayerListener layerListener = new MapLayerListener(){

        public void layerChanged(MapLayerEvent event) {
            this.fireAsListEvent(event);
        }

        public void layerShown(MapLayerEvent event) {
            this.fireAsListEvent(event);
        }

        public void layerHidden(MapLayerEvent event) {
            this.fireAsListEvent(event);
        }

        private void fireAsListEvent(MapLayerEvent event) {
            MapLayer layer = (MapLayer)event.getSource();
            int position = DefaultMapContext.this.layerList.indexOf(layer);
            DefaultMapContext.this.fireMapLayerListListenerLayerChanged(new MapLayerListEvent((MapContext)DefaultMapContext.this, layer, position, event));
        }
    };
    protected String abstracts;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected String contactInformation;
    protected String[] keywords;
    protected String title;
    private ReferencedEnvelope bounds = null;

    public DefaultMapContext() {
        this.crs = DefaultGeographicCRS.WGS84;
        this.title = "";
        this.abstracts = "";
        this.contactInformation = "";
        this.keywords = new String[0];
    }

    public DefaultMapContext(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.title = "";
        this.abstracts = "";
        this.contactInformation = "";
        this.keywords = new String[0];
    }

    public DefaultMapContext(MapLayer[] layers) {
        this();
        this.setTitle(this.title);
        this.addLayers(layers);
    }

    public DefaultMapContext(MapLayer[] layers, CoordinateReferenceSystem crs) {
        this();
        this.crs = crs;
        this.setTitle(this.title);
        this.addLayers(layers);
    }

    public DefaultMapContext(MapLayer[] layers, String title, String contextAbstract, String contactInformation, String[] keywords) {
        this(layers);
        this.setTitle(title);
        this.setAbstract(contextAbstract);
        this.setContactInformation(contactInformation);
        this.setKeywords(keywords);
    }

    public DefaultMapContext(MapLayer[] layers, String title, String contextAbstract, String contactInformation, String[] keywords, CoordinateReferenceSystem crs) {
        this(layers);
        this.crs = crs;
        this.setTitle(title);
        this.setAbstract(contextAbstract);
        this.setContactInformation(contactInformation);
        this.setKeywords(keywords);
    }

    public boolean addLayer(int index, MapLayer layer) {
        if (this.layerList.contains(layer)) {
            return false;
        }
        this.layerList.add(index, layer);
        layer.addMapLayerListener(this.layerListener);
        this.bounds = null;
        this.fireMapLayerListListenerLayerAdded(new MapLayerListEvent(this, layer, index));
        return true;
    }

    public boolean addLayer(MapLayer layer) {
        if (this.layerList.contains(layer)) {
            return false;
        }
        this.layerList.add(layer);
        layer.addMapLayerListener(this.layerListener);
        this.bounds = null;
        this.fireMapLayerListListenerLayerAdded(new MapLayerListEvent(this, layer, this.indexOf(layer)));
        return true;
    }

    public void addLayer(FeatureSource featureSource, Style style) {
        this.addLayer(new DefaultMapLayer(featureSource, style, ""));
    }

    public void addLayer(GridCoverage gc, Style style) {
        try {
            this.addLayer(DataUtilities.wrapGc(gc), style);
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Could not use gc", e);
        }
        catch (FactoryConfigurationError e) {
            LOGGER.log(Level.WARNING, "Could not use gc", e);
        }
        catch (SchemaException e) {
            LOGGER.log(Level.WARNING, "Could not use gc", e);
        }
        catch (IllegalAttributeException e) {
            LOGGER.log(Level.WARNING, "Could not use gc", e);
        }
    }

    public void addLayer(AbstractGridCoverage2DReader reader, Style style) {
        try {
            this.addLayer(DataUtilities.wrapGcReader(reader, null), style);
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Could not use gc", e);
        }
        catch (FactoryConfigurationError e) {
            LOGGER.log(Level.WARNING, "Could not use gc", e);
        }
        catch (SchemaException e) {
            LOGGER.log(Level.WARNING, "Could not use gc", e);
        }
        catch (IllegalAttributeException e) {
            LOGGER.log(Level.WARNING, "Could not use gc", e);
        }
    }

    public void addLayer(FeatureCollection collection, Style style) {
        this.addLayer(new DefaultMapLayer(collection, style, ""));
    }

    public boolean removeLayer(MapLayer layer) {
        int index = this.indexOf(layer);
        if (index == -1) {
            return false;
        }
        this.removeLayer(index);
        return true;
    }

    public MapLayer removeLayer(int index) {
        MapLayer layer = (MapLayer)this.layerList.remove(index);
        layer.removeMapLayerListener(this.layerListener);
        this.bounds = null;
        this.fireMapLayerListListenerLayerRemoved(new MapLayerListEvent(this, layer, index));
        return layer;
    }

    public int addLayers(MapLayer[] layers) {
        if (layers == null || layers.length == 0) {
            return 0;
        }
        int layerAdded = 0;
        MapLayer lastLayer = null;
        int length = layers.length;
        for (int i = 0; i < length; ++i) {
            if (this.layerList.contains(layers[i])) continue;
            this.layerList.add(layers[i]);
            ++layerAdded;
            lastLayer = layers[i];
            layers[i].addMapLayerListener(this.layerListener);
        }
        if (layerAdded > 0) {
            this.bounds = null;
            int fromIndex = this.layerList.size() - layerAdded;
            int toIndex = this.layerList.size() - 1;
            if (layerAdded == 1) {
                this.fireMapLayerListListenerLayerAdded(new MapLayerListEvent((MapContext)this, lastLayer, fromIndex, toIndex));
            } else {
                this.fireMapLayerListListenerLayerAdded(new MapLayerListEvent((MapContext)this, null, fromIndex, toIndex));
            }
        }
        return layerAdded;
    }

    public void removeLayers(MapLayer[] layers) {
        int i;
        if (layers == null || layers.length == 0 || this.layerList.size() == 0) {
            return;
        }
        int fromIndex = this.layerList.size();
        int toIndex = 0;
        int layersRemoved = 0;
        int length = layers.length;
        for (i = 0; i < length; ++i) {
            int index = this.layerList.indexOf(layers[i]);
            if (index == -1) continue;
            ++layersRemoved;
            if (index < fromIndex) {
                fromIndex = index;
            }
            if (index <= toIndex) continue;
            toIndex = index;
        }
        if (layersRemoved == 0) {
            return;
        }
        for (i = 0; i < layersRemoved; ++i) {
            if (!this.layerList.remove(layers[i])) continue;
            layers[i].removeMapLayerListener(this.layerListener);
        }
        this.bounds = null;
        this.fireMapLayerListListenerLayerRemoved(new MapLayerListEvent((MapContext)this, null, fromIndex, toIndex));
    }

    public MapLayer[] getLayers() {
        MapLayer[] layers = new MapLayer[this.layerList.size()];
        return this.layerList.toArray(layers);
    }

    public MapLayer getLayer(int index) throws IndexOutOfBoundsException {
        return (MapLayer)this.layerList.get(index);
    }

    public int indexOf(MapLayer layer) {
        return this.layerList.indexOf(layer);
    }

    public Iterator iterator() {
        return this.layerList.iterator();
    }

    public ReferencedEnvelope getLayerBounds() throws IOException {
        if (this.bounds != null) {
            return this.bounds;
        }
        if (this.crs == null) {
            throw new NullPointerException("CRS of this map context is null. Unable to get bounds.");
        }
        ReferencedEnvelope result = null;
        int length = this.layerList.size();
        for (int i = 0; i < length; ++i) {
            MapLayer layer = (MapLayer)this.layerList.get(i);
            FeatureSource fs = layer.getFeatureSource();
            CoordinateReferenceSystem sourceCrs = fs.getSchema().getDefaultGeometry().getCoordinateSystem();
            ReferencedEnvelope env = new ReferencedEnvelope(fs.getBounds(), sourceCrs);
            if (env == null) continue;
            try {
                if (sourceCrs != null && this.crs != null && !CRSUtilities.equalsIgnoreMetadata((Object)sourceCrs, (Object)this.crs)) {
                    env = env.transform(this.crs, true);
                }
            }
            catch (FactoryException e) {
                LOGGER.log(Level.SEVERE, "Data source and map context coordinate system differ, yet it was not possible to get a projected bounds estimate...", e);
            }
            catch (TransformException e) {
                LOGGER.log(Level.SEVERE, "Data source and map context coordinate system differ, yet it was not possible to get a projected bounds estimate...", e);
            }
            if (result == null) {
                result = env;
                continue;
            }
            result.expandToInclude(env);
        }
        return result;
    }

    public void setAreaOfInterest(Envelope areaOfInterest, CoordinateReferenceSystem coordinateReferenceSystem) throws IllegalArgumentException {
        if (areaOfInterest == null || coordinateReferenceSystem == null) {
            throw new IllegalArgumentException("Input arguments cannot be null");
        }
        ReferencedEnvelope oldAreaOfInterest = this.areaOfInterest;
        CoordinateReferenceSystem oldCrs = this.crs;
        this.areaOfInterest = new ReferencedEnvelope(areaOfInterest, coordinateReferenceSystem);
        this.crs = coordinateReferenceSystem;
        this.bounds = null;
        this.fireMapBoundsListenerMapBoundsChanged(new MapBoundsEvent(this, 3, oldAreaOfInterest, oldCrs));
    }

    public void setAreaOfInterest(Envelope areaOfInterest) {
        if (areaOfInterest == null) {
            throw new IllegalArgumentException("Input argument cannot be null");
        }
        ReferencedEnvelope oldAreaOfInterest = this.areaOfInterest;
        this.areaOfInterest = new ReferencedEnvelope(areaOfInterest, this.crs);
        LOGGER.info("USing a deprecated method!");
        this.fireMapBoundsListenerMapBoundsChanged(new MapBoundsEvent(this, 1, oldAreaOfInterest, this.crs));
    }

    public ReferencedEnvelope getAreaOfInterest() {
        if (this.areaOfInterest == null) {
            try {
                ReferencedEnvelope e = this.getLayerBounds();
                if (e == null) {
                    return null;
                }
                this.areaOfInterest = new ReferencedEnvelope(e, this.crs);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Can't get layer bounds, and area of interest is not set", e);
                return null;
            }
        }
        if (this.areaOfInterest == null) {
            return null;
        }
        return this.areaOfInterest;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void transform(AffineTransform transform) {
        ReferencedEnvelope oldAreaOfInterest = this.areaOfInterest;
        double[] coords = new double[]{this.areaOfInterest.getMinX(), this.areaOfInterest.getMinY(), this.areaOfInterest.getMaxX(), this.areaOfInterest.getMaxY()};
        transform.transform(coords, 0, coords, 0, 2);
        this.areaOfInterest = new ReferencedEnvelope(coords[0], coords[2], coords[1], coords[3], this.crs);
        this.fireMapBoundsListenerMapBoundsChanged(new MapBoundsEvent(this, 1, oldAreaOfInterest, this.crs));
    }

    public void moveLayer(int sourcePosition, int destPosition) {
        if (sourcePosition < 0 || sourcePosition >= this.layerList.size()) {
            throw new IndexOutOfBoundsException("Source position " + sourcePosition + " out of bounds");
        }
        if (destPosition < 0 || destPosition >= this.layerList.size()) {
            throw new IndexOutOfBoundsException("Destination position " + destPosition + " out of bounds");
        }
        MapLayer layer = (MapLayer)this.layerList.remove(sourcePosition);
        this.layerList.add(destPosition, layer);
        this.fireMapLayerListListenerLayerMoved(new MapLayerListEvent((MapContext)this, layer, Math.min(sourcePosition, destPosition), Math.max(sourcePosition, destPosition)));
    }

    public void clearLayerList() {
        int size = this.layerList.size();
        for (int i = 0; i < size; ++i) {
            MapLayer layer = (MapLayer)this.layerList.get(i);
            layer.removeMapLayerListener(this.layerListener);
        }
        this.layerList.clear();
        this.bounds = null;
        this.fireMapLayerListListenerLayerRemoved(new MapLayerListEvent((MapContext)this, null, 0, 1));
    }

    public int getLayerCount() {
        return this.layerList.size();
    }

    public String getAbstract() {
        return this.abstracts;
    }

    public void setAbstract(String abstractValue) {
        if (abstractValue == null) {
            throw new NullPointerException();
        }
        String oldAbstracts = this.abstracts;
        this.abstracts = abstractValue;
        this.propertyChangeSupport.firePropertyChange("abstract", oldAbstracts, this.abstracts);
    }

    public String getContactInformation() {
        return this.contactInformation;
    }

    public void setContactInformation(String contactInformation) {
        if (contactInformation == null) {
            throw new NullPointerException();
        }
        String oldContactInformation = this.contactInformation;
        this.contactInformation = contactInformation;
        this.propertyChangeSupport.firePropertyChange("contactInformation", oldContactInformation, contactInformation);
    }

    public String[] getKeywords() {
        if (this.keywords.length == 0) {
            return this.keywords;
        }
        String[] copy = new String[this.keywords.length];
        System.arraycopy(this.keywords, 0, copy, 0, this.keywords.length);
        return copy;
    }

    public void setKeywords(String[] keywords) {
        if (keywords == null) {
            throw new NullPointerException();
        }
        String[] oldKeywords = this.keywords;
        this.keywords = keywords;
        this.propertyChangeSupport.firePropertyChange("keywords", oldKeywords, keywords);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new NullPointerException();
        }
        String oldTitle = this.title;
        this.title = title;
        this.propertyChangeSupport.firePropertyChange("title", oldTitle, title);
    }

    public synchronized void addMapLayerListListener(MapLayerListListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(MapLayerListListener.class, listener);
    }

    public synchronized void removeMapLayerListListener(MapLayerListListener listener) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(MapLayerListListener.class, listener);
    }

    private void fireMapLayerListListenerLayerAdded(MapLayerListEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$geotools$map$event$MapLayerListListener == null ? DefaultMapContext.class$("org.geotools.map.event.MapLayerListListener") : class$org$geotools$map$event$MapLayerListListener)) continue;
            ((MapLayerListListener)listeners[i + 1]).layerAdded(event);
        }
    }

    private void fireMapLayerListListenerLayerRemoved(MapLayerListEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$geotools$map$event$MapLayerListListener == null ? DefaultMapContext.class$("org.geotools.map.event.MapLayerListListener") : class$org$geotools$map$event$MapLayerListListener)) continue;
            ((MapLayerListListener)listeners[i + 1]).layerRemoved(event);
        }
    }

    private void fireMapLayerListListenerLayerChanged(MapLayerListEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$geotools$map$event$MapLayerListListener == null ? DefaultMapContext.class$("org.geotools.map.event.MapLayerListListener") : class$org$geotools$map$event$MapLayerListListener)) continue;
            ((MapLayerListListener)listeners[i + 1]).layerChanged(event);
        }
    }

    private void fireMapLayerListListenerLayerMoved(MapLayerListEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$geotools$map$event$MapLayerListListener == null ? DefaultMapContext.class$("org.geotools.map.event.MapLayerListListener") : class$org$geotools$map$event$MapLayerListListener)) continue;
            ((MapLayerListListener)listeners[i + 1]).layerMoved(event);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listenerList == null) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addMapBoundsListener(MapBoundsListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(MapBoundsListener.class, listener);
    }

    public synchronized void removeMapBoundsListener(MapBoundsListener listener) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(MapBoundsListener.class, listener);
    }

    private void fireMapBoundsListenerMapBoundsChanged(MapBoundsEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$geotools$map$event$MapBoundsListener == null ? DefaultMapContext.class$("org.geotools.map.event.MapBoundsListener") : class$org$geotools$map$event$MapBoundsListener)) continue;
            ((MapBoundsListener)listeners[i + 1]).mapBoundsChanged(event);
        }
    }

    public void setAreaOfInterest(ReferencedEnvelope areaOfInterest) {
        if (areaOfInterest == null) {
            throw new IllegalArgumentException("Input argument cannot be null");
        }
        ReferencedEnvelope oldAreaOfInterest = this.areaOfInterest;
        CoordinateReferenceSystem tempCRS = areaOfInterest.getCoordinateReferenceSystem();
        if (tempCRS == null) {
            throw new IllegalArgumentException("CRS of the provided AOI cannot be null");
        }
        CoordinateReferenceSystem oldCRS = this.crs;
        this.crs = tempCRS;
        this.areaOfInterest = new ReferencedEnvelope(areaOfInterest, this.crs);
        this.bounds = null;
        this.fireMapBoundsListenerMapBoundsChanged(new MapBoundsEvent(this, 3, oldAreaOfInterest, oldCRS));
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) throws TransformException, FactoryException {
        if (crs == null) {
            throw new IllegalArgumentException("Input argument cannot be null");
        }
        ReferencedEnvelope oldBounds = this.areaOfInterest;
        CoordinateReferenceSystem oldCRS = this.crs;
        this.bounds = null;
        if (!CRSUtilities.equalsIgnoreMetadata((Object)crs, (Object)this.crs) && this.areaOfInterest != null) {
            this.areaOfInterest = this.areaOfInterest.transform(crs, true);
        }
        this.crs = crs;
        this.bounds = null;
        this.fireMapBoundsListenerMapBoundsChanged(new MapBoundsEvent(this, 2, oldBounds, oldCRS));
    }
}

