/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.IllegalFilterException;

public class UniqueVisitor
implements FeatureCalc {
    private Expression expr;
    Set set = new HashSet();

    public UniqueVisitor(String attributeTypeName) {
        FilterFactory factory = FilterFactoryFinder.createFilterFactory();
        this.expr = factory.createAttributeExpression(attributeTypeName);
    }

    public UniqueVisitor(int attributeTypeIndex, FeatureType type) throws IllegalFilterException {
        FilterFactory factory = FilterFactoryFinder.createFilterFactory();
        this.expr = factory.createAttributeExpression(type.getAttributeType(attributeTypeIndex).getName());
    }

    public UniqueVisitor(String attrName, FeatureType type) throws IllegalFilterException {
        FilterFactory factory = FilterFactoryFinder.createFilterFactory();
        this.expr = factory.createAttributeExpression(type.getAttributeType(attrName).getName());
    }

    public UniqueVisitor(Expression expr) {
        this.expr = expr;
    }

    public void visit(Feature feature) {
        Object value = this.expr.getValue(feature);
        if (value != null) {
            this.set.add(value);
        }
    }

    public Expression getExpression() {
        return this.expr;
    }

    public Set getUnique() {
        return this.set;
    }

    public void setValue(Object newSet) {
        if (newSet instanceof ArrayList) {
            ArrayList newList = (ArrayList)newSet;
            HashSet anotherSet = new HashSet();
            ListIterator i = newList.listIterator();
            while (i.hasNext()) {
                anotherSet.add(i.next());
            }
            this.set = anotherSet;
        } else {
            this.set = (Set)newSet;
        }
    }

    public void reset() {
        this.set = new HashSet();
    }

    public CalcResult getResult() {
        if (this.set.size() < 1) {
            return null;
        }
        return new UniqueResult(this.set);
    }

    public static class UniqueResult
    extends AbstractCalcResult {
        private Set unique;

        public UniqueResult(Set newSet) {
            this.unique = newSet;
        }

        public Object getValue() {
            return new HashSet(this.unique);
        }

        public boolean isCompatible(CalcResult targetResults) {
            return targetResults instanceof UniqueResult;
        }

        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd instanceof UniqueResult) {
                HashSet newSet = new HashSet(this.unique);
                newSet.addAll((Set)resultsToAdd.getValue());
                return new UniqueResult(newSet);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }
}

