/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.soilWater;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="InitGeoFemSoilWaterStates", author="Peter Krause", description="Defines soil water attributes for each HRU")
public class InitGeoFemSoilWaterStates
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute area")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="field capacity adaptation factor")
    public JAMSDouble FCAdaptation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar rooting depth")
    public JAMSDouble rootDepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute maximum MPS")
    public JAMSDouble maxMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var actual MPS")
    public JAMSDouble actMPS;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntity entity = this.entities.getCurrent();
        double rootDepth = this.rootDepth.getValue();
        double mxMPS = 0.0;
        String aNameFC = "fc_";
        int d = 0;
        while ((double)d < rootDepth) {
            int count = d + 1;
            String mpsDesc = aNameFC + count;
            double mpsVal = entity.getDouble(mpsDesc);
            mxMPS += mpsVal;
            ++d;
        }
        mxMPS *= this.area.getValue();
        this.maxMPS.setValue(mxMPS *= this.FCAdaptation.getValue());
    }

    public void cleanup() {
    }
}

