/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.snow;

import org.unijena.j2k.physicalCalculations.DailySolarRadiationCalculationMethods;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="WASIMProcessSnow", author="Joerg Schulla, implementation and minor adaptations Peter Krause", description="Adaptation of the WASIM module for snow calculation")
public class WASIMProcessSnow
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Entity area", unit="m\u00b2")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Entity slope aspect correction factor")
    public JAMSDouble sloAspCorrFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Entity latitude")
    public JAMSDouble latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Entity landuse albedo")
    public JAMSDouble landAlbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Snow water equivalent", unit="mm")
    public JAMSDouble snowWaterEquivalent;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="liquid water in snowpack", unit="mm")
    public JAMSDouble freeWater;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="frozen water in snowpack", unit="mm")
    public JAMSDouble iceContent;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="radiation melt factor", unit="mm / C*day")
    public JAMSDouble radiationMeltFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="the snow melt")
    public JAMSDouble snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="the albedo of the entity")
    public JAMSDouble snowAlbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual evapotranspiration")
    public JAMSDouble aET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="factor for calculating max. radiation melt factor")
    public JAMSDouble rmf_max;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="min. radiation melt factor")
    public JAMSDouble rmf_min;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="melt temperature: temperature atwhich snow melt will start", unit="C")
    public JAMSDouble meltTemp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="refreezing coefficient")
    public JAMSDouble refCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="flag for selection of melt method1 = temperature index approach2 = tempWindAproach")
    public JAMSInteger meltMethod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="factor c0 for potential melt rate")
    public JAMSDouble c0Factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="factor c1 for potential melt rate")
    public JAMSDouble c1Factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="factor c2 for potential melt rate")
    public JAMSDouble c2Factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Free-water holding capacity (decimal percent) of snowpack expressed as decimal fraction of total snowpack water equivalent")
    public JAMSDouble freeWaterCapacity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="constant albedo of snow")
    public JAMSDouble snowConstAlbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="rain amount")
    public JAMSDouble rain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="snow amount")
    public JAMSDouble snow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="precip amount")
    public JAMSDouble precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="wind speed", unit="m/s")
    public JAMSDouble wind;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="minum temperature", unit="C")
    public JAMSDouble tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="mean temperature", unit="C")
    public JAMSDouble tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="max temperature", unit="C")
    public JAMSDouble tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="potential evapotranspiration")
    public JAMSDouble pET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="module active")
    public JAMSBoolean active;
    double runRain;
    double runSnow;
    double runIceContent;
    double runFreeWater;
    double runSnowWaterEquivalent;
    double runMeltTemperature;
    double runRadiationMeltFactor;
    double runWind;
    double runPrecip;
    double runSnowMelt;
    double runSnowAlbedo;
    double runAET;

    public void init() {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        if (this.active == null || this.active.getValue()) {
            this.runRain = this.rain.getValue();
            this.runSnow = this.snow.getValue();
            this.runWind = this.wind.getValue();
            this.runPrecip = this.precip.getValue();
            this.runIceContent = this.iceContent.getValue();
            this.runFreeWater = this.freeWater.getValue();
            this.runSnowWaterEquivalent = this.snowWaterEquivalent.getValue();
            this.runSnowMelt = 0.0;
            this.runSnowAlbedo = this.snowAlbedo.getValue();
            this.runAET = this.aET.getValue();
            this.runMeltTemperature = this.meltTemp.getValue();
            int runMeltMethod = this.meltMethod.getValue();
            double tempDay = (this.tmax.getValue() + this.tmean.getValue()) / 2.0;
            double tempNight = (this.tmin.getValue() + this.tmean.getValue()) / 2.0;
            if (this.runSnow > 0.0 || this.runSnowWaterEquivalent > 0.0) {
                double deltaET = this.pET.getValue() - this.runAET;
                if (this.runIceContent <= deltaET) {
                    this.runAET += this.runIceContent;
                    this.runIceContent = 0.0;
                } else {
                    this.runIceContent -= deltaET;
                    this.runAET = this.pET.getValue();
                }
                int julDay = this.time.get(6);
                double dayFrac = DailySolarRadiationCalculationMethods.calcDayFraction(this.latitude.getValue(), julDay);
                this.runRadiationMeltFactor = this.calcRadiationMeltFactor2(julDay);
                double potMeltRate = this.calcAccumulationAndMelt(tempDay, dayFrac, runMeltMethod);
                potMeltRate += this.calcAccumulationAndMelt(tempNight, 1.0 - dayFrac, runMeltMethod);
                potMeltRate *= this.area.getValue();
                this.runRain = 0.0;
                this.runSnow = 0.0;
                if (potMeltRate > this.runIceContent) {
                    potMeltRate = this.runIceContent;
                }
                this.runIceContent -= potMeltRate;
                this.runFreeWater += potMeltRate;
                double maxFreeWater = this.runIceContent * this.freeWaterCapacity.getValue();
                if (maxFreeWater < this.runFreeWater) {
                    this.runSnowMelt = this.runFreeWater - maxFreeWater;
                    this.runFreeWater = maxFreeWater;
                }
                this.runSnowAlbedo = this.runIceContent + this.runFreeWater > 5.0 * this.area.getValue() ? this.snowConstAlbedo.getValue() : this.landAlbedo.getValue();
            }
            this.iceContent.setValue(this.runIceContent);
            this.freeWater.setValue(this.runFreeWater);
            this.snowWaterEquivalent.setValue(this.runIceContent + this.runFreeWater);
            this.snowMelt.setValue(this.runSnowMelt);
            this.snowAlbedo.setValue(this.runSnowAlbedo);
            this.aET.setValue(this.runAET);
            this.rain.setValue(this.runRain);
            this.snow.setValue(this.runSnow);
        }
    }

    public void cleanup() {
    }

    private double calcRadiationMeltFactor1(int julDay) {
        double rmf = 0.0;
        double rmfMax = this.rmf_min.getValue() * this.rmf_max.getValue();
        double r_b = (rmfMax - this.rmf_min.getValue()) / 2.0;
        double r_a = this.rmf_min.getValue() + r_b;
        double r_c = 0.01721420632103996;
        double r_d = -80.0;
        rmf = r_a + r_b * Math.sin(r_c * (r_d + (double)julDay));
        return rmf;
    }

    private double calcRadiationMeltFactor2(int julDay) {
        double rmf = 0.0;
        double rmfMax = this.rmf_min.getValue() * this.rmf_max.getValue();
        double r_b = (rmfMax - this.rmf_min.getValue()) / 2.0;
        double r_a = this.rmf_min.getValue() + r_b;
        double r_c = 0.01721420632103996;
        double r_d = -80.0;
        rmf = r_a + r_b * Math.sin(r_c * (r_d + (double)julDay));
        return rmf;
    }

    private double calcIceSaturationVapourPressure(double temperature) {
        double est = 0.0;
        est = 6.1078 * Math.exp(21.874 * temperature / (265.5 + temperature));
        return est;
    }

    private double calcAccumulationAndMelt(double temperature, double dayFraction, int runMeltMethod) {
        this.runIceContent += this.runSnow * dayFraction;
        this.runFreeWater += this.runRain * dayFraction;
        double potMeltRate = 0.0;
        if (temperature <= this.runMeltTemperature) {
            if (runMeltMethod == 3) {
                double negMelt = Math.abs(this.refCoeff.getValue() * this.runRadiationMeltFactor * (temperature - this.runMeltTemperature));
                negMelt *= dayFraction;
                if ((negMelt *= this.area.getValue()) <= this.runFreeWater) {
                    this.runFreeWater -= negMelt;
                    this.runIceContent += negMelt;
                } else {
                    this.runIceContent += this.runFreeWater;
                    this.runFreeWater = 0.0;
                }
            }
        } else if (this.runIceContent > 0.0) {
            if (runMeltMethod == 1) {
                potMeltRate = this.c0Factor.getValue() * (temperature - this.runMeltTemperature);
            } else if (runMeltMethod == 2) {
                potMeltRate = (this.c1Factor.getValue() + this.c2Factor.getValue() * this.runWind) * (temperature - this.runMeltTemperature);
            } else if (runMeltMethod == 3) {
                if (this.runPrecip >= 2.0) {
                    double ms = 1.2 * temperature;
                    double mh = (this.c1Factor.getValue() + this.c2Factor.getValue() * this.runWind) * temperature;
                    double ml = (this.c1Factor.getValue() + this.c2Factor.getValue() * this.runWind) * (this.calcIceSaturationVapourPressure(temperature) - 6.11) / 0.662;
                    double mp = 0.0125 * this.runPrecip * temperature;
                    potMeltRate = ms + mh + ml + mp;
                } else {
                    double factor = 0.5 * (1.0 + this.sloAspCorrFactor.getValue());
                    double rmfCorr = this.runRadiationMeltFactor * factor;
                    potMeltRate = rmfCorr * (temperature - this.runMeltTemperature);
                }
            }
        }
        return potMeltRate * dayFraction;
    }
}

