/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KProcessRouting", author="Peter Krause", description="Passes the output of the entities as input to the respective reach or unit")
public class J2KProcessRouting
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Collection of reach objects")
    public JAMSEntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Collection of reservoir objects")
    public JAMSEntityCollection reservoirs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RD1 inflow")
    public JAMSDouble inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RD2 inflow")
    public JAMSDouble inRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RG1 inflow")
    public JAMSDouble inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RG2 inflow")
    public JAMSDouble inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar groundwater excess")
    public JAMSDouble inGWExcess;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RD1 outflow")
    public JAMSDouble outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RD2 outflow")
    public JAMSDouble outRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RG1 outflow")
    public JAMSDouble outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RG2 outflow")
    public JAMSDouble outRG2;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntity entity = this.entities.getCurrent();
        JAMSEntity toPoly = (JAMSEntity)entity.getObject("to_poly");
        JAMSEntity toReach = (JAMSEntity)entity.getObject("to_reach");
        JAMSEntity toReservoir = null;
        try {
            toReservoir = (JAMSEntity)entity.getObject("to_reservoir");
        }
        catch (JAMSEntity.NoSuchAttributeException e) {
            toReservoir = null;
        }
        double RD1out = this.outRD1.getValue();
        double RD2out = this.outRD2.getValue();
        double RG1out = this.outRG1.getValue();
        double RG2out = this.outRG2.getValue();
        if (toPoly != null) {
            double elev = toPoly.getDouble("slope");
            double RD1in = toPoly.getDouble("inRD1");
            double RD2in = toPoly.getDouble("inRD2");
            double RG1in = toPoly.getDouble("inRG1");
            double RG2in = toPoly.getDouble("inRG2");
            RD1in += RD1out;
            RD2in += RD2out;
            RG1in += RG1out;
            RG2in += RG2out;
            RD2in += this.inGWExcess.getValue();
            RD1out = 0.0;
            RD2out = 0.0;
            RG1out = 0.0;
            RG2out = 0.0;
            this.outRD1.setValue(0.0);
            this.outRD2.setValue(0.0);
            this.outRG1.setValue(0.0);
            this.outRG2.setValue(0.0);
            this.inGWExcess.setValue(0.0);
            toPoly.setDouble("inRD1", RD1in);
            toPoly.setDouble("inRD2", RD2in);
            toPoly.setDouble("inRG1", RG1in);
            toPoly.setDouble("inRG2", RG2in);
        } else if (toReach != null) {
            double RD1in = toReach.getDouble("inRD1");
            double RD2in = toReach.getDouble("inRD2");
            double RG1in = toReach.getDouble("inRG1");
            double RG2in = toReach.getDouble("inRG2");
            RD1in += RD1out;
            RD2in += RD2out;
            RG1in += RG1out;
            RG2in += RG2out;
            RD2in += this.inGWExcess.getValue();
            RD1out = 0.0;
            RD2out = 0.0;
            RG1out = 0.0;
            RG2out = 0.0;
            this.outRD1.setValue(RD1out);
            toReach.setDouble("inRD1", RD1in);
            this.outRD2.setValue(RD2out);
            toReach.setDouble("inRD2", RD2in);
            this.outRG1.setValue(RG1out);
            toReach.setDouble("inRG1", RG1in);
            this.outRG2.setValue(RG2out);
            this.inGWExcess.setValue(0.0);
            toReach.setDouble("inRG2", RG2in);
        } else if (toReservoir != null) {
            double resRD1 = toReservoir.getDouble("compRD1");
            double resRD2 = toReservoir.getDouble("compRD2");
            double resRG1 = toReservoir.getDouble("compRG1");
            double resRG2 = toReservoir.getDouble("compRG2");
            resRD1 += RD1out;
            resRD2 += RD2out;
            resRG1 += RG1out;
            resRG2 += RG2out;
            RD1out = 0.0;
            RD2out = 0.0;
            RG1out = 0.0;
            RG2out = 0.0;
            this.outRD1.setValue(RD1out);
            toReservoir.setDouble("compRD1", resRD1);
            this.outRD2.setValue(RD2out);
            toReservoir.setDouble("compRD2", resRD2);
            this.outRG1.setValue(RG1out);
            toReservoir.setDouble("compRG1", resRG1);
            this.outRG2.setValue(RG2out);
            toReservoir.setDouble("compRG2", resRG2);
        } else {
            this.getModel().getRuntime().println("Current entity ID: " + (int)entity.getDouble("ID") + " has no receiver.");
        }
    }

    public void cleanup() {
    }
}

