/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class J2KOutsideInflow
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The reach collection")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="The receiver reach ID")
    public JAMSInteger reachID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the inflow from the data file or another model")
    public JAMSDouble inflow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="additional inflow to the specific reach")
    public JAMSDouble inAddIn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="outflow of the additional inflow from the specific reach")
    public JAMSDouble outAddIn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="the actual channel storage of the additional inflow of the specific reach")
    public JAMSDouble actAddIn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment additional input outlet storage")
    public JAMSDouble catchmentAddIn;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntity entity = this.entities.getCurrent();
        double inflow = this.inflow.getValue();
        if (entity.getDouble("ID") == (double)this.reachID.getValue()) {
            double actAddIn = this.actAddIn.getValue();
            this.actAddIn.setValue(actAddIn + inflow);
        }
    }

    public void cleanup() {
    }
}

