/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.regionalisation;

import org.unijena.j2k.statistics.IDW;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSIntegerArray;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="CalcIDWeights", author="Peter Krause", description="Calculates inverse distance weights for the regionalisation procedure")
public class CalcIDWeights
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="entity x-coordinate")
    public JAMSDouble entityX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="entity y-coordinate")
    public JAMSDouble entityY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of station's x coordinates")
    public JAMSDoubleArray statX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of station's y coordinates")
    public JAMSDoubleArray statY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Number of IDW stations")
    public JAMSInteger nidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Power of IDW function")
    public JAMSDouble pidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="weights for IDW part of regionalisation")
    public JAMSDoubleArray statIDWeights = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="position array to determine best weights")
    public JAMSIntegerArray wArray = new JAMSIntegerArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Doug Boyle's famous function")
    public JAMSBoolean equalWeights;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        JAMSDoubleArray idwWeights = new JAMSDoubleArray();
        JAMSIntegerArray wA = new JAMSIntegerArray();
        if (this.equalWeights == null || !this.equalWeights.getValue()) {
            double[] dist = IDW.calcDistances(this.entityX.getValue(), this.entityY.getValue(), this.statX.getValue(), this.statY.getValue(), this.pidw.getValue());
            idwWeights.setValue(IDW.calcWeights(dist));
            wA.setValue(IDW.computeWeightArray(idwWeights.getValue()));
        } else if (this.equalWeights.getValue()) {
            int nstat = this.statX.getValue().length;
            idwWeights.setValue(IDW.equalWeights(nstat));
            int[] tmp = new int[nstat];
            for (int i = 0; i < nstat; ++i) {
                tmp[i] = i;
            }
            wA.setValue(tmp);
        }
        this.statIDWeights.setValue(idwWeights.getValue());
        this.wArray.setValue(wA.getValue());
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
        int nstat = this.statIDWeights.getValue().length;
        double[] sw = new double[nstat];
        for (int i = 0; i < nstat; ++i) {
            sw[i] = 0.0;
        }
        this.statIDWeights.setValue(sw);
    }
}

