/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.radiation;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.unijena.j2k.mathematicalCalculations.MathematicalCalculations;
import org.unijena.j2k.physicalCalculations.DailySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class CalcDailySolarRadiation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Workspace directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable sunshine hours [h/d]")
    public JAMSDouble sunh;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Maximum sunshine duration in h")
    public JAMSDouble sunhmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable slope aspect correction factor")
    public JAMSDouble actSlAsCf;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute latitude [deg]")
    public JAMSDouble latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="daily extraterrestic radiation [MJ/m\u00b2d]")
    public JAMSDouble actExtRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="daily solar radiation [MJ/m\u00b2d]")
    public JAMSDouble solRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Angstrom factor a")
    public JAMSDouble angstrom_a;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Angstrom factor b")
    public JAMSDouble angstrom_b;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="temporal resolution [d | h | m]")
    public JAMSString tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Use caching of regionalised data?")
    public JAMSBoolean dataCaching;
    private File cacheFile;
    private boolean useCache = false;
    private ObjectOutputStream writer;
    private ObjectInputStream reader;
    int[] monthMean = new int[]{15, 45, 74, 105, 135, 166, 196, 227, 258, 288, 319, 349};

    public void init() throws JAMSEntity.NoSuchAttributeException, IOException {
        this.cacheFile = new File(this.dirName.getValue() + "/$" + this.getInstanceName() + ".cache");
        if (this.cacheFile.exists() || this.dataCaching.getValue()) {
            // empty if block
        }
        if (this.dataCaching.getValue()) {
            this.useCache = true;
            this.reader = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile)));
        } else {
            this.useCache = false;
            this.writer = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheFile)));
        }
    }

    public void run() throws JAMSEntity.NoSuchAttributeException, IOException {
        if (!this.useCache) {
            int julDay = this.time.get(6);
            int month = this.time.get(2);
            double SAC = this.actSlAsCf.getValue();
            double lati = this.latitude.getValue();
            double sunsh = this.sunh.getValue();
            double extraterrRadiation = this.actExtRad.getValue();
            double declination = 0.0;
            if (this.tempRes == null) {
                declination = SolarRadiationCalculationMethods.calc_SunDeclination(julDay);
            } else if (this.tempRes.getValue().equals("d")) {
                declination = SolarRadiationCalculationMethods.calc_SunDeclination(julDay);
            } else if (this.tempRes.getValue().equals("m")) {
                declination = SolarRadiationCalculationMethods.calc_SunDeclination(this.monthMean[month]);
            }
            double latRad = MathematicalCalculations.deg2rad(lati);
            double sunsetHourAngle = DailySolarRadiationCalculationMethods.calc_SunsetHourAngle(latRad, declination);
            double maximumSunshine = DailySolarRadiationCalculationMethods.calc_maximumSunshineHours(sunsetHourAngle);
            this.sunhmax.setValue(maximumSunshine);
            double solarRadiation = SolarRadiationCalculationMethods.calc_SolarRadiation(sunsh, maximumSunshine, extraterrRadiation, this.angstrom_a.getValue(), this.angstrom_b.getValue());
            this.solRad.setValue(solarRadiation *= SAC);
            this.writer.writeDouble(solarRadiation);
        } else {
            this.solRad.setValue(this.reader.readDouble());
        }
    }

    public void cleanup() throws IOException {
        if (!this.useCache) {
            this.writer.flush();
            this.writer.close();
        } else {
            this.reader.close();
        }
    }
}

