/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.unijena.j2k.statistics.Regression;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.data.JAMSTimeInterval;
import org.unijena.jams.io.GenericDataReader;
import org.unijena.jams.io.JAMSTableDataArray;
import org.unijena.jams.io.JAMSTableDataConverter;
import org.unijena.jams.io.JAMSTableDataStore;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class TSDataReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file name")
    public JAMSString dataFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Column of first data value")
    public JAMSInteger startColumn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Time interval of current temporal context")
    public JAMSTimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of data values for current time step")
    public JAMSDoubleArray dataArray = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="data set descriptor")
    public JAMSString dataSetName = new JAMSString();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of station elevations")
    public JAMSDoubleArray elevation = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of station's x coordinate")
    public JAMSDoubleArray xCoord = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of station's y coordinate")
    public JAMSDoubleArray yCoord = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Regression coefficients")
    public JAMSDoubleArray regCoeff = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Calculate regression coefficients? If not, regCoeff array stays empty!")
    public JAMSBoolean skipRegression;
    private JAMSTableDataStore store;
    private JAMSTableDataArray da;

    public void init() {
        int headerLineCount = 0;
        String dataName = null;
        String tres = null;
        String start = null;
        String end = null;
        double[] statx = null;
        double[] staty = null;
        double[] statelev = null;
        String fileName = this.dirName.getValue() + "/" + this.dataFileName.getValue();
        String line = "#";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            while (line.charAt(0) == '#') {
                line = reader.readLine();
                ++headerLineCount;
            }
            StringTokenizer strTok = new StringTokenizer(line, "\t");
            String token = strTok.nextToken();
            while (token.compareTo("@dataVal") != 0) {
                String desc;
                int i;
                if (token.compareTo("@dataValueAttribs") == 0) {
                    line = reader.readLine();
                    ++headerLineCount;
                    strTok = new StringTokenizer(line, "\t");
                    dataName = strTok.nextToken();
                    double lowBound = Double.parseDouble(strTok.nextToken());
                    double uppBound = Double.parseDouble(strTok.nextToken());
                    line = reader.readLine();
                    strTok = new StringTokenizer(line, "\t");
                    token = strTok.nextToken();
                    ++headerLineCount;
                    continue;
                }
                if (token.compareTo("@dataSetAttribs") == 0) {
                    line = reader.readLine();
                    for (i = 0; i < 4; ++i) {
                        ++headerLineCount;
                        strTok = new StringTokenizer(line, "\t ");
                        desc = strTok.nextToken();
                        if (desc.compareTo("missingDataVal") == 0) {
                            double missData = Double.parseDouble(strTok.nextToken());
                        } else if (desc.compareTo("dataStart") == 0) {
                            start = strTok.nextToken();
                            if (strTok.hasMoreTokens()) {
                                start = start + " " + strTok.nextToken();
                            }
                        } else if (desc.compareTo("dataEnd") == 0) {
                            end = strTok.nextToken();
                            if (strTok.hasMoreTokens()) {
                                end = end + " " + strTok.nextToken();
                            }
                        } else if (desc.compareTo("tres") == 0) {
                            tres = strTok.nextToken();
                        }
                        line = reader.readLine();
                        strTok = new StringTokenizer(line, "\t");
                        token = strTok.nextToken();
                    }
                    continue;
                }
                if (token.compareTo("@statAttribVal") != 0) continue;
                line = reader.readLine();
                for (i = 0; i < 6; ++i) {
                    int j;
                    ++headerLineCount;
                    strTok = new StringTokenizer(line, "\t");
                    desc = strTok.nextToken();
                    int nstat = strTok.countTokens();
                    if (desc.compareTo("name") == 0) {
                        String[] name = new String[nstat];
                        for (j = 0; j < nstat; ++j) {
                            name[j] = strTok.nextToken();
                        }
                    } else if (desc.compareTo("ID") == 0) {
                        String[] id = new String[nstat];
                        for (j = 0; j < nstat; ++j) {
                            id[j] = strTok.nextToken();
                        }
                    } else if (desc.compareTo("elevation") == 0) {
                        statelev = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            statelev[j] = Double.parseDouble(strTok.nextToken());
                        }
                    } else if (desc.compareTo("x") == 0) {
                        statx = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            statx[j] = Double.parseDouble(strTok.nextToken());
                        }
                    } else if (desc.compareTo("y") == 0) {
                        staty = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            staty[j] = Double.parseDouble(strTok.nextToken());
                        }
                    } else if (desc.compareTo("dataColumn") == 0) {
                        ++headerLineCount;
                        ++headerLineCount;
                    }
                    line = reader.readLine();
                    strTok = new StringTokenizer(line, "\t");
                    token = strTok.nextToken();
                }
            }
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Exception)ioe);
        }
        this.store = new GenericDataReader(this.dirName.getValue() + "/" + this.dataFileName.getValue(), false, headerLineCount + 1);
        JAMSCalendar startTime = TSDataReader.parseJ2KTime(start);
        JAMSCalendar endTime = TSDataReader.parseJ2KTime(end);
        if (this.timeInterval != null && (this.timeInterval.getStart().before((Object)startTime) || this.timeInterval.getEnd().after((Object)endTime))) {
            this.getModel().getRuntime().sendHalt("TSData start and end time of " + this.dataFileName.getValue() + " do not match current temporal context!");
        }
        this.dataSetName.setValue(dataName);
        this.elevation.setValue(statelev);
        this.xCoord.setValue(statx);
        this.yCoord.setValue(staty);
        if (this.timeInterval != null) {
            int timeUnit = this.timeInterval.getTimeUnit();
            JAMSCalendar tiStart = this.timeInterval.getStart();
            JAMSCalendar date = new JAMSCalendar(tiStart.get(1), tiStart.get(2), tiStart.get(5), tiStart.get(11), tiStart.get(12), tiStart.get(13));
            while (startTime.before((Object)date) && this.store.hasNext()) {
                this.da = this.store.getNext();
                if (timeUnit == 6) {
                    startTime.add(5, 1);
                    continue;
                }
                if (timeUnit == 11) {
                    startTime.add(11, 1);
                    continue;
                }
                if (timeUnit != 2) continue;
                startTime.add(2, 1);
            }
        }
        this.getModel().getRuntime().println(this.dataSetName.getValue() + " data file initalised ... ", 2);
    }

    public void run() {
        this.dataArray.setValue(JAMSTableDataConverter.toDouble((JAMSTableDataArray)this.store.getNext(), (int)this.startColumn.getValue()));
        if (!this.skipRegression.getValue()) {
            this.regCoeff.setValue(Regression.calcLinReg(this.elevation.getValue(), this.dataArray.getValue()));
        }
    }

    private static JAMSCalendar parseJ2KTime(String timeString) {
        String[] timeArray = new String[]{"1", "1", "0", "0", "0"};
        StringTokenizer st = new StringTokenizer(timeString, ".-/ :");
        int n = st.countTokens();
        for (int i = 0; i < n; ++i) {
            timeArray[i] = st.nextToken();
        }
        JAMSCalendar cal = new JAMSCalendar();
        cal.setValue(timeArray[2] + "-" + timeArray[1] + "-" + timeArray[0] + " " + timeArray[3] + ":" + timeArray[4]);
        return cal;
    }

    public void cleanup() {
        this.store.close();
    }
}

