/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import java.util.HashMap;
import org.unijena.j2k.J2KFunctions;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class StandardSoilParaReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Soil types parameter file name")
    public JAMSString stFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntityCollection hrus;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntityCollection soilTypes = new JAMSEntityCollection();
        soilTypes.setEntities(J2KFunctions.readParas(this.dirName.getValue() + "/" + this.stFileName.getValue(), this.getModel()));
        HashMap<Double, JAMSEntity> stMap = new HashMap<Double, JAMSEntity>();
        for (JAMSEntity st : soilTypes.getEntities()) {
            stMap.put(st.getDouble("SID"), st);
        }
        for (JAMSEntity e : this.hrus.getEntities()) {
            JAMSEntity st;
            st = (JAMSEntity)stMap.get(e.getDouble("soilID"));
            e.setObject("soilType", (Object)st);
            if (st == null) {
                System.out.println("SoilType " + e.getDouble("soilID") + " is not defined in soil parameter table");
            }
            Object[] attrs = st.getKeys();
            for (int i = 0; i < attrs.length; ++i) {
                Object o = st.getObject((String)attrs[i]);
                if (o instanceof JAMSString) continue;
                e.setObject((String)attrs[i], o);
            }
        }
        this.getModel().getRuntime().println("Soil parameter file processed ...", 2);
    }
}

