/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import java.util.HashMap;
import org.unijena.j2k.J2KFunctions;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class StandardLUReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Land use parameter file name")
    public JAMSString luFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntityCollection hrus;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntityCollection lus = new JAMSEntityCollection();
        lus.setEntities(J2KFunctions.readParas(this.dirName.getValue() + "/" + this.luFileName.getValue(), this.getModel()));
        HashMap<Double, JAMSEntity> luMap = new HashMap<Double, JAMSEntity>();
        for (JAMSEntity lu : lus.getEntities()) {
            luMap.put(lu.getDouble("LID"), lu);
        }
        for (JAMSEntity e : this.hrus.getEntities()) {
            JAMSEntity lu;
            lu = (JAMSEntity)luMap.get(e.getDouble("landuseID"));
            e.setObject("landuse", (Object)lu);
            Object[] attrs = lu.getKeys();
            for (int i = 0; i < attrs.length; ++i) {
                Object o = lu.getObject((String)attrs[i]);
                if (o instanceof JAMSString) continue;
                e.setObject((String)attrs[i], o);
            }
        }
        this.getModel().getRuntime().println("Landuse parameter file processed ...", 2);
    }
}

