/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSEntityEnumerator;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;
import org.unijena.jams.runtime.RuntimeException;

public class StandardEntityWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="EntitySet")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file name")
    public JAMSString fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file header descriptions")
    public JAMSString header;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file attribute names")
    public JAMSString attributeName;
    private GenericDataWriter writer;
    private boolean headerWritten;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        this.writer = new GenericDataWriter(this.dirName.getValue() + "/" + this.fileName.getValue());
        this.writer.addComment("J2K model output" + this.header.getValue());
        this.writer.addComment("");
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        int i;
        if (!this.headerWritten) {
            this.writer.addColumn("date/time");
            Object ob = this.entities.getCurrent().getObject(this.attributeName.getValue());
            int length = 0;
            if (ob.getClass().getName().contains("DoubleArray")) {
                length = ((JAMSDoubleArray)this.entities.getCurrent().getObject(this.attributeName.getValue())).getValue().length;
            }
            JAMSEntityEnumerator enEnum = this.entities.getEntityEnumerator();
            enEnum.reset();
            boolean cont = true;
            while (cont) {
                for (i = 0; i < length; ++i) {
                    this.writer.addColumn("HRU_" + (int)this.entities.getCurrent().getDouble("ID") + "[" + i + "]");
                }
                if (length == 0) {
                    this.writer.addColumn("HRU_" + (int)this.entities.getCurrent().getDouble("ID"));
                }
                if (enEnum.hasNext()) {
                    enEnum.next();
                    cont = true;
                    continue;
                }
                cont = false;
            }
            this.writer.writeHeader();
            this.headerWritten = true;
        }
        this.writer.addData((Object)this.time);
        JAMSEntityEnumerator ee = this.entities.getEntityEnumerator();
        ee.reset();
        boolean cont = true;
        while (cont) {
            Object ob = this.entities.getCurrent().getObject(this.attributeName.getValue());
            if (ob.getClass().getName().contains("DoubleArray")) {
                double[] da = ((JAMSDoubleArray)this.entities.getCurrent().getObject(this.attributeName.getValue())).getValue();
                for (i = 0; i < da.length; ++i) {
                    this.writer.addData((Object)("" + da[i]));
                }
            } else {
                double da = ((JAMSDouble)this.entities.getCurrent().getObject(this.attributeName.getValue())).getValue();
                this.writer.addData((Object)("" + da));
            }
            if (ee.hasNext()) {
                ee.next();
                cont = true;
                continue;
            }
            cont = false;
        }
        try {
            this.writer.writeData();
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().handle((Exception)((Object)jre));
        }
    }

    public void cleanup() {
        this.writer.close();
    }
}

