/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import java.io.IOException;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.data.JAMSStringArray;
import org.unijena.jams.data.JAMSTimeInterval;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;
import org.unijena.jams.runtime.RuntimeException;

public class StandardDataWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time interval")
    public JAMSTimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file name")
    public JAMSString fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file header descriptions")
    public JAMSStringArray headers;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Output file attributes")
    public JAMSDouble[] value;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output data precision")
    public JAMSInteger precision;
    private GenericDataWriter writer;
    private int prec;

    public void init() {
        this.writer = new GenericDataWriter(this.dirName.getValue() + "/" + this.fileName.getValue());
        this.writer.addComment("J2K model output");
        this.writer.addComment("");
        this.writer.addColumn("date");
        for (int i = 0; i < this.headers.getValue().length; ++i) {
            this.writer.addColumn(this.headers.getValue()[i]);
        }
        this.writer.writeHeader();
        this.prec = this.precision == null ? 3 : this.precision.getValue();
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        int tu = this.timeInterval.getTimeUnit();
        String timeFormat = "%1$tY-%1$tm-%1$td %1$tH:%1$tM";
        if (tu == 11) {
            timeFormat = "%1$td.%1$tm.%1$tY %1$tH:%1$tM";
        } else if (tu == 6) {
            timeFormat = "%1$td.%1$tm.%1$tY";
        } else if (tu == 2) {
            timeFormat = "%1$tm/%1$tY";
        } else if (tu == 1) {
            timeFormat = "%1$tY";
        }
        this.writer.addData((Object)this.time.toString(timeFormat));
        for (int i = 0; i < this.value.length; ++i) {
            this.writer.addData((Object)this.value[i]);
        }
        try {
            this.writer.writeData(this.prec);
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().println(jre.getMessage());
        }
    }

    public void cleanup() {
        try {
            this.writer.writer.flush();
            this.writer.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

