/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSEntityEnumerator;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.data.JAMSTimeInterval;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;
import org.unijena.jams.runtime.RuntimeException;

public class FullSetEntityWriter_1
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="EntitySet")
    public JAMSEntityCollection entitySet;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file name")
    public JAMSString fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time interval")
    public JAMSTimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file header descriptions")
    public JAMSString header;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file attribute names")
    public JAMSString attributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="entity attribute name for weight [attName | none]")
    public JAMSString weight;
    private GenericDataWriter writer;
    private String[] attrs;
    private boolean headerWritten;
    int nEnts = 0;
    int tsteps = 0;
    double[][] valArray;
    int tcounter = 0;
    String[] dateStr;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        this.writer = new GenericDataWriter(this.dirName.getValue() + "/" + this.fileName.getValue());
        this.writer.addComment("J2K model output" + this.header.getValue());
        this.writer.addComment("");
        this.nEnts = this.entitySet.getEntityArray().length;
        this.tsteps = (int)this.timeInterval.getNumberOfTimesteps();
        this.valArray = new double[this.nEnts][this.tsteps];
        this.dateStr = new String[this.tsteps];
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        this.dateStr[this.tcounter] = this.time.toString();
        JAMSEntityEnumerator ee = this.entitySet.getEntityEnumerator();
        ee.reset();
        int setCounter = 0;
        int entCounter = 0;
        boolean cont = true;
        while (cont) {
            double val;
            Object ob;
            double weightVal = 1.0;
            if (!this.weight.getValue().equals("none")) {
                weightVal = ((JAMSDouble)this.entitySet.getCurrent().getObject(this.weight.getValue())).getValue();
            }
            if ((ob = this.entitySet.getCurrent().getObject(this.attributeName.getValue())).getClass().getName().contains("DoubleArray")) {
                double[] da = ((JAMSDoubleArray)this.entitySet.getCurrent().getObject(this.attributeName.getValue())).getValue();
                for (int i = 0; i < da.length; ++i) {
                    this.valArray[entCounter][this.tcounter] = val = da[i] / weightVal;
                }
            } else {
                double da = ((JAMSDouble)this.entitySet.getCurrent().getObject(this.attributeName.getValue())).getValue();
                this.valArray[entCounter][this.tcounter] = val = da / weightVal;
            }
            if (setCounter < this.nEnts - 1) {
                ++setCounter;
            }
            if (ee.hasNext() && setCounter < this.nEnts) {
                ee.next();
                cont = true;
                ++entCounter;
                continue;
            }
            cont = false;
        }
        ++this.tcounter;
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
        try {
            this.writer.addColumn("ID");
            for (int i = 0; i < this.tcounter; ++i) {
                this.writer.addColumn(this.dateStr[i]);
            }
            this.writer.writeHeader();
            for (int e = 0; e < this.nEnts; ++e) {
                this.writer.addData((Object)this.entitySet.getEntityArray()[e].getDouble("ID"));
                for (int t = 0; t < this.tcounter; ++t) {
                    this.writer.addData((Object)this.valArray[e][t]);
                }
                this.writer.writeData();
            }
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().handle((Exception)((Object)jre));
        }
        this.writer.flush();
        this.writer.close();
    }
}

