/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import org.unijena.j2k.statistics.IDW;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="CalcAbsoluteHumidity", author="Peter Krause", description="Calculates absolute humidity of relative humidity and temperatureIf temperature is not existent at the site it is regionalized")
public class CalcAbsoluteHumidity
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the relative humidity values")
    public JAMSDoubleArray rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="temperature for the computation")
    public JAMSDoubleArray temperature;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="aboslute humidity values")
    public JAMSDoubleArray ahum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of temperature station elevations")
    public JAMSDoubleArray tempElevation = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of temperature station's x coordinate")
    public JAMSDoubleArray tempXCoord = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of temperature station's y coordinate")
    public JAMSDoubleArray tempYCoord = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Regression coefficients for temperature")
    public JAMSDoubleArray tempRegCoeff = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of rhum station elevations")
    public JAMSDoubleArray rhumElevation = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of rhum station's x coordinate")
    public JAMSDoubleArray rhumXCoord = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of rhum station's y coordinate")
    public JAMSDoubleArray rhumYCoord = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="number of temperature station for IDW")
    public JAMSInteger tempNIDW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="power for IDW function")
    public JAMSDouble pIDW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="regression threshold")
    public JAMSDouble regThres;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Use caching of regionalised data?")
    public JAMSBoolean dataCaching;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        if (!this.dataCaching.getValue()) {
            int i;
            double[] rhum = this.rhum.getValue();
            double[] temperature = this.temperature.getValue();
            double[] ahum = new double[rhum.length];
            double[] rhumElev = new double[rhum.length];
            double[] rhumX = new double[rhum.length];
            double[] rhumY = new double[rhum.length];
            double[][] statWeights = new double[rhum.length][temperature.length];
            for (i = 0; i < rhum.length; ++i) {
                rhumElev[i] = this.rhumElevation.getValue()[i];
                rhumX[i] = this.rhumXCoord.getValue()[i];
                rhumY[i] = this.rhumYCoord.getValue()[i];
                for (int n = 0; n < this.tempNIDW.getValue(); ++n) {
                    statWeights[i][n] = 0.0;
                }
            }
            for (i = 0; i < ahum.length; ++i) {
                statWeights[i] = IDW.calcNidwWeights(rhumX[i], rhumY[i], this.tempXCoord.getValue(), this.tempYCoord.getValue(), this.pIDW.getValue(), this.tempNIDW.getValue());
            }
            double rsq = this.tempRegCoeff.getValue()[2];
            double grad = this.tempRegCoeff.getValue()[1];
            for (int r = 0; r < ahum.length; ++r) {
                double rhumTemp = 0.0;
                for (int t = 0; t < temperature.length; ++t) {
                    if (rsq >= this.regThres.getValue()) {
                        double deltaElev = this.rhumElevation.getValue()[r] - this.tempElevation.getValue()[t];
                        rhumTemp += (deltaElev * grad + temperature[t]) * statWeights[r][t];
                        continue;
                    }
                    rhumTemp += temperature[t] * statWeights[r][t];
                }
                double est = 6.11 * Math.exp(17.62 * rhumTemp / (243.12 + rhumTemp));
                double maxHum = est * 216.7 / (rhumTemp + 273.15);
                ahum[r] = maxHum * (rhum[r] / 100.0);
            }
            this.ahum.setValue(ahum);
        }
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
    }
}

