/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.groundwater;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="GeoFemGroundwater", author="Peter Krause", description="Description")
public class GeoFemGroundwater
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute slope")
    public JAMSDouble slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="recision coefficient k")
    public JAMSDouble k;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="groundwater recharge")
    public JAMSDouble gwRecharge;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="groundwater storages")
    public JAMSDouble storage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="baseflow basQ")
    public JAMSDouble basQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="baseflow recession coefficient")
    public JAMSDouble gwRecCoeff;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double storage = this.storage.getValue();
        double input = this.gwRecharge.getValue();
        double recTanSlope = 1.0 - Math.tan(this.slope.getValue() * (Math.PI / 180));
        if (recTanSlope < 0.0) {
            recTanSlope = 0.0;
        }
        double gwRec = 1.0 / (this.k.getValue() * recTanSlope);
        double outflow = 1.0 / this.k.getValue() * (storage += input);
        this.storage.setValue(storage -= outflow);
        this.basQ.setValue(outflow);
        this.gwRecCoeff.setValue(this.k.getValue() * recTanSlope);
    }

    public void cleanup() {
    }
}

