/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import java.util.Random;
import java.util.StringTokenizer;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.data.JAMSTimeInterval;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSContext;
import org.unijena.jams.model.JAMSVarDescription;
import org.unijena.jams.runtime.RuntimeException;

@JAMSComponentDescription(title="Regular2dParameterSampler", author="Peter Krause", description="Samples a 2D parameter space in a regular way")
public class Regular2DSampler
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="List of two parameter identifiers to be sampled")
    public JAMSString parameterIDs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="List of parameter value bounaries corresponding to parameter identifiers")
    public JAMSString boundaries;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="resolution x")
    public JAMSInteger resX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="resolution y")
    public JAMSInteger resY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="efficiency methods")
    public JAMSString effMethodNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="efficiency values")
    public JAMSDouble[] effValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Flag for enabling this sampler")
    public JAMSBoolean enable;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT)
    public JAMSString paraFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT)
    public JAMSString attribFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="The model time interval")
    public JAMSTimeInterval modelTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file header descriptions")
    public JAMSString attribHeader;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Output file attribute")
    public JAMSDoubleArray targetValue;
    JAMSDouble[] parameters;
    String[] parameterNames;
    double[] lowBound;
    double[] upBound;
    int currentCount;
    Random generator;
    GenericDataWriter paraWriter;
    GenericDataWriter attribWriter;
    double[][] valueArray;
    int timeStepCounter = 0;
    int runCounter = 0;
    int timeSteps = 0;
    double[] stepSize;
    int[] currentStep;
    int currentXStep = 0;
    int sampleCount = 0;

    private boolean hasNext() {
        int sampleCount = this.resX.getValue() * this.resY.getValue();
        return this.currentCount < sampleCount;
    }

    public void init() {
        if (this.enable.getValue()) {
            String key;
            StringTokenizer tok = new StringTokenizer(this.parameterIDs.getValue(), ";");
            this.parameters = new JAMSDouble[tok.countTokens()];
            this.parameterNames = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                this.parameterNames[i] = key = tok.nextToken();
                this.parameters[i] = (JAMSDouble)this.getModel().getRuntime().getDataHandles().get(key);
                ++i;
            }
            tok = new StringTokenizer(this.boundaries.getValue(), ";");
            int n = tok.countTokens();
            this.lowBound = new double[n];
            this.upBound = new double[n];
            if (n != i) {
                this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": Different number of parameterIDs and boundaries!");
            }
            i = 0;
            while (tok.hasMoreTokens()) {
                key = tok.nextToken();
                key = key.substring(1, key.length() - 1);
                StringTokenizer boundTok = new StringTokenizer(key, ">");
                this.lowBound[i] = Double.parseDouble(boundTok.nextToken());
                this.upBound[i] = Double.parseDouble(boundTok.nextToken());
                if (this.upBound[i] <= this.lowBound[i]) {
                    this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": upBound must be higher than lowBound!");
                }
                ++i;
            }
            i = 0;
            tok = new StringTokenizer(this.effMethodNames.getValue(), ";");
            String[] effNames = new String[tok.countTokens()];
            i = 0;
            while (tok.hasMoreTokens()) {
                effNames[i] = key = tok.nextToken();
                ++i;
            }
            this.paraWriter = new GenericDataWriter(this.dirName.getValue() + "/" + this.paraFileName.getValue());
            this.paraWriter.addColumn("Run");
            for (int j = 0; j < this.parameters.length; ++j) {
                this.paraWriter.addColumn(this.parameterNames[j]);
            }
            for (int e = 0; e < effNames.length; ++e) {
                this.paraWriter.addColumn(effNames[e]);
            }
            this.paraWriter.writeHeader();
            this.attribWriter = new GenericDataWriter(this.dirName.getValue() + "/" + this.attribFileName.getValue());
            this.attribWriter.addComment("J2K model output");
            this.attribWriter.addComment("");
            this.attribWriter.addColumn("date/time");
            this.sampleCount = this.resX.getValue() * this.resY.getValue();
            for (int s = 0; s < this.sampleCount; ++s) {
                int counter = s + 1;
                this.attribWriter.addColumn(this.attribHeader.getValue() + "_run_" + counter);
            }
            this.attribWriter.writeHeader();
            this.timeSteps = (int)this.modelTimeInterval.getNumberOfTimesteps();
            this.valueArray = new double[this.sampleCount][this.timeSteps];
            this.timeStepCounter = 0;
            this.runCounter = 0;
            this.stepSize = new double[this.parameters.length];
            this.stepSize[0] = (this.upBound[0] - this.lowBound[0]) / (double)(this.resX.getValue() - 1);
            this.stepSize[1] = (this.upBound[1] - this.lowBound[1]) / (double)(this.resY.getValue() - 1);
            this.currentStep = new int[this.parameters.length];
            for (i = 0; i < this.parameters.length; ++i) {
                this.parameters[i].setValue(this.lowBound[i]);
                this.currentStep[i] = 0;
            }
        }
    }

    private void updateValues() {
        int sampleCount = this.resX.getValue() * this.resY.getValue();
        int count = this.currentCount + 1;
        this.getModel().getRuntime().println("Run No. " + count + " of " + sampleCount);
        if (this.currentCount > 0) {
            if (this.currentXStep < this.resX.getValue()) {
                this.parameters[0].setValue(this.parameters[0].getValue() + this.stepSize[0]);
            } else {
                this.parameters[1].setValue(this.parameters[1].getValue() + this.stepSize[1]);
                this.parameters[0].setValue(this.lowBound[0]);
                this.currentXStep = 0;
            }
        }
        this.getModel().getRuntime().println("Para: " + this.parameterNames[0] + " = " + this.parameters[0]);
        this.getModel().getRuntime().println("Para: " + this.parameterNames[1] + " = " + this.parameters[1]);
        ++this.currentCount;
        ++this.currentXStep;
    }

    private void resetValues() {
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i].setValue(this.lowBound[i]);
        }
        this.currentCount = 0;
    }

    private void singleRun() {
        JAMSComponent comp;
        System.gc();
        long start = System.currentTimeMillis();
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception e) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception e) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception e) {}
        }
        long end = System.currentTimeMillis();
        this.getModel().getRuntime().println("Exec time: " + (end - start) + " ms", 1);
    }

    public void run() {
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getChildrenEnumerator();
        }
        if (!this.enable.getValue()) {
            this.singleRun();
        } else {
            this.resetValues();
            while (this.hasNext()) {
                this.updateValues();
                this.singleRun();
                this.paraWriter.addData((Object)this.currentCount);
                for (int i = 0; i < this.parameters.length; ++i) {
                    this.paraWriter.addData((Object)this.parameters[i].getValue());
                }
                for (int e = 0; e < this.effValues.length; ++e) {
                    this.paraWriter.addData((Object)this.effValues[e].getValue());
                }
                try {
                    this.paraWriter.writeData();
                    this.paraWriter.flush();
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
                this.valueArray[this.runCounter] = this.targetValue.getValue();
                ++this.runCounter;
            }
            this.runEnumerator.reset();
            while (this.runEnumerator.hasNext() && this.doRun) {
                JAMSComponent jAMSComponent = this.runEnumerator.next();
            }
        }
    }

    public void cleanup() {
        if (this.enable.getValue()) {
            int sampleCount = this.resX.getValue() * this.resY.getValue();
            JAMSCalendar timeStamp = this.modelTimeInterval.getStart();
            for (int t = 0; t <= this.timeSteps; ++t) {
                this.attribWriter.addData((Object)timeStamp.toString("%1$tY-%1$tm-%1$td %1$tH:%1$tM"));
                timeStamp.add(this.modelTimeInterval.getTimeUnit(), 1);
                for (int r = 0; r < sampleCount; ++r) {
                    this.attribWriter.addData((Object)this.valueArray[r][t]);
                }
                try {
                    this.attribWriter.writeData();
                    continue;
                }
                catch (RuntimeException jre) {
                    this.getModel().getRuntime().println(jre.getMessage());
                }
            }
            this.attribWriter.close();
            this.paraWriter.close();
        }
    }
}

