/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="FlowAggregator", author="Peter Krause", description="Recalculates outflows from reaches into user defined flow values.")
public class FlowAggregator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Collection of reach objects")
    public JAMSEntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Target entity keeping the aggregated data")
    public JAMSEntity targetEntity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Attribute name of flow component")
    public JAMSString aNameFlowComponent;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Reach entity last = 1, all = 0")
    public JAMSInteger reachEntity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Area of the target entity")
    public JAMSString aNameArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Aggregation type")
    public JAMSInteger aggregationType;
    final int NO_TRANSFORMATION = 0;
    final int LITRES_2_CUBIC_METERS = 1;
    final int LITRES_2_CUBIC_METERS_PER_SECOND = 2;
    final int MILLIMETERS = 3;
    final int LITRES_PER_SECOND = 4;
    final int ALL = 0;
    final int LAST = 1;

    public void run() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntity[] entities = this.reaches.getEntityArray();
        double flow = 0.0;
        double out_flow = 0.0;
        int n = this.reachEntity.getValue();
        ((Object)((Object)this)).getClass();
        if (n == 0) {
            for (int i = 0; i < entities.length; ++i) {
                flow += entities[i].getDouble(this.aNameFlowComponent.getValue());
            }
        } else {
            int n2 = this.reachEntity.getValue();
            ((Object)((Object)this)).getClass();
            if (n2 == 1) {
                flow = entities[entities.length - 1].getDouble(this.aNameFlowComponent.getValue());
            }
        }
        int n3 = this.aggregationType.getValue();
        ((Object)((Object)this)).getClass();
        if (n3 == 0) {
            out_flow = flow;
        } else {
            int n4 = this.aggregationType.getValue();
            ((Object)((Object)this)).getClass();
            if (n4 == 1) {
                out_flow = flow / 1000.0;
            } else if (this.aggregationType.getValue() == this.LITRES_2_CUBIC_METERS_PER_SECOND) {
                out_flow = flow / 8.64E7;
            } else if (this.aggregationType.getValue() == this.MILLIMETERS) {
                out_flow = flow / this.targetEntity.getDouble(this.aNameArea.getValue());
            } else if (this.aggregationType.getValue() == this.LITRES_PER_SECOND) {
                out_flow = flow / 3600.0;
            }
        }
        this.targetEntity.setDouble(this.aNameFlowComponent.getValue(), out_flow);
    }
}

