/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class FlowAggregator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="catchment area")
    public JAMSDouble cArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="direct runoff")
    public JAMSDouble dirQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="base flow")
    public JAMSDouble basQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="total outflow cbm")
    public JAMSDouble totQcbm;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="total outflow mm")
    public JAMSDouble totQmm;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double totOut = this.dirQ.getValue() + this.basQ.getValue();
        this.totQmm.setValue(totOut);
        totOut = totOut * this.cArea.getValue() / 8.64E7;
        this.totQcbm.setValue(totOut);
    }

    public void cleanup() {
    }
}

