/*
 * Decompiled with CFR 0.152.
 */
package jams.components.tools;

import java.util.Random;
import java.util.StringTokenizer;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSContext;
import org.unijena.jams.model.JAMSVarDescription;
import org.unijena.jams.runtime.RuntimeException;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class JAMSParaSampler
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="List of parameter identifiers to be sampled")
    public JAMSString parameterIDs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="List of parameter value bounaries corresponding to parameter identifiers")
    public JAMSString boundaries;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Number of samples to be taken")
    public JAMSInteger sampleCount;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="efficiency criteria")
    public JAMSDouble[] effMethod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Flag for disabling this sampler")
    public JAMSBoolean disable;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT)
    public JAMSString fileName;
    JAMSDouble[] parameters;
    double[] lowBound;
    double[] upBound;
    int currentCount;
    Random generator;
    double bestGoodness = Double.MAX_VALUE;
    double bestMinimum = Double.MAX_VALUE;
    double[] bestValues;
    GenericDataWriter writer;

    private boolean hasNext() {
        return this.currentCount < this.sampleCount.getValue();
    }

    private void updateValues() {
        this.getModel().getRuntime().println("Run No. " + this.currentCount + " of " + this.sampleCount.getValue());
        double[] sample = null;
        if (this.parameters.length == 1) {
            sample = new double[1];
            double d = this.generator.nextDouble();
            sample[0] = this.lowBound[0] + d * (this.upBound[0] - this.lowBound[0]);
        }
        if (this.parameters.length == 2) {
            sample = this.abSampler();
        } else if (this.parameters.length == 3) {
            sample = this.abcSampler();
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            this.generator.nextDouble();
            this.parameters[i].setValue(sample[i]);
        }
        ++this.currentCount;
    }

    private double[] abSampler() {
        double[] sample = new double[2];
        double d = this.generator.nextDouble();
        sample[0] = this.lowBound[0] + d * (this.upBound[0] - this.lowBound[0]);
        d = this.generator.nextDouble();
        sample[1] = this.lowBound[1] + d * (this.upBound[1] - this.lowBound[1] - sample[0]);
        this.getModel().getRuntime().sendInfoMsg("a: " + sample[0]);
        this.getModel().getRuntime().sendInfoMsg("b: " + sample[1]);
        return sample;
    }

    private double[] abcSampler() {
        double[] sample = new double[3];
        double d = this.generator.nextDouble();
        sample[1] = this.lowBound[1] + d * (this.upBound[1] - this.lowBound[1]);
        d = this.generator.nextDouble();
        sample[0] = this.lowBound[0] + d * (this.upBound[0] - this.lowBound[0] - sample[1]);
        d = this.generator.nextDouble();
        sample[2] = this.lowBound[2] + d * (this.upBound[2] - this.lowBound[2]);
        this.getModel().getRuntime().sendInfoMsg("a: " + sample[0]);
        this.getModel().getRuntime().sendInfoMsg("b: " + sample[1]);
        this.getModel().getRuntime().sendInfoMsg("c: " + sample[2]);
        return sample;
    }

    private void resetValues() {
        this.generator = new Random(System.currentTimeMillis());
        for (int i = 0; i < this.parameters.length; ++i) {
            double d = this.generator.nextDouble();
            this.parameters[i].setValue(this.lowBound[i] + d * (this.upBound[i] - this.lowBound[i]));
        }
        this.currentCount = 0;
    }

    private void singleRun() {
        JAMSComponent comp;
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception e) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception e) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception exception) {}
        }
    }

    public void run() {
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getChildrenEnumerator();
        }
        if (this.disable.getValue()) {
            this.singleRun();
        } else {
            this.resetValues();
            while (this.hasNext()) {
                this.updateValues();
                this.singleRun();
                this.writer.addData((Object)this.currentCount);
                for (int i = 0; i < this.parameters.length; ++i) {
                    this.writer.addData((Object)this.parameters[i].getValue());
                }
                for (int e = 0; e < this.effMethod.length; ++e) {
                    this.writer.addData((Object)this.effMethod[e].getValue());
                }
                try {
                    this.writer.writeData();
                }
                catch (RuntimeException e) {}
            }
            this.runEnumerator.reset();
            while (this.runEnumerator.hasNext() && this.doRun) {
                this.runEnumerator.next();
                try {
                    this.getModel().getRuntime().println("comp cleanup from parasampler");
                }
                catch (Exception exception) {}
            }
        }
    }

    public void init() {
        String key;
        StringTokenizer tok = new StringTokenizer(this.parameterIDs.getValue(), ";");
        this.parameters = new JAMSDouble[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            key = tok.nextToken();
            this.parameters[i++] = (JAMSDouble)this.getModel().getRuntime().getDataHandles().get(key);
        }
        tok = new StringTokenizer(this.boundaries.getValue(), ";");
        int n = tok.countTokens();
        this.lowBound = new double[n];
        this.upBound = new double[n];
        this.bestValues = new double[n];
        if (n != i) {
            this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": Different number of parameterIDs and boundaries!");
        }
        i = 0;
        while (tok.hasMoreTokens()) {
            key = tok.nextToken();
            key = key.substring(1, key.length() - 1);
            StringTokenizer boundTok = new StringTokenizer(key, ">");
            this.lowBound[i] = Double.parseDouble(boundTok.nextToken());
            this.upBound[i] = Double.parseDouble(boundTok.nextToken());
            if (this.upBound[i] <= this.lowBound[i]) {
                this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": upBound must be higher than lowBound!");
            }
            ++i;
        }
        this.writer = new GenericDataWriter(this.fileName.getValue());
        this.writer.addColumn("Run");
        for (int j = 0; j < this.parameters.length; ++j) {
            this.writer.addColumn("para_" + j);
        }
        this.writer.addColumn("e2");
        this.writer.addColumn("le2");
        this.writer.writeHeader();
    }

    public void cleanup() {
        if (!this.disable.getValue()) {
            this.writer.close();
        }
    }
}

