/*
 * Decompiled with CFR 0.152.
 */
package jams.components.optimizer.nn;

import jams.components.optimizer.nn.Numeric;
import java.util.Vector;

public class Matrix {
    public int rows;
    public int columns;
    public double[][] element;

    public Matrix() {
        this.rows = 1;
        this.columns = 1;
        this.element = new double[this.rows][this.columns];
    }

    public Matrix(int r, int c) {
        this.rows = r;
        this.columns = c;
        this.element = new double[this.rows][this.columns];
    }

    public Matrix(double d) {
        this.rows = 1;
        this.columns = 1;
        this.element = new double[1][1];
        this.element[0][0] = d;
    }

    public Matrix(int r, int c, double fill) {
        this.rows = r;
        this.columns = c;
        this.element = new double[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.element[i][j] = fill;
            }
        }
    }

    public Matrix(Matrix m) {
        this.rows = m.rows;
        this.columns = m.columns;
        this.element = new double[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.element[i][j] = m.element[i][j];
            }
        }
    }

    public Matrix(int r, int c, char code) {
        block6: {
            block7: {
                block5: {
                    this.rows = r;
                    this.columns = c;
                    this.element = new double[this.rows][this.columns];
                    if (code != 'i' && code != 'I') break block5;
                    for (int i = 0; i < r; ++i) {
                        if (i >= c) continue;
                        this.element[i][i] = 1.0;
                    }
                    break block6;
                }
                if (code != 'h' && code != 'H') break block7;
                for (int i = 0; i < r; ++i) {
                    for (int j = 0; j < c; ++j) {
                        this.element[i][j] = 1.0 / ((double)i + (double)j + 1.0);
                    }
                }
                break block6;
            }
            if (code != 'r' && code != 'R') break block6;
            for (int i = 0; i < r; ++i) {
                for (int j = 0; j < c; ++j) {
                    this.element[i][j] = Math.random();
                }
            }
        }
    }

    public Matrix(String s) {
        int j;
        Vector row = new Vector();
        Vector<String> col = new Vector<String>();
        s = s + " ;";
        int i = s.length();
        int rowCounter = 0;
        int colCounter = 0;
        String sData = new String();
        for (j = 0; j < i; ++j) {
            char sChar = s.charAt(j);
            if (sChar == ' ' || sChar == ',' || sChar == '\t' || sChar == ';' || sChar == '\r' || sChar == '\n') {
                Double fl = new Double(0.0);
                try {
                    boolean testSpace = true;
                    for (int ii = 0; ii < sData.length(); ++ii) {
                        testSpace = testSpace && sData.charAt(ii) == ' ';
                    }
                    if (!testSpace) {
                        fl = new Double(sData);
                        col.addElement(sData);
                    }
                    sData = new String();
                }
                catch (Exception e) {
                    sData = new String();
                }
                if (sChar != ';' && sChar != '\r' && sChar != '\n' || col.isEmpty()) continue;
                row.addElement(col);
                ++rowCounter;
                sData = new String();
                colCounter = col.size();
                col = new Vector<String>();
                continue;
            }
            if (!Character.isDigit(sChar) && sChar != '.' && sChar != '-') continue;
            sData = sData + sChar;
        }
        this.rows = rowCounter;
        this.columns = colCounter;
        this.element = new double[this.rows][this.columns];
        col = new Vector();
        Double d = new Double(0.0);
        for (j = 0; j < this.rows; ++j) {
            col = (Vector<String>)row.elementAt(j);
            for (i = 0; i < col.size(); ++i) {
                d = new Double((String)col.elementAt(i));
                this.element[j][i] = d;
            }
        }
    }

    public Matrix transpose() {
        Matrix t = new Matrix(this.columns, this.rows);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                t.element[j][i] = this.element[i][j];
            }
        }
        return t;
    }

    public Matrix diag() {
        Matrix t = new Matrix(this.rows, 1);
        if (this.columns == 1) {
            t = new Matrix(this.rows, this.rows);
        }
        for (int i = 0; i < this.rows; ++i) {
            int j;
            int k;
            if (this.columns > 1) {
                k = 0;
                j = i;
            } else {
                k = i;
                j = 0;
            }
            t.element[i][k] = this.element[i][j];
        }
        return t;
    }

    public static Matrix add(Matrix m1, Matrix m2) {
        Matrix m = new Matrix(m1.rows, m1.columns);
        if (m1.rows == m2.rows && m1.columns == m2.columns) {
            for (int i = 0; i < m.rows; ++i) {
                for (int j = 0; j < m.columns; ++j) {
                    m.element[i][j] = m1.element[i][j] + m2.element[i][j];
                }
            }
        }
        return m;
    }

    public static Matrix subtract(Matrix m1, Matrix m2) {
        Matrix m = new Matrix(m1.rows, m1.columns);
        if (m1.rows == m2.rows && m1.columns == m2.columns) {
            for (int i = 0; i < m.rows; ++i) {
                for (int j = 0; j < m.columns; ++j) {
                    m.element[i][j] = m1.element[i][j] - m2.element[i][j];
                }
            }
        }
        return m;
    }

    public static Matrix multiply(double d, Matrix m1) {
        Matrix m = new Matrix(m1.rows, m1.columns);
        for (int i = 0; i < m.rows; ++i) {
            for (int j = 0; j < m.columns; ++j) {
                m.element[i][j] = d * m1.element[i][j];
            }
        }
        return m;
    }

    public static Matrix multiply(Matrix m1, Matrix m2) {
        Matrix m;
        block6: {
            block5: {
                m = new Matrix(0.0);
                if (m1.columns != m2.rows) break block5;
                double sum = 0.0;
                int k = 0;
                m = new Matrix(m1.rows, m2.columns);
                for (int i = 0; i < m.rows; ++i) {
                    for (k = 0; k < m2.columns; ++k) {
                        for (int j = 0; j < m1.columns; ++j) {
                            sum += m1.element[i][j] * m2.element[j][k];
                        }
                        m.element[i][k] = sum;
                        sum = 0.0;
                    }
                }
                break block6;
            }
            if (m1.columns != 1 || m1.rows != 1) break block6;
            m = new Matrix(m2.rows, m2.columns);
            for (int i = 0; i < m.rows; ++i) {
                for (int j = 0; j < m.columns; ++j) {
                    m.element[i][j] = m1.element[0][0] * m2.element[i][j];
                }
            }
        }
        return m;
    }

    public static Matrix divide(Matrix m1, Matrix m2) {
        Matrix m;
        block5: {
            block4: {
                m = new Matrix(0.0);
                if (m2.columns != 1 || m2.rows != 1) break block4;
                m = new Matrix(m1.rows, m1.columns);
                for (int i = 0; i < m.rows; ++i) {
                    for (int j = 0; j < m.columns; ++j) {
                        m.element[i][j] = m1.element[i][j] / m2.element[0][0];
                    }
                }
                break block5;
            }
            if (m2.columns != m2.rows || m1.columns != 1 || m1.rows != m2.rows) break block5;
            m = new Matrix(m2.rows, 1);
            Matrix Q = m2.Q();
            Matrix R = m2.R();
            Matrix b = Matrix.multiply(Q.transpose(), m1);
            double sum = 0.0;
            m.element[m.rows - 1][0] = b.element[m.rows - 1][0] / R.element[m.rows - 1][m.rows - 1];
            for (int i = m.rows - 1; i >= 0; --i) {
                sum = 0.0;
                for (int j = m.rows - 1; j >= i + 1; --j) {
                    sum += R.element[i][j] * m.element[j][0];
                }
                m.element[i][0] = (b.element[i][0] - sum) / R.element[i][i];
            }
        }
        return m;
    }

    public Matrix sub(int r1, int r2, int c1, int c2) {
        Matrix A = new Matrix(r2 - r1 + 1, c2 - c1 + 1);
        for (int i = r1; i <= r2; ++i) {
            for (int j = c1; j <= c2; ++j) {
                A.element[i - r1][j - c1] = this.element[i][j];
            }
        }
        return A;
    }

    public Matrix appendCols(Matrix x) {
        Matrix M = new Matrix(this.rows, this.columns + x.columns);
        for (int i = 0; i < this.rows; ++i) {
            int j;
            for (j = 0; j < this.columns; ++j) {
                M.element[i][j] = this.element[i][j];
            }
            for (j = 0; j < x.columns; ++j) {
                M.element[i][this.columns + j] = x.element[i][j];
            }
        }
        return M;
    }

    public Matrix appendRows(Matrix x) {
        Matrix M = new Matrix(this.rows + x.rows, this.columns);
        for (int i = 0; i < this.columns; ++i) {
            int j;
            for (j = 0; j < this.rows; ++j) {
                M.element[j][i] = this.element[j][i];
            }
            for (j = 0; j < x.rows; ++j) {
                M.element[this.rows + j][i] = x.element[j][i];
            }
        }
        return M;
    }

    public Matrix flipud() {
        Matrix M = new Matrix(this.rows, this.columns);
        for (int k = 0; k < this.rows; ++k) {
            for (int j = 0; j < this.columns; ++j) {
                M.element[this.rows - k - 1][j] = this.element[k][j];
            }
        }
        return M;
    }

    public Matrix fliplr() {
        Matrix M = new Matrix(this.rows, this.columns);
        for (int k = 0; k < this.rows; ++k) {
            for (int j = 0; j < this.columns; ++j) {
                M.element[k][this.columns - j - 1] = this.element[k][j];
            }
        }
        return M;
    }

    public Matrix permute(int a1, int a2, char c) {
        Matrix p;
        block3: {
            block2: {
                p = new Matrix(this);
                if (c != 'r') break block2;
                for (int i = 0; i < this.columns; ++i) {
                    p.element[a1][i] = this.element[a2][i];
                    p.element[a2][i] = this.element[a1][i];
                }
                break block3;
            }
            if (c != 'c') break block3;
            for (int i = 0; i < this.rows; ++i) {
                p.element[i][a1] = this.element[i][a2];
                p.element[i][a2] = this.element[i][a1];
            }
        }
        return p;
    }

    public double norm() {
        double l = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                l += this.element[i][j] * this.element[i][j];
            }
        }
        l = Math.pow(l, 0.5);
        return l;
    }

    public double max() {
        double m = this.element[0][0];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                if (!(this.element[i][j] > m)) continue;
                m = this.element[i][j];
            }
        }
        return m;
    }

    public double sum() {
        double s = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                s += this.element[i][j];
            }
        }
        return s;
    }

    public double average() {
        double s = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                s += this.element[i][j];
            }
        }
        return s / (double)(this.columns * this.rows);
    }

    public double sumSquares() {
        double s = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                s += Math.pow(this.element[i][j], 2.0);
            }
        }
        return s;
    }

    public Matrix Q() {
        Matrix P = new Matrix(this.rows, this.rows, 'I');
        Matrix A = new Matrix(this);
        for (int j = 0; j < this.columns; ++j) {
            Matrix v = A.sub(0, A.rows - 1, j, j);
            if (j > 0) {
                for (int i = 0; i < j; ++i) {
                    v.element[i][0] = 0.0;
                }
            }
            v.element[j][0] = v.element[j][0] + v.norm() * this.sign(v.element[j][0]);
            double r = -2.0 / (v.norm() * v.norm());
            Matrix AA = new Matrix(A);
            A = Matrix.multiply(v.transpose(), A);
            A = Matrix.multiply(v, A);
            A = Matrix.multiply(r, A);
            A = Matrix.add(AA, A);
            Matrix PP = new Matrix(P);
            P = Matrix.multiply(v.transpose(), P);
            P = Matrix.multiply(v, P);
            P = Matrix.multiply(r, P);
            P = Matrix.add(PP, P);
        }
        return P.transpose();
    }

    public Matrix R() {
        Matrix P = new Matrix(this.rows, this.rows, 'I');
        Matrix A = new Matrix(this);
        for (int j = 0; j < this.columns; ++j) {
            Matrix v = A.sub(0, A.rows - 1, j, j);
            if (j > 0) {
                for (int i = 0; i < j; ++i) {
                    v.element[i][0] = 0.0;
                }
            }
            v.element[j][0] = v.element[j][0] + v.norm() * this.sign(v.element[j][0]);
            double r = -2.0 / (v.norm() * v.norm());
            Matrix AA = new Matrix(A);
            A = Matrix.multiply(v.transpose(), A);
            A = Matrix.multiply(v, A);
            A = Matrix.multiply(r, A);
            A = Matrix.add(AA, A);
            Matrix PP = new Matrix(P);
            P = Matrix.multiply(v.transpose(), P);
            P = Matrix.multiply(v, P);
            P = Matrix.multiply(r, P);
            P = Matrix.add(PP, P);
        }
        return A;
    }

    public Vector qr() {
        Vector<Matrix> result = new Vector<Matrix>();
        Matrix P = new Matrix(this.rows, this.rows, 'I');
        Matrix A = new Matrix(this);
        for (int j = 0; j < this.columns; ++j) {
            Matrix v = A.sub(0, A.rows - 1, j, j);
            if (j > 0) {
                for (int i = 0; i < j; ++i) {
                    v.element[i][0] = 0.0;
                }
            }
            v.element[j][0] = v.element[j][0] + v.norm() * this.sign(v.element[j][0]);
            double r = -2.0 / (v.norm() * v.norm());
            Matrix AA = new Matrix(A);
            A = Matrix.multiply(v.transpose(), A);
            A = Matrix.multiply(v, A);
            A = Matrix.multiply(r, A);
            A = Matrix.add(AA, A);
            Matrix PP = new Matrix(P);
            P = Matrix.multiply(v.transpose(), P);
            P = Matrix.multiply(v, P);
            P = Matrix.multiply(r, P);
            P = Matrix.add(PP, P);
        }
        result.addElement(A);
        result.addElement(P.transpose());
        return result;
    }

    public Vector toHess() {
        Vector<Matrix> result = new Vector<Matrix>();
        Matrix P = new Matrix(this.rows, this.columns, 'I');
        Matrix I = new Matrix(this.rows, this.columns, 'I');
        Matrix A = new Matrix(this);
        for (int j = 0; j < this.columns - 2; ++j) {
            Matrix v = new Matrix(this.rows, 1);
            v.element[j][0] = 1.0;
            v = Matrix.multiply(A, v);
            for (int i = 0; i < j + 1; ++i) {
                v.element[i][0] = 0.0;
            }
            v.element[j + 1][0] = v.element[j + 1][0] + v.norm() * this.sign(v.element[j + 1][0]);
            double r = -2.0 / (v.norm() * v.norm());
            v = Matrix.multiply(v, v.transpose());
            v = Matrix.multiply(r, v);
            v = Matrix.add(I, v);
            P = Matrix.multiply(P, v);
            A = Matrix.multiply(P.transpose(), this);
            A = Matrix.multiply(A, P);
        }
        result.addElement(P);
        result.addElement(A);
        return result;
    }

    public Vector gepp() {
        int k;
        Vector<Matrix> v = new Vector<Matrix>();
        Matrix P = new Matrix(this.rows, this.columns, 'I');
        Matrix L = new Matrix(this.rows, this.columns, 'I');
        Matrix U = this;
        Matrix G = new Matrix(this.rows, this.columns, 'I');
        for (int j = 0; j < this.columns - 1; ++j) {
            int i;
            double d = Math.abs(U.element[j][j]);
            int p = j;
            for (i = j + 1; i < this.rows; ++i) {
                if (!(Math.abs(U.element[i][j]) > d)) continue;
                d = Math.abs(U.element[i][j]);
                p = i;
            }
            if (p > j) {
                U = U.permute(j, p, 'r');
                P = P.permute(j, p, 'r');
            }
            for (i = j + 1; i < this.rows; ++i) {
                if (U.element[j][j] == 0.0) continue;
                G.element[i][j] = -U.element[i][j] / U.element[j][j];
            }
            U = Matrix.multiply(G, U);
            L = L.permute(j, p, 'r');
            for (k = 0; k < j; ++k) {
                L.element[k][j] = 0.0;
            }
            L.element[j][j] = 1.0;
            for (k = j + 1; k < this.rows; ++k) {
                L.element[k][j] = -G.element[k][j];
                G.element[k][j] = 0.0;
            }
        }
        for (k = 0; k < this.rows; ++k) {
            L.element[k][this.columns - 1] = 0.0;
        }
        L.element[this.rows - 1][this.columns - 1] = 1.0;
        v.addElement(P);
        v.addElement(L);
        v.addElement(U);
        return v;
    }

    public double leig(double p) {
        Matrix Q = new Matrix(this.rows, this.columns);
        Matrix R = new Matrix(this.rows, this.columns);
        Matrix A = new Matrix(this);
        int i = 1;
        int maxIter = 200 - this.rows;
        if (maxIter < 25) {
            maxIter = 25;
        }
        double v = 99.0;
        double res = 99.0;
        while (i < maxIter && res > p) {
            Vector qr = A.qr();
            Q = (Matrix)qr.elementAt(1);
            R = (Matrix)qr.elementAt(0);
            A = Matrix.multiply(R, Q);
            ++i;
            res = Math.abs(A.element[0][0] - v);
            v = A.element[0][0];
        }
        return A.element[0][0];
    }

    public String toString(int d) {
        String newln = System.getProperty("line.separator");
        String outPut = new String();
        String num = new String();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                Numeric x = new Numeric(this.element[i][j]);
                num = x.toString(d);
                outPut = outPut + num + '\t';
            }
            outPut = outPut + newln;
        }
        return outPut;
    }

    public String toString() {
        String outPut = this.toString(6);
        return outPut;
    }

    public Matrix sort() {
        Matrix R;
        block6: {
            int i;
            int[] indx;
            double[] a;
            block5: {
                int i2;
                R = new Matrix();
                double d = Math.max(this.columns, this.rows);
                int lngth = (int)d;
                a = new double[lngth];
                indx = new int[lngth];
                if (this.rows != 1 && this.columns != 1) break block5;
                a = new double[lngth];
                indx = new int[lngth];
                for (i2 = 0; i2 < lngth; ++i2) {
                    a[i2] = this.rows < this.columns ? this.element[0][i2] : this.element[i2][0];
                    indx[i2] = i2 + 1;
                }
                this.qsort(a, indx, 0, lngth - 1);
                R = new Matrix(lngth, 2);
                for (i2 = 0; i2 < lngth; ++i2) {
                    R.element[i2][0] = a[i2];
                    R.element[i2][1] = indx[i2];
                }
                break block6;
            }
            if (this.columns <= 1) break block6;
            a = new double[this.rows];
            indx = new int[this.rows];
            for (i = 0; i < this.rows; ++i) {
                a[i] = this.element[i][0];
                indx[i] = i + 1;
            }
            this.qsort(a, indx, 0, this.rows - 1);
            R = new Matrix(this.rows, this.columns);
            for (i = 0; i < this.rows; ++i) {
                for (int k = 0; k < this.columns; ++k) {
                    R.element[i][k] = this.element[indx[i] - 1][k];
                }
            }
        }
        return R;
    }

    public Matrix order() {
        int i;
        int j;
        Matrix S = this.sort();
        Matrix y = new Matrix(S.rows, 1);
        double[] v = new double[S.rows];
        for (i = 0; i < S.rows; i += j) {
            int k;
            j = 0;
            int l = 0;
            for (k = i; k < S.rows; ++k) {
                if (S.element[k][0] != S.element[i][0]) continue;
                ++j;
                l = l + k + 1;
            }
            for (k = 0; k < j; ++k) {
                v[i + k] = (double)l / (double)j;
            }
        }
        for (i = 0; i < S.rows; ++i) {
            y.element[(int)S.element[i][1] - 1][0] = v[i];
        }
        return y;
    }

    double sign(double d) {
        double s = 1.0;
        if (d < 0.0) {
            s = -1.0;
        }
        return s;
    }

    void qsort(double[] a, int[] index, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            double mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && a[lo] < mid) {
                    ++lo;
                }
                while (hi > lo0 && a[hi] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                this.swap(a, lo, hi);
                this.swap(index, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.qsort(a, index, lo0, hi);
            }
            if (lo < hi0) {
                this.qsort(a, index, lo, hi0);
            }
        }
    }

    private void swap(double[] a, int i, int j) {
        double T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    private void swap(int[] a, int i, int j) {
        int T = a[i];
        a[i] = a[j];
        a[j] = T;
    }
}

