/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import org.unijena.jams.data.JAMSDataFactory;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class StandardEntityReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Workspace directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU parameter file name")
    public JAMSString hruFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntityCollection hrus;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        this.hrus.setEntities(this.readParas(this.dirName.getValue() + "/" + this.hruFileName.getValue()));
    }

    public ArrayList<JAMSEntity> readParas(String fileName) {
        ArrayList<JAMSEntity> entityList = new ArrayList<JAMSEntity>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String s = "#";
            while (s.startsWith("#")) {
                s = reader.readLine();
            }
            Vector<String> attributeNames = new Vector<String>();
            StringTokenizer tokenizer = new StringTokenizer(s, "\t");
            while (tokenizer.hasMoreTokens()) {
                attributeNames.add(tokenizer.nextToken());
            }
            reader.readLine();
            reader.readLine();
            reader.readLine();
            s = reader.readLine();
            while (s != null && !s.startsWith("#")) {
                JAMSEntity e = JAMSDataFactory.createEntity();
                tokenizer = new StringTokenizer(s, "\t");
                for (int i = 0; i < attributeNames.size(); ++i) {
                    String token = tokenizer.nextToken();
                    try {
                        e.setDouble((String)attributeNames.get(i), Double.parseDouble(token));
                        this.getModel().getRuntime().println((String)attributeNames.get(i) + ": " + token, 4);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        e.setObject((String)attributeNames.get(i), (Object)token);
                    }
                }
                entityList.add(e);
                s = reader.readLine();
            }
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Exception)ioe);
        }
        return entityList;
    }
}

