/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui.spreadsheet;

import jams.components.gui.spreadsheet.CTSPlot;
import jams.components.gui.spreadsheet.GraphProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import org.unijena.jams.data.JAMSCalendar;

public class CTSConfigurator
extends JDialog {
    GroupLayout gLayout;
    GroupLayout.SequentialGroup hGroup;
    GroupLayout.SequentialGroup vGroup;
    GroupLayout.Group group1;
    GroupLayout.Group group2;
    GroupLayout.Group group3;
    GroupLayout.Group group4;
    GroupLayout.Group group5;
    GroupLayout.Group group6;
    GroupLayout.Group group7;
    GroupLayout.Group group8;
    GroupLayout.Group group9;
    GroupLayout.Group group10;
    GroupLayout.Group group11;
    GroupLayout.Group group12;
    GroupLayout.Group group13;
    GroupLayout.Group group14;
    GroupLayout.Group group15;
    private Vector<ActionListener> addAction = new Vector();
    private JDialog parent;
    private JPanel frame;
    private JPanel mainpanel;
    private JPanel plotpanel;
    private JPanel optionpanel;
    private JPanel graphpanel;
    private JPanel southpanel;
    private JPanel edTitlePanel;
    private JPanel edLeftAxisPanel;
    private JPanel edRightAxisPanel;
    private JPanel edTimeAxisPanel;
    private JPanel[] datapanels;
    private JScrollPane graphScPane;
    private JScrollPane plotScPane;
    private JScrollPane mainScPane;
    private String[] headers;
    private JLabel edTitle = new JLabel("Plot Title: ");
    private JLabel edLeft = new JLabel("Left axis title: ");
    private JLabel edRight = new JLabel("Right axis title: ");
    private JTextField edTitleField = new JTextField(14);
    private JTextField edLeftField = new JTextField(14);
    private JTextField edRightField = new JTextField(14);
    private JButton applyButton = new JButton("Apply");
    private Vector<GraphProperties> propVector = new Vector();
    private int index;
    HashMap<String, Color> colorTable = new HashMap();
    int[] rows;
    int[] columns;
    JTable table;
    CTSPlot ctsplot;
    JButton addbutton = new JButton("add graph");
    JButton plotbutton = new JButton("plot");
    JButton deletebutton = new JButton("delete");
    JButton propbutton = new JButton("properties");
    int graphCount = 0;
    JCheckBox[] activate;
    JComboBox[] datachoice;
    JComboBox[] poschoice;
    JComboBox[] typechoice;
    JComboBox[] colorchoice;
    ActionListener[] activationChange;
    ActionListener titleListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            CTSConfigurator.this.ctsplot.getChart().setTitle(CTSConfigurator.this.edTitleField.getText());
        }
    };
    ActionListener propbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CTSConfigurator.this.ctsplot.getChartPanel().doEditChartProperties();
        }
    };
    ActionListener addbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    ActionListener plotbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CTSConfigurator.this.timePlot();
        }
    };
    ActionListener actChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };

    public CTSConfigurator() {
    }

    public CTSConfigurator(JFrame parent, JTable table) {
        super((Frame)parent, "JAMS CTS Viewer");
        this.setLayout(new FlowLayout());
        Point parentloc = parent.getLocation();
        this.setLocation(parentloc.x + 30, parentloc.y + 30);
        this.table = table;
        this.rows = table.getSelectedRows();
        this.columns = table.getSelectedColumns();
        this.graphCount = this.columns.length;
        this.headers = new String[this.graphCount];
        this.setSize(680, 480);
        this.setMinimumSize(new Dimension(680, 480));
        this.createPanel();
        this.timePlot();
        this.pack();
        this.setVisible(true);
    }

    public void createPanel() {
        this.colorTable.put("yellow", Color.yellow);
        this.colorTable.put("orange", Color.orange);
        this.colorTable.put("red", Color.red);
        this.colorTable.put("pink", Color.pink);
        this.colorTable.put("magenta", Color.magenta);
        this.colorTable.put("cyan", Color.cyan);
        this.colorTable.put("blue", Color.blue);
        this.colorTable.put("green", Color.green);
        this.colorTable.put("gray", Color.gray);
        this.colorTable.put("lightgray", Color.lightGray);
        this.colorTable.put("black", Color.black);
        JLabel nameLabel = new JLabel("Name");
        JLabel posLabel = new JLabel("Position");
        JLabel typeLabel = new JLabel("Renderer");
        JLabel colorLabel = new JLabel("Colour");
        JLabel dataLabel = new JLabel("Select Data");
        JLabel timeLabel = new JLabel("Time Interval");
        JLabel emptyTimeLabel = new JLabel("    ");
        JLabel legendLabel = new JLabel("Legend Entry");
        nameLabel.setBackground(Color.DARK_GRAY);
        posLabel.setBackground(Color.DARK_GRAY);
        typeLabel.setBackground(Color.DARK_GRAY);
        colorLabel.setBackground(Color.DARK_GRAY);
        dataLabel.setBackground(Color.DARK_GRAY);
        timeLabel.setBackground(Color.DARK_GRAY);
        this.setLayout(new BorderLayout());
        this.plotpanel = new JPanel();
        this.plotpanel.setLayout(new BorderLayout());
        this.frame = new JPanel();
        this.frame.setLayout(new BorderLayout());
        this.frame.setSize(640, 80);
        this.graphScPane = new JScrollPane();
        this.optionpanel = new JPanel();
        this.optionpanel.setLayout(new FlowLayout());
        this.graphpanel = new JPanel();
        this.initGroupUI();
        this.southpanel = new JPanel();
        this.southpanel.setLayout(new FlowLayout());
        this.edTitlePanel = new JPanel();
        this.edTitlePanel.setLayout(new FlowLayout());
        this.edLeftAxisPanel = new JPanel();
        this.edLeftAxisPanel.setLayout(new FlowLayout());
        this.edRightAxisPanel = new JPanel();
        this.edRightAxisPanel.setLayout(new FlowLayout());
        this.edTitleField.setText("Plot Title");
        this.edTitleField.addActionListener(this.actChanged);
        this.edLeftField.setText("Left Axis Title");
        this.edLeftField.addActionListener(this.actChanged);
        this.edRightField.setText("Right Axis Title");
        this.edRightField.addActionListener(this.actChanged);
        this.applyButton.addActionListener(this.plotbuttonclick);
        this.edTitlePanel.add(this.edTitle);
        this.edTitlePanel.add(this.edTitleField);
        this.edLeftAxisPanel.add(this.edLeft);
        this.edLeftAxisPanel.add(this.edLeftField);
        this.edRightAxisPanel.add(this.edRight);
        this.edRightAxisPanel.add(this.edRightField);
        this.optionpanel.add(this.edTitle);
        this.optionpanel.add(this.edTitleField);
        this.optionpanel.add(this.edLeft);
        this.optionpanel.add(this.edLeftField);
        this.optionpanel.add(this.edRight);
        this.optionpanel.add(this.edRightField);
        this.optionpanel.add(this.applyButton);
        for (int k = 0; k < this.graphCount; ++k) {
            GraphProperties prop = new GraphProperties(this.parent, this.table, this);
            prop.setIndex(k);
            prop.setSelectedColumn(this.columns[k]);
            prop.setSelectedRows(this.rows);
            prop.setTimeSTART(this.rows[0]);
            prop.setTimeEND(this.rows[this.rows.length - 1]);
            if (k <= 12) {
                prop.setColor(k);
            }
            prop.setName(this.table.getColumnName(k + 1));
            prop.setLegendName(this.table.getColumnName(k + 1));
            prop.getPlotButton().addActionListener(this.plotbuttonclick);
            this.addPropGroup(prop);
            this.propVector.add(k, prop);
        }
        this.finishGroupUI();
        this.addbutton.addActionListener(this.addbuttonclick);
        this.plotbutton.addActionListener(this.plotbuttonclick);
        this.propbutton.addActionListener(this.propbuttonclick);
        this.graphScPane = new JScrollPane(this.graphpanel);
        this.graphScPane.setPreferredSize(new Dimension(640, 120));
        this.graphScPane.setVerticalScrollBarPolicy(22);
        this.frame.add((Component)this.graphScPane, "North");
        this.frame.add((Component)this.optionpanel, "Center");
        this.optionpanel.setBorder(new EtchedBorder());
        this.plotScPane = new JScrollPane();
        this.add((Component)this.frame, "North");
        this.add((Component)this.plotScPane, "Center");
    }

    public void addGraph(int index) {
        int i = index;
        GraphProperties prop = new GraphProperties(this.parent, this.table, this);
        this.propVector.add(i, prop);
        this.graphCount = this.propVector.size();
        this.initGroupUI();
        for (int k = 0; k < this.graphCount; ++k) {
            prop = this.propVector.get(k);
            prop.setIndex(k);
            prop.getPlotButton().addActionListener(this.plotbuttonclick);
            this.addPropGroup(prop);
        }
        this.finishGroupUI();
        this.repaint();
    }

    public void removeGraph(int index) {
        this.propVector.remove(index);
        this.graphCount = this.propVector.size();
        this.initGroupUI();
        for (int k = 0; k < this.graphCount; ++k) {
            GraphProperties prop = this.propVector.get(k);
            prop.setIndex(k);
            prop.getPlotButton().addActionListener(this.plotbuttonclick);
            this.addPropGroup(prop);
        }
        this.finishGroupUI();
        this.repaint();
    }

    public void upGraph(int index) {
        int i = index;
        GraphProperties prop = this.propVector.get(i);
        if (i - 1 >= 0 && i - 1 < this.graphCount) {
            this.propVector.remove(i);
            this.propVector.add(i - 1, prop);
            this.initGroupUI();
            for (int k = 0; k < this.graphCount; ++k) {
                prop = this.propVector.get(k);
                prop.setIndex(k);
                prop.getPlotButton().addActionListener(this.plotbuttonclick);
                this.addPropGroup(prop);
            }
            this.finishGroupUI();
            this.pack();
            this.repaint();
        }
    }

    public void downGraph(int index) {
        int i = index;
        GraphProperties prop = this.propVector.get(i + 1);
        if (i + 1 >= 0 && i + 1 < this.graphCount) {
            this.propVector.remove(i + 1);
            this.propVector.add(i, prop);
            this.graphCount = this.propVector.size();
            this.initGroupUI();
            for (int k = 0; k < this.graphCount; ++k) {
                prop = this.propVector.get(k);
                prop.setIndex(k);
                prop.getPlotButton().addActionListener(this.plotbuttonclick);
                this.addPropGroup(prop);
            }
            this.finishGroupUI();
            this.pack();
            this.repaint();
        }
    }

    private void initGroupUI() {
        this.graphpanel.removeAll();
        JLabel nameLabel = new JLabel("Name");
        JLabel posLabel = new JLabel("Position");
        JLabel typeLabel = new JLabel("Legend/Position");
        JLabel colorLabel = new JLabel("Type/Colour");
        JLabel dataLabel = new JLabel("Select Data");
        JLabel timeLabel = new JLabel("Time Interval");
        JLabel emptyTimeLabel = new JLabel("    ");
        JLabel legendLabel = new JLabel("Legend Entry: ");
        this.gLayout = new GroupLayout(this.graphpanel);
        this.graphpanel.setLayout(this.gLayout);
        this.gLayout.setAutoCreateGaps(true);
        this.gLayout.setAutoCreateContainerGaps(true);
        this.hGroup = this.gLayout.createSequentialGroup();
        this.vGroup = this.gLayout.createSequentialGroup();
        this.group1 = this.gLayout.createParallelGroup();
        this.group2 = this.gLayout.createParallelGroup();
        this.group3 = this.gLayout.createParallelGroup();
        this.group4 = this.gLayout.createParallelGroup();
        this.group5 = this.gLayout.createParallelGroup();
        this.group6 = this.gLayout.createParallelGroup();
        this.group7 = this.gLayout.createParallelGroup();
        this.group8 = this.gLayout.createParallelGroup();
        this.group9 = this.gLayout.createParallelGroup();
        this.group10 = this.gLayout.createParallelGroup();
        this.group11 = this.gLayout.createParallelGroup();
        this.group12 = this.gLayout.createParallelGroup();
        this.group13 = this.gLayout.createParallelGroup();
        this.group14 = this.gLayout.createParallelGroup();
        this.group15 = this.gLayout.createParallelGroup();
        this.group1.addComponent(dataLabel);
        this.group2.addComponent(timeLabel);
        this.group3.addComponent(typeLabel);
        this.group4.addComponent(colorLabel);
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(dataLabel).addComponent(timeLabel).addComponent(typeLabel).addComponent(colorLabel));
    }

    private void addPropGroup(GraphProperties prop) {
        JLabel space1 = new JLabel(" ");
        JLabel space2 = new JLabel(" ");
        JLabel space3 = new JLabel(" ");
        JLabel space4 = new JLabel(" ");
        JLabel space5 = new JLabel("   ");
        JLabel space6 = new JLabel("   ");
        JTextField lf = prop.getLegendField();
        this.group6.addComponent(space5).addComponent(space6);
        this.group1.addComponent(prop.getDataChoice()).addComponent(space1);
        this.group2.addComponent(prop.getTimeChoiceSTART()).addComponent(prop.getTimeChoiceEND());
        this.group3.addComponent(lf).addComponent(prop.getPosChoice());
        this.group4.addComponent(prop.getTypeChoice()).addComponent(prop.getColorChoice());
        this.group9.addComponent(space3);
        this.group10.addComponent(prop.getPlotButton());
        this.group11.addComponent(space4);
        this.group12.addComponent(prop.getAddButton());
        this.group13.addComponent(prop.getRemButton());
        this.group14.addComponent(prop.getUpButton());
        this.group15.addComponent(prop.getDownButton());
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(prop.getDataChoice()).addComponent(prop.getTimeChoiceSTART()).addComponent(space5).addComponent(lf).addComponent(prop.getTypeChoice()));
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(space1).addComponent(prop.getTimeChoiceEND()).addComponent(space6).addComponent(prop.getPosChoice()).addComponent(prop.getColorChoice()).addComponent(space3).addComponent(prop.getPlotButton()).addComponent(space4).addComponent(prop.getAddButton()).addComponent(prop.getRemButton()).addComponent(prop.getUpButton()).addComponent(prop.getDownButton()));
    }

    private void finishGroupUI() {
        this.hGroup.addGroup(this.group1);
        this.hGroup.addGroup(this.group2);
        this.hGroup.addGroup(this.group6);
        this.hGroup.addGroup(this.group3);
        this.hGroup.addGroup(this.group4);
        this.hGroup.addGroup(this.group9);
        this.hGroup.addGroup(this.group10);
        this.hGroup.addGroup(this.group11);
        this.hGroup.addGroup(this.group12);
        this.hGroup.addGroup(this.group13);
        this.hGroup.addGroup(this.group14);
        this.hGroup.addGroup(this.group15);
        this.gLayout.setHorizontalGroup(this.hGroup);
        this.gLayout.setVerticalGroup(this.vGroup);
    }

    public JPanel getPanel() {
        return this.mainpanel;
    }

    public JPanel getCTSPlot() {
        return this.ctsplot.getPanel();
    }

    public JButton getDeleteButton() {
        return this.deletebutton;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    private void disableEnableFunct() {
        for (int k = 0; k < this.graphCount; ++k) {
        }
    }

    public void setParent(JDialog parent) {
        this.parent = parent;
    }

    private void editProperties() {
        JDialog propDlg = new JDialog((Dialog)this.parent, "Properties");
        int ct = this.headers.length;
        JLabel[] labels = new JLabel[ct];
        JTextField[] textFields = new JTextField[ct];
        JPanel[] inputpanels = new JPanel[ct];
        JPanel proppanel = new JPanel();
        proppanel.setLayout(new GridLayout(ct, 1));
        for (int i = 0; i < ct; ++i) {
            labels[i] = new JLabel(this.headers[i]);
            textFields[i] = new JTextField(this.headers[i]);
            inputpanels[i] = new JPanel();
            inputpanels[i].setLayout(new FlowLayout());
            inputpanels[i].add(labels[i]);
            inputpanels[i].add(textFields[i]);
        }
        JScrollPane propPane = new JScrollPane(proppanel);
    }

    public void timePlot() {
        int n;
        this.ctsplot = new CTSPlot();
        this.ctsplot.setTitle(this.edTitleField.getText());
        this.ctsplot.setLeftAxisTitle(this.edLeftField.getText());
        this.ctsplot.setRightAxisTitle(this.edRightField.getText());
        int numActiveLeft = 0;
        int numActiveRight = 0;
        int corr = 0;
        int row_start = 0;
        int row_end = 0;
        boolean typechosen_R = false;
        boolean typechosen_L = false;
        String[] colorLeft = new String[this.graphCount];
        String[] colorRight = new String[this.graphCount];
        String[] titleLeft = new String[this.graphCount];
        String[] titleRight = new String[this.graphCount];
        for (int i = 0; i < this.graphCount; ++i) {
            GraphProperties prop = this.propVector.get(i);
            int s = prop.getTimeSTART();
            int e = prop.getTimeEND();
            if (s > row_start) {
                row_start = s;
            }
            if (e > row_end) {
                row_end = e;
            }
            if (prop.getPosition() == "left") {
                this.ctsplot.setTypeLeft(prop.getRendererType());
                colorLeft[i - numActiveRight] = prop.getColor();
                titleLeft[i - numActiveRight] = prop.getLegendName();
                ++numActiveLeft;
            }
            if (prop.getPosition() != "right") continue;
            this.ctsplot.setTypeRight(prop.getRendererType());
            colorRight[i - numActiveLeft] = prop.getColor();
            titleRight[i - numActiveLeft] = prop.getLegendName();
            ++numActiveRight;
        }
        String[] legendLeft = new String[numActiveLeft];
        String[] legendRight = new String[numActiveRight];
        for (n = 0; n < numActiveLeft; ++n) {
            legendLeft[n] = titleLeft[n];
        }
        for (n = 0; n < numActiveRight; ++n) {
            legendRight[n] = titleRight[n];
        }
        this.ctsplot.setTitleLeft(legendLeft);
        this.ctsplot.setTitleRight(legendRight);
        this.ctsplot.setGraphCountLeft(numActiveLeft);
        this.ctsplot.setGraphCountRight(numActiveRight);
        this.ctsplot.setColorLeft(colorLeft);
        this.ctsplot.setColorRight(colorRight);
        this.ctsplot.setTitleLeft(titleLeft);
        this.ctsplot.setTitleRight(titleRight);
        this.ctsplot.createPlot();
        this.plotScPane.setViewportView(this.ctsplot.getPanel());
        double[] valueLeft = new double[numActiveLeft];
        double[] valueRight = new double[numActiveRight];
        boolean c = false;
        for (int k = row_start; k <= row_end; ++k) {
            int corrLeft = 0;
            int corrRight = 0;
            Object value = null;
            for (int i = 0; i < this.graphCount; ++i) {
                GraphProperties prop = this.propVector.get(i);
                int col = prop.getSelectedColumn();
                int s = prop.getTimeSTART();
                int e = prop.getTimeEND();
                if (k >= s && k <= e) {
                    value = this.table.getValueAt(k, col);
                    if (value.getClass() != Double.class) {
                        value = 0.0;
                    }
                    if (prop.getPosition() == "left") {
                        valueLeft[i - corrLeft] = (Double)value;
                        ++corrRight;
                    }
                    if (prop.getPosition() != "right") continue;
                    valueRight[i - corrRight] = (Double)value;
                    ++corrLeft;
                    continue;
                }
                ++corrRight;
                ++corrLeft;
                ++corr;
            }
            this.ctsplot.plot((JAMSCalendar)this.table.getValueAt(k, 0), valueLeft, valueRight);
        }
        this.repaint();
        this.pack();
    }

    public void createActionListener() {
        Vector addAction = new Vector();
        for (int k = 0; k < this.graphCount; ++k) {
            this.activationChange[k] = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
        }
    }
}

