/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import jams.components.gui.MapCollection;
import jams.components.io.ShapeTool;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureTypeBuilder;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.SchemaException;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.GeometryDistanceFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.gui.swing.JMapPane;
import org.geotools.gui.swing.PanAction;
import org.geotools.gui.swing.ResetAction;
import org.geotools.gui.swing.ZoomInAction;
import org.geotools.gui.swing.ZoomOutAction;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.data.JAMSStringArray;
import org.unijena.jams.model.JAMSGUIComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class MapCreator
extends JAMSGUIComponent
implements MouseListener {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Name of SLD-File containing layer style information")
    public JAMSString stylesFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="ID of a style in the SLD-File")
    public JAMSInteger styleID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Name of hru attribute to add for mapping")
    public JAMSStringArray showAttr;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Number of ranges for classification attribute")
    public JAMSStringArray numOfRanges;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Color shading the ranges")
    public JAMSStringArray rangeColor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Name of shapefile to add as a layer to the map")
    public JAMSString shapeFileName1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Name of shapefile to add as a layer to the map")
    public JAMSString shapeFileName2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Name of shapefile to add as a layer to the map")
    public JAMSString shapeFileName3;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Colors for extra shapefiles")
    public JAMSStringArray shapeColors;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Original shape file name")
    public JAMSString baseShape;
    private JPanel panel;
    private DefaultMapLayer[] optLayers = new DefaultMapLayer[3];
    private MapCollection[] mc;
    private int numOfParams;
    private int infoidx;
    private String mapFTypeName = "mapFType";
    private DefaultMutableTreeNode top;
    private DefaultMutableTreeNode last;
    private JTree tree;
    private boolean finished = false;
    private MapContext map;
    private JMapPane mp;
    private JTextPane info;
    private JSplitPane p;
    private JSplitPane splitPane;
    private JToolBar jtb;
    public JScrollPane treeView;
    private Feature selectedF = null;

    public void run() throws Exception {
        int i;
        int i2;
        if (this.shapeFileName1 == null) {
            this.shapeFileName1 = new JAMSString("");
        }
        if (this.shapeFileName2 == null) {
            this.shapeFileName2 = new JAMSString("");
        }
        if (this.shapeFileName3 == null) {
            this.shapeFileName3 = new JAMSString("");
        }
        FeatureSource fs = null;
        String[] otherLayers = new String[]{this.shapeFileName1.getValue(), this.shapeFileName2.getValue(), this.shapeFileName3.getValue()};
        for (i2 = 0; i2 <= 2; ++i2) {
            if (otherLayers[i2].equals("")) continue;
            try {
                File shpFile = new File(this.dirName.getValue() + "/" + otherLayers[i2]);
                URL shpUrl = shpFile.toURI().toURL();
                String sourcename = shpFile.getName().split("\\.")[0];
                fs = new ShapefileDataStore(shpUrl).getFeatureSource(sourcename);
            }
            catch (Exception e) {
                this.getModel().getRuntime().handle(e);
            }
            DefaultMapLayer layer = new DefaultMapLayer(fs, this.getStyle(fs, i2));
            layer.setTitle(otherLayers[i2]);
            this.optLayers[i2] = layer;
        }
        this.numOfParams = this.showAttr.getValue().length;
        this.mc = new MapCollection[this.numOfParams];
        for (i2 = 0; i2 <= this.numOfParams - 1; ++i2) {
            FeatureCollection fc = FeatureCollections.newCollection();
            GeometryAttributeType geo = (GeometryAttributeType)AttributeTypeFactory.newAttributeType((String)"geo", MultiPolygon.class);
            AttributeType newAt = AttributeTypeFactory.newAttributeType((String)"newAt", Object.class);
            FeatureTypeFactory mapFeatureType = FeatureTypeBuilder.newInstance((String)this.mapFTypeName);
            mapFeatureType.addType((AttributeType)geo);
            mapFeatureType.addType(newAt);
            DefaultFeatureType ft = null;
            try {
                ft = (DefaultFeatureType)mapFeatureType.getFeatureType();
            }
            catch (SchemaException e) {
                this.getModel().getRuntime().handle((Exception)((Object)e));
            }
            Iterator hrusIterate = this.hrus.getEntities().iterator();
            TreeSet<Double> s = new TreeSet<Double>();
            while (hrusIterate.hasNext()) {
                JAMSEntity e = (JAMSEntity)hrusIterate.next();
                Feature newFeature = ft.create(new Object[]{e.getGeometry("geom"), e.getDouble(this.showAttr.getValue()[i2])}, new Integer(new Double(e.getDouble("ID")).intValue()).toString());
                fc.add((Object)newFeature);
                s.add(e.getDouble(this.showAttr.getValue()[i2]));
            }
            this.mc[i2] = new MapCollection(this.showAttr.getValue()[i2], fc, s, this.rangeColor.getValue()[i2], Integer.parseInt(this.numOfRanges.getValue()[i2]));
            DefaultMutableTreeNode mapNode = new DefaultMutableTreeNode(this.mc[i2].getDesc());
            this.top.add(mapNode);
            Object[] nodeContent = this.mc[i2].getRanges();
            DefaultMutableTreeNode entry = null;
            for (int j = 1; j <= nodeContent.length - 1; ++j) {
                entry = new DefaultMutableTreeNode("<= " + (double)Math.round((Double)nodeContent[j] * 100000.0) / 100000.0, false);
                mapNode.add(entry);
            }
            for (int k = 0; k <= 2; ++k) {
                if (otherLayers[k].equals("")) continue;
                this.mc[i2].getMapContext().addLayer((MapLayer)this.optLayers[k]);
            }
        }
        DefaultMutableTreeNode layerEntry = null;
        for (i = 0; i <= 2; ++i) {
            if (otherLayers[i].equals("")) continue;
            layerEntry = new DefaultMutableTreeNode(this.optLayers[i].getTitle());
            this.top.add(layerEntry);
        }
        for (i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.p.setDividerLocation(0.8);
        this.finished = true;
        this.tree.setVisible(true);
        this.info.setContentType("text/html");
        this.map = new DefaultMapContext();
        this.mp.setMapArea(this.mc[0].asCollectionDataStore().getCollection().getBounds());
        this.setMap(this.mc[0]);
        this.splitPane.setRightComponent(this.p);
        this.splitPane.setLeftComponent((Component)this.mp);
        this.splitPane.setDividerLocation(0.7);
        this.panel.add((Component)this.jtb, "North");
        this.panel.repaint();
    }

    protected Feature getSelectedFeature() {
        return this.selectedF;
    }

    private void setMap(MapCollection mc) throws Exception {
        this.map = mc.getMapContext();
        this.mp.addMouseListener((MouseListener)this);
        this.mp.setContext(this.map);
        StreamingRenderer myRender = new StreamingRenderer();
        HashMap<String, Boolean> hints = new HashMap<String, Boolean>();
        hints.put("optimizedDataLoadingEnabled", Boolean.TRUE);
        myRender.setRendererHints(hints);
        this.mp.setRenderer((GTRenderer)myRender);
    }

    public Style getStyle(FeatureSource fs, int i) {
        PointSymbolizer ps = null;
        LineSymbolizer ls = null;
        PolygonSymbolizer ms = null;
        StyleBuilder sb = new StyleBuilder();
        Style style = null;
        Class geoType = fs.getSchema().getDefaultGeometry().getType();
        if (geoType.equals(LineString.class) || geoType.equals(MultiLineString.class)) {
            ls = sb.createLineSymbolizer(Color.decode("#" + this.shapeColors.getValue()[i]), 2.0);
            style = sb.createStyle((Symbolizer)ls);
        } else if (geoType.equals(Point.class) || geoType.equals(MultiPoint.class)) {
            Mark pointMarker = sb.createMark("square", Color.decode("#" + this.shapeColors.getValue()[i]));
            ps = sb.createPointSymbolizer(sb.createGraphic(null, pointMarker, null));
            style = sb.createStyle((Symbolizer)ps);
        } else if (geoType.equals(Polygon.class) || geoType.equals(MultiPolygon.class)) {
            ms = sb.createPolygonSymbolizer(Color.decode("#" + this.shapeColors.getValue()[i]));
            style = sb.createStyle((Symbolizer)ms);
        }
        return style;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mp.getState() == 4) {
            Rectangle bounds = this.mp.getBounds();
            double x = e.getX();
            double y = e.getY();
            double width = this.mp.getMapArea().getWidth();
            double height = this.mp.getMapArea().getHeight();
            double mapX = x * width / (double)bounds.width + this.mp.getMapArea().getMinX();
            double mapY = (bounds.getHeight() - y) * height / (double)bounds.height + this.mp.getMapArea().getMinY();
            int idx = this.last == null || this.last.isRoot() ? 0 : (this.last.isLeaf() ? this.top.getIndex(this.last.getParent()) : this.top.getIndex(this.last));
            GeometryDistanceFilter distWithinFilter = null;
            Feature selectedF = null;
            Coordinate c1 = new Coordinate(mapX, mapY);
            Coordinate c2 = new Coordinate(mapX + 1.0E-6, mapY + 1.0E-6);
            try {
                FilterFactoryImpl filtFact = new FilterFactoryImpl();
                distWithinFilter = filtFact.createGeometryDistanceFilter((short)24);
                Envelope bbox = new Envelope(c1, c2);
                BBoxExpression bboxExp = filtFact.createBBoxExpression(bbox);
                distWithinFilter.addRightGeometry((Expression)bboxExp);
                distWithinFilter.setDistance(2.0 / this.mp.getZoomFactor());
                distWithinFilter.addLeftGeometry((Expression)filtFact.createAttributeExpression(this.mc[idx].getCollectionType(), this.mc[idx].getCollectionType().getDefaultGeometry().getName()));
            }
            catch (IllegalFilterException e1) {
                this.info.setText("<html><b>Please select a HRU!</b></html>");
            }
            try {
                FeatureCollection filtResult = this.mc[idx].asCollectionDataStore().getFeatureSource(this.mapFTypeName).getFeatures((Filter)distWithinFilter);
                selectedF = filtResult.reader().next();
                this.info.setText("<html><b>HRU-ID: </b>" + selectedF.getID() + "<hr><b>" + this.mc[this.infoidx].getDesc() + ": </b>" + selectedF.getAttribute("newAt") + "</html>");
            }
            catch (Exception e2) {
                this.info.setText("<html><b>Please select a HRU!</b></html>");
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public JPanel getPanel() {
        try {
            this.panel = new GISPanel();
        }
        catch (Exception e) {
            this.getModel().getRuntime().handle(e);
        }
        if (this.panel == null) {
            this.panel = new JPanel();
            JTextField text = new JTextField("Available only under Windows!");
            text.setEditable(false);
            text.setBorder(null);
            this.panel.add(text);
        }
        return this.panel;
    }

    public class GISPanel
    extends JPanel {
        public GISPanel() throws Exception {
            this.setLayout(new BorderLayout());
            MapCreator.this.top = new DefaultMutableTreeNode("Map List");
            MapCreator.this.tree = new JTree(MapCreator.this.top);
            MapCreator.this.tree.setCellRenderer(new NodeRenderer());
            MapCreator.this.tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)MapCreator.this.tree.getLastSelectedPathComponent();
                    MapCreator.this.last = node;
                    int idxToTopNode = node.isLeaf() ? MapCreator.this.top.getIndex(node.getParent()) : MapCreator.this.top.getIndex(node);
                    if (e.getClickCount() == 1 & (MapCreator.this.top.isNodeChild(node) || node.isLeaf())) {
                        try {
                            MapCreator.this.setMap(MapCreator.this.mc[idxToTopNode]);
                            MapCreator.this.mp.setReset(true);
                            MapCreator.this.mp.repaint();
                            if (MapCreator.this.last == null || MapCreator.this.last.isRoot()) {
                                MapCreator.this.infoidx = 0;
                            } else if (MapCreator.this.last.isLeaf()) {
                                MapCreator.this.infoidx = MapCreator.this.top.getIndex(MapCreator.this.last.getParent());
                            } else {
                                MapCreator.this.infoidx = MapCreator.this.top.getIndex(MapCreator.this.last);
                            }
                        }
                        catch (Exception e1) {
                            MapCreator.this.getModel().getRuntime().handle(e1);
                        }
                    }
                }
            });
            MapCreator.this.info = new JTextPane();
            MapCreator.this.info.setEditable(false);
            MapCreator.this.treeView = new JScrollPane(MapCreator.this.tree);
            MapCreator.this.p = new JSplitPane(0);
            MapCreator.this.p.setTopComponent(MapCreator.this.treeView);
            MapCreator.this.p.setBottomComponent(MapCreator.this.info);
            MapCreator.this.mp = new JMapPane();
            ZoomInAction zin = new ZoomInAction(MapCreator.this.mp);
            ZoomOutAction zout = new ZoomOutAction(MapCreator.this.mp);
            PanAction pan = new PanAction(MapCreator.this.mp);
            ResetAction reset = new ResetAction(MapCreator.this.mp);
            URL url = this.getClass().getResource("resources/select.gif");
            ImageIcon iconSelect = new ImageIcon(url);
            JButton selectB = new JButton(iconSelect);
            selectB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapCreator.this.mp.setState(4);
                }
            });
            ShapeExport export = new ShapeExport();
            MapCreator.this.jtb = new JToolBar();
            MapCreator.this.jtb.add((Action)zin);
            MapCreator.this.jtb.add((Action)zout);
            MapCreator.this.jtb.add((Action)pan);
            MapCreator.this.jtb.add(selectB);
            MapCreator.this.jtb.add((Action)reset);
            MapCreator.this.jtb.add(export);
            MapCreator.this.splitPane = new JSplitPane(1);
            JPanel waitPanel = new JPanel();
            ImageIcon waiticon = new ImageIcon(MapCreator.this.getModel().getRuntime().getClassLoader().getResource("jams/components/gui/resources/wait.gif"));
            waitPanel.setLayout(new BorderLayout());
            JLabel label = new JLabel("Please wait...!", waiticon, 0);
            label.setVerticalTextPosition(3);
            label.setHorizontalTextPosition(0);
            label.setFont(new Font("Dialog", 1, 14));
            waitPanel.add(label);
            MapCreator.this.splitPane.setLeftComponent(waitPanel);
            this.add(MapCreator.this.splitPane);
        }
    }

    public class NodeRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon iconProject;
        private ImageIcon iconRange;
        private Icon blatt;
        private Icon blatt2;

        public NodeRenderer() {
            this.iconProject = new ImageIcon(MapCreator.this.getModel().getRuntime().getClassLoader().getResource("jams/components/gui/resources/root.png"));
            this.iconRange = new ImageIcon(MapCreator.this.getModel().getRuntime().getClassLoader().getResource("jams/components/gui/resources/map.png"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            DefaultMutableTreeNode parentnode = (DefaultMutableTreeNode)node.getParent();
            int idxToParentNode = 0;
            int idxToTopNode = 0;
            if (!node.isRoot()) {
                idxToParentNode = parentnode.getIndex(node);
                idxToTopNode = MapCreator.this.top.getIndex(parentnode);
            }
            if (node.isRoot()) {
                this.setIcon(this.iconProject);
            }
            if (!leaf && !node.isRoot()) {
                this.setIcon(this.iconRange);
            }
            if (leaf && node.getParent() == MapCreator.this.top) {
                this.blatt2 = new MyLayerIcon(MapCreator.this.top.getIndex(node));
                this.setIcon(this.blatt2);
            } else if (leaf) {
                this.blatt = new MyIcon(idxToTopNode, idxToParentNode);
                this.setIcon(this.blatt);
            }
            return this;
        }
    }

    class MyIcon
    implements Icon {
        private Integer a;
        private Integer b;

        public MyIcon(Integer a, Integer b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (MapCreator.this.finished) {
                g.drawRect(1, 1, 19, 14);
                g.setColor(Color.BLACK);
                g.setColor((Color)MapCreator.this.mc[this.a].getColors()[MapCreator.this.mc[this.a].getRanges().length - this.b - 1]);
                g.fillRect(1, 1, 19, 14);
            } else {
                MapCreator.this.tree.setVisible(false);
            }
        }

        @Override
        public int getIconWidth() {
            return 30;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }
    }

    class MyLayerIcon
    implements Icon {
        private int idx;

        public MyLayerIcon(Integer idx) {
            this.idx = idx - MapCreator.this.numOfParams;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.BLACK);
            g2d.drawRoundRect(0, 0, 20, 13, 5, 5);
            Class geoType = MapCreator.this.optLayers[this.idx].getFeatureSource().getSchema().getDefaultGeometry().getType();
            g2d.setColor(Color.decode("#" + MapCreator.this.shapeColors.getValue()[this.idx]));
            if (geoType.equals(LineString.class) || geoType.equals(MultiLineString.class)) {
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawLine(4, 4, 13, 6);
                g2d.drawLine(13, 6, 15, 9);
            } else if (geoType.equals(Point.class) || geoType.equals(MultiPoint.class)) {
                g2d.fillRect(4, 4, 4, 4);
                g2d.fillRect(13, 6, 4, 4);
            } else if (geoType.equals(Polygon.class) || geoType.equals(MultiPolygon.class)) {
                int[] xPoints = new int[]{2, 5, 9, 17};
                int[] yPoints = new int[]{3, 10, 12, 2};
                g2d.fillPolygon(xPoints, yPoints, 4);
            }
        }

        @Override
        public int getIconWidth() {
            return 30;
        }

        @Override
        public int getIconHeight() {
            return 13;
        }
    }

    class ShapeExport
    extends AbstractAction {
        private ImageIcon icon;

        public ShapeExport() {
            this.putValue("ShortDescription", "Export actual map to ESRI shape format");
            URL url = this.getClass().getResource("resources/export.gif");
            this.icon = new ImageIcon(url);
            this.putValue("SmallIcon", this.icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int idx = MapCreator.this.last == null || MapCreator.this.last.isRoot() ? 0 : (MapCreator.this.last.isLeaf() ? MapCreator.this.top.getIndex(MapCreator.this.last.getParent()) : MapCreator.this.top.getIndex(MapCreator.this.last));
                ShapeTool expPanel = new ShapeTool(MapCreator.this.mc[idx].asCollectionDataStore(), MapCreator.this.baseShape, MapCreator.this.mc[idx].getDesc(), MapCreator.this.p, MapCreator.this.treeView);
                MapCreator.this.p.setTopComponent(expPanel);
                MapCreator.this.p.setDividerLocation(0.8);
            }
            catch (Exception e1) {
                MapCreator.this.getModel().getRuntime().handle(e1);
            }
        }
    }
}

