/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.gui.input;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.unijena.jams.gui.input.InputComponent;

public class FloatInput
extends JPanel
implements InputComponent {
    private static final long serialVersionUID = 2424203601132061595L;
    JTextField text = new JTextField();

    public FloatInput() {
        this.setRange(-1.7976931348623157E308, Double.MAX_VALUE);
        this.setLayout(new BorderLayout());
        this.add((Component)this.text, "West");
    }

    @Override
    public String getValue() {
        return this.text.getText();
    }

    @Override
    public void setValue(String value) {
        this.text.setText(value);
    }

    @Override
    public JComponent getComponent() {
        return this.text;
    }

    @Override
    public void setRange(double lower, double upper) {
        this.setInputVerifier(new NumericIntervalVerifier(lower, upper));
    }

    @Override
    public boolean verify() {
        return this.getInputVerifier().verify(this.text);
    }

    @Override
    public int getErrorCode() {
        return ((NumericIntervalVerifier)this.getInputVerifier()).result;
    }

    class NumericIntervalVerifier
    extends InputVerifier {
        double lower;
        double upper;
        int result;

        public NumericIntervalVerifier(double lower, double upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public boolean verify(JComponent input) {
            try {
                double value = Double.parseDouble(((JTextField)input).getText());
                if (value >= this.lower && value <= this.upper) {
                    this.result = 0;
                    return true;
                }
                this.result = -2;
                return false;
            }
            catch (NumberFormatException nfe) {
                this.result = -1;
                return false;
            }
        }
    }
}

