/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.concurrent.ExecutionException;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class WorkerDlg
extends JDialog {
    private Runnable task;
    private SwingWorker worker;
    private Frame owner;

    public WorkerDlg(Frame owner, String title) {
        this(owner, title, "");
    }

    public WorkerDlg(Frame owner, String title, String message) {
        super(owner);
        this.owner = owner;
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.setTitle(title);
        this.setLocationRelativeTo(owner);
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        if (!message.equals("")) {
            JLabel label = new JLabel(message);
            this.add((Component)label, "North");
        }
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        progressBar.setPreferredSize(new Dimension(300, 20));
        this.add((Component)progressBar, "Center");
        this.pack();
    }

    public void execute() {
        this.worker.execute();
        Dimension ownerDim = this.owner.getSize();
        Dimension thisDim = this.getSize();
        int x = this.owner.getX() + (ownerDim.width - thisDim.width) / 2;
        int y = this.owner.getY() + (ownerDim.height - thisDim.height) / 2;
        this.setLocation(x, y);
        this.setVisible(true);
        try {
            this.worker.get();
        }
        catch (InterruptedException ie) {
        }
        catch (ExecutionException ee) {
            // empty catch block
        }
    }

    public void setTask(Runnable task) {
        this.task = task;
        this.worker = new SwingWorker<Object, Void>(){

            @Override
            public Object doInBackground() {
                WorkerDlg.this.task.run();
                return null;
            }

            @Override
            public void done() {
                WorkerDlg.this.setVisible(false);
            }
        };
    }
}

