/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.nio.ByteBuffer;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.renderer.shape.ScreenMap;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class GeometryHandlerUtilities {
    public static Envelope readBounds(ByteBuffer buffer) {
        double[] tmpbbox = new double[]{buffer.getDouble(), buffer.getDouble(), buffer.getDouble(), buffer.getDouble()};
        Envelope geomBBox = new Envelope(tmpbbox[0], tmpbbox[2], tmpbbox[1], tmpbbox[3]);
        return geomBBox;
    }

    public static void transform(ShapeType type, MathTransform mt, double[] src, double[] dest) throws TransformException {
        boolean startPointTransformed = true;
        int length = dest.length;
        for (int i = 0; i < length; i += 2) {
            try {
                mt.transform(src, i, dest, i, 1);
                if (startPointTransformed) continue;
                startPointTransformed = true;
                for (int j = 0; j < i; j += 2) {
                    dest[j] = src[i];
                    dest[j + 1] = src[i + 1];
                }
                continue;
            }
            catch (TransformException e) {
                if (i == 0) {
                    startPointTransformed = false;
                    continue;
                }
                if (!startPointTransformed) continue;
                if (i == length - 2 && (type == ShapeType.POLYGON || type == ShapeType.POLYGONZ || type == ShapeType.POLYGONM)) {
                    dest[i] = dest[0];
                    dest[i + 1] = dest[1];
                    continue;
                }
                dest[i] = dest[i - 2];
                dest[i + 1] = dest[i - 1];
            }
        }
        if (!startPointTransformed) {
            throw new TransformException("Unable to transform any of the points in the shape");
        }
    }

    public static Point2D calculateSpan(MathTransform mt, int x, int y) throws NoninvertibleTransformException, TransformException {
        MathTransform screenToWorld = mt.inverse();
        double[] original = new double[]{(double)x - 0.5, (double)y - 0.5, (double)x + 0.5, (double)y + 0.5};
        double[] coords = new double[4];
        screenToWorld.transform(original, 0, coords, 0, 2);
        Point2D.Double span = new Point2D.Double(Math.abs(coords[0] - coords[2]), Math.abs(coords[1] - coords[3]));
        return span;
    }

    public static ScreenMap calculateScreenSize(Rectangle screenSize, boolean hasOpacity) throws TransformException, NoninvertibleTransformException {
        if (hasOpacity) {
            return new ScreenMap(0, 0, 0, 0){

                public boolean get(int x, int y) {
                    return false;
                }

                public void set(int x, int y, boolean value) {
                }
            };
        }
        return new ScreenMap(screenSize.x, screenSize.y, screenSize.width + 1, screenSize.height + 1);
    }
}

