/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Iterator;
import java.util.Map;
import org.geotools.factory.Hints;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.operation.AbstractCoordinateOperationFactory;
import org.geotools.resources.Utilities;
import org.geotools.util.SoftValueHashMap;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;

public class BufferedCoordinateOperationFactory
extends AbstractCoordinateOperationFactory {
    static final int PRIORITY = 70;
    private CoordinateOperationFactory factory;
    private final Map pool = new SoftValueHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public BufferedCoordinateOperationFactory() {
        super(null, 70);
    }

    public BufferedCoordinateOperationFactory(Hints hints) {
        this(hints, 70);
    }

    public BufferedCoordinateOperationFactory(Hints hints, int priority) {
        this(BufferedCoordinateOperationFactory.getBackingFactory(hints), hints, priority);
    }

    public BufferedCoordinateOperationFactory(CoordinateOperationFactory factory, int priority) {
        this(factory, null, priority);
    }

    private BufferedCoordinateOperationFactory(CoordinateOperationFactory factory, Hints hints, int priority) {
        super(factory, hints, priority);
        this.factory = factory;
        BufferedCoordinateOperationFactory.ensureNonNull("factory", factory);
    }

    private static CoordinateOperationFactory getBackingFactory(Hints hints) {
        Iterator it = FactoryFinder.getCoordinateOperationFactories(hints).iterator();
        while (it.hasNext()) {
            CoordinateOperationFactory candidate = (CoordinateOperationFactory)it.next();
            if (candidate instanceof BufferedCoordinateOperationFactory) continue;
            return candidate;
        }
        return FactoryFinder.getCoordinateOperationFactory(hints);
    }

    private final CoordinateOperationFactory getBackingFactory() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.hints)) {
            throw new AssertionError();
        }
        if (this.factory == null) {
            this.factory = BufferedCoordinateOperationFactory.getBackingFactory(null);
        }
        return this.factory;
    }

    void initializeHints() {
        super.initializeHints();
        this.hints.put(Hints.COORDINATE_OPERATION_FACTORY, this.getBackingFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws OperationNotFoundException, FactoryException {
        CoordinateOperation op;
        CRSPair key = new CRSPair(sourceCRS, targetCRS);
        Map map = this.hints;
        synchronized (map) {
            op = (CoordinateOperation)this.pool.get(key);
            if (op == null) {
                op = this.getBackingFactory().createOperation(sourceCRS, targetCRS);
                this.pool.put(key, op);
            }
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, OperationMethod method) throws OperationNotFoundException, FactoryException {
        Map map = this.hints;
        synchronized (map) {
            return this.getBackingFactory().createOperation(sourceCRS, targetCRS, method);
        }
    }

    static {
        $assertionsDisabled = !BufferedCoordinateOperationFactory.class.desiredAssertionStatus();
    }

    private static final class CRSPair {
        private final int hash;
        private final CoordinateReferenceSystem sourceCRS;
        private final CoordinateReferenceSystem targetCRS;

        public CRSPair(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
            this.sourceCRS = sourceCRS;
            this.targetCRS = targetCRS;
            this.hash = 37 * sourceCRS.hashCode() + targetCRS.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CRSPair) {
                CRSPair that = (CRSPair)object;
                return Utilities.equals(this.sourceCRS, that.sourceCRS) && Utilities.equals(this.targetCRS, that.targetCRS);
            }
            return false;
        }
    }
}

