/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.awt.geom.Point2D;
import java.io.Serializable;
import org.geotools.measure.CoordinateFormat;
import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class GeneralDirectPosition
implements DirectPosition,
Serializable {
    private static final long serialVersionUID = 9071833698385715524L;
    private static CoordinateFormat format;
    public final double[] ordinates;
    private CoordinateReferenceSystem crs;

    public GeneralDirectPosition(CoordinateReferenceSystem crs) {
        this(crs.getCoordinateSystem().getDimension());
        this.crs = crs;
    }

    public GeneralDirectPosition(int numDim) throws NegativeArraySizeException {
        this.ordinates = new double[numDim];
    }

    public GeneralDirectPosition(double[] ordinates) {
        this.ordinates = (double[])ordinates.clone();
    }

    public GeneralDirectPosition(double x, double y) {
        this.ordinates = new double[]{x, y};
    }

    public GeneralDirectPosition(double x, double y, double z) {
        this.ordinates = new double[]{x, y, z};
    }

    public GeneralDirectPosition(Point2D point) {
        this(point.getX(), point.getY());
    }

    public GeneralDirectPosition(DirectPosition point) {
        this.ordinates = point.getCoordinates();
        this.crs = point.getCoordinateReferenceSystem();
    }

    public DirectPosition getPosition() {
        return this;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        GeneralDirectPosition.checkCoordinateReferenceSystemDimension(crs, this.getDimension());
        this.crs = crs;
    }

    static void checkCoordinateReferenceSystemDimension(CoordinateReferenceSystem crs, int expected) throws MismatchedDimensionException {
        int dimension;
        if (crs != null && (dimension = crs.getCoordinateSystem().getDimension()) != expected) {
            throw new MismatchedDimensionException(Errors.format(69, crs.getName().getCode(), new Integer(dimension), new Integer(expected)));
        }
    }

    static void ensureDimensionMatch(String name, int dimension, int expectedDimension) throws MismatchedDimensionException {
        if (dimension != expectedDimension) {
            throw new MismatchedDimensionException(Errors.format(69, name, new Integer(dimension), new Integer(expectedDimension)));
        }
    }

    public final int getDimension() {
        return this.ordinates.length;
    }

    public final double[] getCoordinates() {
        return (double[])this.ordinates.clone();
    }

    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        return this.ordinates[dimension];
    }

    public final void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        this.ordinates[dimension] = value;
    }

    public final void setLocation(DirectPosition position) throws MismatchedDimensionException {
        GeneralDirectPosition.ensureDimensionMatch("position", position.getDimension(), this.ordinates.length);
        this.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
        for (int i = 0; i < this.ordinates.length; ++i) {
            this.ordinates[i] = position.getOrdinate(i);
        }
    }

    public final void setLocation(GeneralDirectPosition position) throws MismatchedDimensionException {
        GeneralDirectPosition.ensureDimensionMatch("position", position.ordinates.length, this.ordinates.length);
        this.setCoordinateReferenceSystem(position.crs);
        System.arraycopy(position.ordinates, 0, this.ordinates, 0, this.ordinates.length);
    }

    public final void setLocation(Point2D point) throws MismatchedDimensionException {
        if (this.ordinates.length != 2) {
            throw new MismatchedDimensionException(Errors.format(93, new Integer(this.ordinates.length)));
        }
        this.ordinates[0] = point.getX();
        this.ordinates[1] = point.getY();
    }

    public Point2D toPoint2D() throws IllegalStateException {
        if (this.ordinates.length != 2) {
            throw new IllegalStateException(Errors.format(93, new Integer(this.ordinates.length)));
        }
        return new Point2D.Double(this.ordinates[0], this.ordinates[1]);
    }

    public String toString() {
        return GeneralDirectPosition.toString(this);
    }

    public static synchronized String toString(DirectPosition position) {
        if (format == null) {
            format = new CoordinateFormat();
        }
        format.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
        return format.format(position);
    }

    public int hashCode() {
        int code = GeneralDirectPosition.hashCode(this.ordinates);
        if (this.crs != null) {
            code ^= this.crs.hashCode();
        }
        return code;
    }

    static int hashCode(double[] ordinates) {
        long code = 498262340L;
        if (ordinates != null) {
            int i = ordinates.length;
            while (--i >= 0) {
                code = code * 31L + Double.doubleToLongBits(ordinates[i]);
            }
        }
        return (int)(code >>> 32) ^ (int)code;
    }

    public Object clone() {
        return new GeneralDirectPosition(this.ordinates);
    }
}

