/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import com.vividsolutions.jts.geom.Geometry;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.filter.ExpressionDOMParser;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SLDInlineFeatureParser {
    private static Hashtable SRSLookup = new Hashtable();
    public FeatureType featureType = null;
    public MemoryDataStore dataStore = null;
    Node rootNode = null;
    ArrayList features = new ArrayList();
    CoordinateReferenceSystem SRS = null;
    private static int uniqueNumber = 0;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;
    static /* synthetic */ Class class$java$lang$String;

    public SLDInlineFeatureParser(Node root) throws Exception {
        boolean isFeatureCollection = false;
        if (!this.isSimple(root)) {
            throw new Exception("couldnt parse the SLD Inline features!");
        }
        Node fc = this.getNode(root, "FeatureCollection");
        if (fc != null) {
            isFeatureCollection = true;
            root = fc;
        }
        this.featureType = this.makeFeatureType(root, isFeatureCollection);
        if (this.featureType == null) {
            throw new Exception("SLD InlineFeature Parser - couldnt determine a FeatureType.  See help for whats supported.");
        }
        this.makeFeatures(root, isFeatureCollection);
        if (this.features.size() == 0) {
            throw new Exception("SLD InlineFeature Parser - didnt find any features!");
        }
        this.buildStore();
    }

    private void makeFeatures(Node root, boolean isCollection) throws Exception {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("boundedBy")) continue;
            if (isCollection) {
                child = this.descend(child);
            }
            if (child == null) {
                throw new Exception("SLD inlineFeature Parser - couldnt extract a feature from the dom.");
            }
            Feature f = this.parseFeature(child, this.featureType);
            this.features.add(f);
        }
    }

    private Node descend(Node root) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            return child;
        }
        return null;
    }

    private Feature parseFeature(Node feature, FeatureType featureType) throws Exception {
        Object[] nullAtts = new Object[featureType.getAttributeCount()];
        Feature f = featureType.create(nullAtts);
        NodeList children = feature.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            Object value = this.getValue(child);
            try {
                f.setAttribute(childName, value);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return f;
    }

    private Object getValue(Node root) {
        NodeList children = root.getChildNodes();
        StringBuffer strVal = new StringBuffer();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null) continue;
            if (child.getNodeType() == 3) {
                strVal.append(child.getNodeValue());
            }
            if (child.getNodeType() != 1) continue;
            return this.parseGeometry(child);
        }
        return strVal;
    }

    private Geometry parseGeometry(Node root) {
        Node srsName;
        NamedNodeMap atts = root.getAttributes();
        if (this.SRS == null && (srsName = atts.getNamedItem("srsName")) != null) {
            this.parseSRS(srsName.getNodeValue());
        }
        return ExpressionDOMParser.parseGML(root);
    }

    private void parseSRS(String srs) {
        if (srs == null) {
            return;
        }
        String epsgCode = srs.substring(srs.indexOf(35) + 1);
        try {
            int srsnum = Integer.parseInt(epsgCode);
            this.SRS = this.getSRS(srsnum);
        }
        catch (Exception e) {
            System.out.println("couldnt decode SRS - EPSG:" + epsgCode + ". currently only supporting EPSG #");
        }
    }

    private boolean isSimple(Node root) throws Exception {
        String childName;
        Node child;
        int i;
        int foundFeature = 0;
        int foundFC = 0;
        Node fcNode = null;
        String featureName = null;
        NodeList children = root.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("FeatureCollection")) {
                ++foundFC;
                fcNode = child;
                continue;
            }
            if (featureName == null) {
                featureName = childName;
            }
            if (childName.equalsIgnoreCase(featureName)) continue;
            throw new Exception("SLD inline feature parser  - it appear that there is >1 feature type present.  I got a " + childName + " when I was expecting a " + featureName + " tag");
        }
        if (foundFC > 1) {
            throw new Exception("SLD - UserLayer, inline feature parser - found >1 FeatureCollection.  Not supported");
        }
        if (foundFC > 0 && foundFeature > 0) {
            throw new Exception("SLD - UserLayer, inline feature parser - found  FeatureCollection and featureMembers.  Not supported");
        }
        if (foundFC == 0) {
            return true;
        }
        featureName = null;
        children = fcNode.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("featureMember")) {
                ++foundFeature;
                continue;
            }
            if (childName.equalsIgnoreCase("boundedBy")) continue;
            if (childName.equalsIgnoreCase("FeatureCollection")) {
                throw new Exception("SLD - UserLayer, inline feature parser - found a node of type FeatureCollection.  Expected a featureMember - dont support nested collections.");
            }
            throw new Exception("SLD - UserLayer, inline feature parser - found a node of type '" + child.getLocalName() + "' and dont understand it.  Expected a featureMember.");
        }
        return true;
    }

    private void buildStore() {
        this.dataStore = new MemoryDataStore(this.features.toArray(new Feature[this.features.size()]));
    }

    private FeatureType makeFeatureType(Node root, boolean isCollection) throws Exception {
        Node feature = null;
        Node featureMember = root;
        if (isCollection) {
            featureMember = this.getNode(root, "featureMember");
        }
        NodeList children = featureMember.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("boundedBy")) continue;
            feature = child;
            break;
        }
        if (feature == null) {
            throw new Exception("couldnt find a Feature in the Inline Features!");
        }
        String featureName = feature.getLocalName();
        if (featureName == null) {
            featureName = feature.getNodeName();
        }
        FeatureTypeFactory build = FeatureTypeFactory.newInstance(featureName);
        build.setName(featureName);
        build.setNamespace(new URI("http://temp.inline.feature.sld.com"));
        children = feature.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            AttributeType attType = null;
            attType = this.isGeometry(child) ? AttributeTypeFactory.newAttributeType(childName, class$com$vividsolutions$jts$geom$Geometry == null ? SLDInlineFeatureParser.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry) : AttributeTypeFactory.newAttributeType(childName, class$java$lang$String == null ? SLDInlineFeatureParser.class$("java.lang.String") : class$java$lang$String);
            build.addType(attType);
        }
        return build.getFeatureType();
    }

    private boolean isGeometry(Node root) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public Node getNode(Node parentNode, String wantedChildName) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (!childName.equalsIgnoreCase(wantedChildName)) continue;
            return child;
        }
        return null;
    }

    public synchronized int getUID() {
        return uniqueNumber++;
    }

    private CoordinateReferenceSystem getSRS(int epsg) throws Exception {
        CoordinateReferenceSystem result = (CoordinateReferenceSystem)SRSLookup.get(new Integer(epsg));
        if (result == null) {
            result = CRS.decode((String)("EPSG:" + epsg));
            SRSLookup.put(new Integer(epsg), result);
        }
        return result;
    }
}

