/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.Expression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.ExplicitClassificationFunction;
import org.geotools.util.NullProgressListener;

public class UniqueIntervalFunction
extends ExplicitClassificationFunction {
    Object unique = null;
    Set[] values = null;
    boolean isValid = false;

    public String getName() {
        return "UniqueInterval";
    }

    private void calculateValues() throws IllegalFilterException, IOException {
        UniqueVisitor uniqueVisit = new UniqueVisitor(this.expr);
        if (this.progress == null) {
            this.progress = new NullProgressListener();
        }
        this.fc.accepts((FeatureVisitor)uniqueVisit, this.progress);
        if (this.progress.isCanceled()) {
            return;
        }
        CalcResult calcResult = uniqueVisit.getResult();
        if (calcResult == null) {
            return;
        }
        List result = calcResult.toList();
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1 instanceof String && o2 instanceof String) {
                    return ((String)o1).compareTo((String)o2);
                }
                return 0;
            }
        });
        Object[] results = result.toArray();
        if (this.classNum < results.length) {
            this.values = new Set[this.classNum];
            int binPop = new Double(Math.ceil((double)results.length / (double)this.classNum)).intValue();
            int lastBigBin = results.length % this.classNum;
            lastBigBin = lastBigBin == 0 ? this.classNum : --lastBigBin;
            int itemIndex = 0;
            for (int binIndex = 0; binIndex < this.classNum; ++binIndex) {
                HashSet<Object> val = new HashSet<Object>();
                for (int binItem = 0; binItem < binPop; ++binItem) {
                    val.add(results[itemIndex++]);
                }
                if (lastBigBin == binIndex) {
                    --binPop;
                }
                this.values[binIndex] = val;
            }
        } else {
            if (this.classNum > results.length) {
                this.classNum = results.length;
            }
            this.values = new Set[this.classNum];
            for (int i = 0; i < this.classNum; ++i) {
                HashSet<Object> val = new HashSet<Object>();
                val.add(results[i]);
                this.values[i] = val;
            }
        }
        this.unique = result;
        this.isValid = true;
    }

    private int calculateSlot(Object val) {
        if (val == null) {
            return -1;
        }
        if (this.isValid) {
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].contains(val)) continue;
                return i;
            }
        }
        return -1;
    }

    public Object evaluate(Feature feature) {
        FeatureCollection fcNew = feature instanceof FeatureCollection ? (FeatureCollection)feature : feature.getParent();
        if (fcNew == null) {
            return new Integer(0);
        }
        if (!fcNew.equals(this.fc) || !this.isValid) {
            this.fc = fcNew;
            try {
                this.calculateValues();
            }
            catch (IllegalFilterException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int slot = this.calculateSlot(this.expr.getValue(feature));
        return new Integer(slot);
    }

    public void setExpression(Expression e) {
        super.setExpression(e);
        if (this.fc != null) {
            try {
                this.calculateValues();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public Object getValue(int index) {
        if (this.fc == null) {
            return null;
        }
        if (this.unique == null) {
            try {
                this.calculateValues();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.values[index];
    }
}

