/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.soilWater;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="InitJ2KProcessLayeredSoilWaterStates", author="Peter Krause", description="Calculates soil water balance for each HRU without vertical layers")
public class InitJ2KProcessLayeredSoilWaterStates
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The hru entities")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute area")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="field capacity adaptation factor")
    public JAMSDouble FCAdaptation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="air capacity adaptation factor")
    public JAMSDouble ACAdaptation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar rooting depth")
    public JAMSDouble rootDepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="number of horizons")
    public JAMSDouble horizons;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="soil horizon depths")
    public JAMSDoubleArray depth_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute maximum MPS")
    public JAMSDoubleArray maxMPS_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute maximum LPS")
    public JAMSDoubleArray maxLPS_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var actual MPS")
    public JAMSDoubleArray actMPS_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var actual LPS")
    public JAMSDoubleArray actLPS_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var saturation of MPS")
    public JAMSDoubleArray satMPS_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var saturation of LPS")
    public JAMSDoubleArray satLPS_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var saturation of whole soil")
    public JAMSDouble satSoil_h;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="RD2 inflow")
    public JAMSDoubleArray inRD2_h = new JAMSDoubleArray();

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double rootDepth;
        JAMSEntity entity = this.entities.getCurrent();
        int horizons = (int)this.horizons.getValue();
        double remRD = rootDepth = this.rootDepth.getValue() * 10.0;
        double[] mxMPS = new double[horizons];
        double[] mxLPS = new double[horizons];
        double[] acMPS = new double[horizons];
        double[] acLPS = new double[horizons];
        double[] stMPS = new double[horizons];
        double[] stLPS = new double[horizons];
        double[] inRD2 = new double[horizons];
        double[] depth = new double[horizons];
        String aNameFC = "fieldcapacity_h";
        String aNameAC = "aircapacity_h";
        String depthName = "depth_h";
        for (int h = 0; h < horizons; ++h) {
            depth[h] = entity.getDouble(depthName + h);
            acMPS[h] = 0.0;
            mxMPS[h] = entity.getDouble(aNameFC + h) * this.area.getValue() * this.FCAdaptation.getValue();
            mxLPS[h] = entity.getDouble(aNameAC + h) * this.area.getValue() * this.ACAdaptation.getValue();
            acLPS[h] = 0.0;
            stMPS[h] = 0.0;
            stLPS[h] = 0.0;
            inRD2[h] = 0.0;
        }
        this.maxMPS_h.setValue(mxMPS);
        this.maxLPS_h.setValue(mxLPS);
        this.actMPS_h.setValue(acMPS);
        this.actLPS_h.setValue(acLPS);
        this.satMPS_h.setValue(stMPS);
        this.satLPS_h.setValue(stLPS);
        this.inRD2_h.setValue(inRD2);
        this.depth_h.setValue(depth);
        this.satSoil_h.setValue(0.0);
    }

    public void cleanup() {
    }
}

