/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import org.unijena.j2k.geographicalCalculations.CalcSlopeAspectCorrectionFactor;
import org.unijena.j2k.geographicalCalculations.GKConversion;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="CalcAdditionalHRUAttribs", author="Peter Krause", description="Calculates additional attributes from existent ones")
public class CalcAdditionalHRUAttribs
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="The current hru entity")
    public JAMSEntity entity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="attribute x-coordinate")
    public JAMSDouble x;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="attribute y-coordinate")
    public JAMSDouble y;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="attribute slope")
    public JAMSDouble slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="attribute aspect")
    public JAMSDouble aspect;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="attribute latidute")
    public JAMSDouble latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="attribute longitude")
    public JAMSDouble longitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.INIT, description="attribute slopeAspectCorrection factor")
    public JAMSDouble slAsCf;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="temporal resolution [d | h | m]")
    public JAMSString tempRes;
    int[] monthMean = new int[]{15, 45, 74, 105, 135, 166, 196, 227, 258, 288, 319, 349};

    public void init() throws JAMSEntity.NoSuchAttributeException {
        double[] latLong = new double[2];
        latLong = GKConversion.GK2LatLon(this.x.getValue(), this.y.getValue());
        this.latitude.setValue(latLong[0]);
        this.longitude.setValue(latLong[1]);
        this.getModel().getRuntime().println("slope:" + this.slope.getValue());
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        int julDay = 0;
        if (this.tempRes == null || this.tempRes.equals((Object)"d") || this.tempRes.equals((Object)"h")) {
            julDay = this.time.get(6);
        } else if (this.tempRes.equals((Object)"m")) {
            int month = this.time.get(2);
            julDay = this.monthMean[month];
        }
        double sloAspCorr = CalcSlopeAspectCorrectionFactor.calc_slopeAspectCorrectionFactor(julDay, this.latitude.getValue(), this.slope.getValue(), this.aspect.getValue());
        this.slAsCf.setValue(sloAspCorr);
    }

    public void cleanup() {
    }
}

