/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DisjointSet
extends AbstractSet
implements Serializable {
    private static final long serialVersionUID = -7933552571588598563L;
    private final Map map;
    private final DisjointSet trash;

    public DisjointSet() {
        this(false);
    }

    public DisjointSet(boolean hasTrash) {
        this.map = new LinkedHashMap();
        this.trash = hasTrash ? new DisjointSet(this.map) : null;
    }

    public DisjointSet(DisjointSet disjointSet) {
        this.map = disjointSet.map;
        this.trash = disjointSet.trash;
    }

    private DisjointSet(Map map) {
        this.map = map;
        this.trash = null;
    }

    public Set getTrash() {
        return this.trash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map map = this.map;
        synchronized (map) {
            int count = 0;
            Iterator it = this.map.values().iterator();
            while (it.hasNext()) {
                if (it.next() != this) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object element) {
        Map map = this.map;
        synchronized (map) {
            return this.map.get(element) == this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object element) {
        Map map = this.map;
        synchronized (map) {
            return this.map.put(element, this) != this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object element) {
        Map map = this.map;
        synchronized (map) {
            if (this.map.get(element) != this) {
                return false;
            }
            if (this.trash != null) {
                return this.map.put(element, this.trash) != this.trash;
            }
            return this.map.remove(element) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection c) {
        Map map = this.map;
        synchronized (map) {
            return super.containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c) {
        Map map = this.map;
        synchronized (map) {
            return super.addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection c) {
        Map map = this.map;
        synchronized (map) {
            return super.removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection c) {
        Map map = this.map;
        synchronized (map) {
            return super.retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.map;
        synchronized (map) {
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        Map map = this.map;
        synchronized (map) {
            return new Iter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        Map map = this.map;
        synchronized (map) {
            return super.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        Map map = this.map;
        synchronized (map) {
            return super.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map map = this.map;
        synchronized (map) {
            return super.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Map map = this.map;
        synchronized (map) {
            return super.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object set) {
        Map map = this.map;
        synchronized (map) {
            return super.equals(set);
        }
    }

    private final class Iter
    implements Iterator {
        private final Iterator iterator;
        private Map.Entry prefetch;
        private Map.Entry toRemove;

        private Iter() {
            this.iterator = DisjointSet.this.map.entrySet().iterator();
        }

        private Map.Entry prefetch() {
            this.toRemove = null;
            if (this.prefetch == null) {
                while (this.iterator.hasNext()) {
                    Map.Entry next = (Map.Entry)this.iterator.next();
                    if (next.getValue() != DisjointSet.this) continue;
                    this.prefetch = next;
                    break;
                }
            }
            return this.prefetch;
        }

        public boolean hasNext() {
            return this.prefetch() != null;
        }

        public Object next() {
            this.toRemove = this.prefetch();
            this.prefetch = null;
            if (this.toRemove != null) {
                return this.toRemove.getKey();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.toRemove != null) {
                if (DisjointSet.this.trash != null) {
                    this.toRemove.setValue(DisjointSet.this.trash);
                } else {
                    this.iterator.remove();
                }
            } else {
                throw new IllegalStateException();
            }
            this.toRemove = null;
        }
    }
}

