/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.J3DGraphics2D;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.MasterControl;
import javax.media.j3d.VirtualUniverse;

final class J3DGraphics2DImpl
extends J3DGraphics2D {
    private boolean hasBeenDisposed = false;
    private Graphics2D offScreenGraphics2D;
    private BufferedImage g3dImage = null;
    private byte[] data = null;
    private boolean isFlushed = true;
    private Canvas3D canvas3d;
    private int width;
    private int height;
    private int texWidth;
    private int texHeight;
    private int xmin;
    private int ymin;
    private int xmax;
    private int ymax;
    private Object extentLock = new Object();
    private boolean abgr;
    private boolean initTexMap = false;
    private boolean strokeSet = false;
    private Point2D.Float ptSrc = new Point2D.Float();
    private Point2D.Float ptDst1 = new Point2D.Float();
    private Point2D.Float ptDst2 = new Point2D.Float();
    private Color xOrModeColor = null;
    private volatile boolean initCtx = false;
    private volatile boolean threadWaiting = false;
    static final Color blackTransparent = new Color(0, 0, 0, 0);
    int objectId = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    J3DGraphics2DImpl(Canvas3D canvas3D) {
        this.canvas3d = canvas3D;
        Object object = VirtualUniverse.mc.contextCreationLock;
        synchronized (object) {
            if (canvas3D.ctx == null) {
                this.width = 1;
                this.height = 1;
                this.g3dImage = new BufferedImage(this.width, this.height, 2);
                this.offScreenGraphics2D = this.g3dImage.createGraphics();
            } else {
                this.init();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        if (!this.initCtx) {
            this.abgr = (this.canvas3d.extensionsSupported & 2) != 0;
            this.width = this.canvas3d.getWidth();
            this.height = this.canvas3d.getHeight();
            this.initTexMap = false;
            if (this.width <= 0) {
                this.width = 1;
            }
            if (this.height <= 0) {
                this.height = 1;
            }
            Object object = this.extentLock;
            synchronized (object) {
                this.xmax = this.width;
                this.ymax = this.height;
                this.xmin = 0;
                this.ymin = 0;
            }
            this.g3dImage = new BufferedImage(this.width, this.height, this.abgr ? 6 : 2);
            this.offScreenGraphics2D = this.g3dImage.createGraphics();
            this.clearOffScreen();
            if (!this.abgr) {
                this.data = new byte[this.width * this.height * 4];
            }
            this.initCtx = true;
        }
    }

    public void flush(boolean bl) {
        if (this.hasBeenDisposed) {
            throw new IllegalStateException(J3dI18N.getString("J3DGraphics2D0"));
        }
        if (!this.isFlushed) {
            if (Thread.currentThread() == this.canvas3d.screen.renderer) {
                if (!this.initCtx) {
                    return;
                }
                this.doFlush();
            } else {
                if (!this.initCtx) {
                    if (bl && this.canvas3d.pendingView != null && this.canvas3d.pendingView.activeStatus) {
                        while (!this.initCtx) {
                            MasterControl.threadYield();
                        }
                    } else {
                        return;
                    }
                }
                boolean bl2 = Thread.currentThread() != this.canvas3d.view.universe.behaviorScheduler;
                this.threadWaiting = true;
                this.sendRenderMessage(bl2, 23, null, null, null);
                if (bl) {
                    this.runMonitor(0);
                }
            }
            this.isFlushed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doFlush() {
        assert (!this.hasBeenDisposed);
        if (this.canvas3d.ctx == null) {
            this.canvas3d.getGraphicsContext3D().doClear();
        }
        Object object = this.extentLock;
        synchronized (object) {
            if (this.xmin < 0) {
                this.xmin = 0;
            }
            if (this.xmax > this.width) {
                this.xmax = this.width;
            }
            if (this.ymin < 0) {
                this.ymin = 0;
            }
            if (this.ymax > this.height) {
                this.ymax = this.height;
            }
            if (this.xmax - this.xmin > 0 && this.ymax - this.ymin > 0) {
                if (this.abgr) {
                    this.data = ((DataBufferByte)this.g3dImage.getRaster().getDataBuffer()).getData();
                } else {
                    this.copyImage(this.g3dImage, this.data, this.width, this.height, this.xmin, this.ymin, this.xmax, this.ymax);
                }
                this.copyDataToCanvas(0, 0, this.xmin, this.ymin, this.xmax, this.ymax, this.width, this.height);
            } else {
                this.runMonitor(2);
            }
            this.xmax = 0;
            this.ymax = 0;
            this.xmin = this.width;
            this.ymin = this.height;
        }
    }

    final void copyImage(BufferedImage bufferedImage, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        assert (!this.hasBeenDisposed);
        int n7 = bufferedImage.getType();
        int n8 = 0;
        int n9 = 1;
        int n10 = 0;
        if (n7 == 2 || n7 == 1) {
            n10 = n4;
            int n11 = n3;
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            int n12 = n9 * n;
            n10 = n10 * n + n11;
            n8 = n10 * 4;
            if (n7 == 2) {
                for (int i = n4; i < n6; ++i) {
                    int n13 = n10;
                    int n14 = n8;
                    int n15 = n3;
                    while (n15 < n5) {
                        int n16 = nArray[n13];
                        byArray[n14++] = (byte)(n16 >> 16 & 0xFF);
                        byArray[n14++] = (byte)(n16 >> 8 & 0xFF);
                        byArray[n14++] = (byte)(n16 & 0xFF);
                        byArray[n14++] = (byte)(n16 >> 24 & 0xFF);
                        ++n15;
                        ++n13;
                    }
                    n10 += n12;
                    n8 += n12 * 4;
                }
            } else {
                for (int i = n4; i < n6; ++i) {
                    int n17 = n10;
                    int n18 = n8;
                    int n19 = n3;
                    while (n19 < n5) {
                        int n20 = nArray[n17];
                        byArray[n18++] = (byte)(n20 >> 16 & 0xFF);
                        byArray[n18++] = (byte)(n20 >> 8 & 0xFF);
                        byArray[n18++] = (byte)(n20 & 0xFF);
                        byArray[n18++] = -1;
                        ++n19;
                        ++n17;
                    }
                    n10 += n12;
                    n8 += n12 * 4;
                }
            }
        } else {
            WritableRaster writableRaster = bufferedImage.getRaster();
            ColorModel colorModel = bufferedImage.getColorModel();
            Object object = ImageComponentRetained.getDataElementBuffer(writableRaster);
            int n21 = (n4 * n + n3) * 4;
            for (int i = n4; i < n6; ++i) {
                int n22 = n21;
                for (int j = n3; j < n5; ++j) {
                    writableRaster.getDataElements(j, i, object);
                    byArray[n21++] = (byte)colorModel.getRed(object);
                    byArray[n21++] = (byte)colorModel.getGreen(object);
                    byArray[n21++] = (byte)colorModel.getBlue(object);
                    byArray[n21++] = (byte)colorModel.getAlpha(object);
                }
                n21 = n22 + n * 4;
            }
        }
    }

    void sendRenderMessage(boolean bl, int n, Object object, Object object2, Object object3) {
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 16;
        j3dMessage.type = 44;
        j3dMessage.universe = null;
        j3dMessage.view = null;
        j3dMessage.args[0] = this.canvas3d;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = object2;
        j3dMessage.args[4] = object3;
        while (!this.canvas3d.view.inRenderThreadData) {
            MasterControl.threadYield();
        }
        this.canvas3d.screen.renderer.rendererStructure.addMessage(j3dMessage);
        if (bl) {
            VirtualUniverse.mc.sendRunMessage(this.canvas3d.view, 16);
        } else {
            VirtualUniverse.mc.setWorkForRequestRenderer();
        }
    }

    final void validate() {
        this.validate(0.0f, 0.0f, this.width, this.height);
    }

    void validate(float f, float f2, float f3, float f4, AffineTransform affineTransform) {
        if (affineTransform == null) {
            this.validate(f, f2, f3, f4);
        } else {
            float f5;
            this.ptSrc.x = f;
            this.ptSrc.y = f2;
            affineTransform.transform(this.ptSrc, this.ptDst1);
            this.ptSrc.x = f3;
            this.ptSrc.y = f4;
            affineTransform.transform(this.ptSrc, this.ptDst2);
            if (this.ptDst1.x > this.ptDst2.x) {
                f5 = this.ptDst1.x;
                this.ptDst1.x = this.ptDst2.x;
                this.ptDst2.x = f5;
            }
            if (this.ptDst1.y > this.ptDst2.y) {
                f5 = this.ptDst1.y;
                this.ptDst1.y = this.ptDst2.y;
                this.ptDst2.y = f5;
            }
            this.validate(this.ptDst1.x - 1.0f, this.ptDst1.y - 1.0f, this.ptDst2.x + 1.0f, this.ptDst2.y + 1.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validate(float f, float f2, float f3, float f4) {
        boolean bl = false;
        this.isFlushed = false;
        Object object = this.canvas3d;
        synchronized (object) {
            if (this.initCtx && this.canvas3d.resizeGraphics2D) {
                bl = true;
                this.canvas3d.resizeGraphics2D = false;
            }
        }
        if (bl) {
            object = VirtualUniverse.mc.contextCreationLock;
            synchronized (object) {
                Graphics2D graphics2D = this.offScreenGraphics2D;
                this.initCtx = false;
                this.init();
                this.copyGraphics2D(graphics2D);
            }
        }
        object = this.getTransform();
        this.ptSrc.x = f;
        this.ptSrc.y = f2;
        ((AffineTransform)object).transform(this.ptSrc, this.ptDst1);
        this.ptSrc.x = f3;
        this.ptSrc.y = f4;
        ((AffineTransform)object).transform(this.ptSrc, this.ptDst2);
        Object object2 = this.extentLock;
        synchronized (object2) {
            if (this.ptDst1.x < (float)this.xmin) {
                this.xmin = (int)this.ptDst1.x;
            }
            if (this.ptDst1.y < (float)this.ymin) {
                this.ymin = (int)this.ptDst1.y;
            }
            if (this.ptDst2.x > (float)this.xmax) {
                this.xmax = (int)this.ptDst2.x;
            }
            if (this.ptDst2.y > (float)this.ymax) {
                this.ymax = (int)this.ptDst2.y;
            }
        }
    }

    void copyGraphics2D(Graphics2D graphics2D) {
        this.setColor(graphics2D.getColor());
        this.setFont(graphics2D.getFont());
        this.setClip(graphics2D.getClip());
        this.setComposite(graphics2D.getComposite());
        this.setTransform(graphics2D.getTransform());
        this.setPaint(graphics2D.getPaint());
        this.setStroke(graphics2D.getStroke());
        if (this.xOrModeColor != null) {
            this.setXORMode(this.xOrModeColor);
        }
    }

    public final void clip(Shape shape) {
        this.offScreenGraphics2D.clip(shape);
    }

    public FontMetrics getFontMetrics() {
        return this.offScreenGraphics2D.getFontMetrics();
    }

    public Rectangle getClipBounds(Rectangle rectangle) {
        return this.offScreenGraphics2D.getClipBounds(rectangle);
    }

    public Rectangle getClipRect() {
        return this.offScreenGraphics2D.getClipRect();
    }

    public String toString() {
        return this.offScreenGraphics2D.toString();
    }

    public final AffineTransform getTransform() {
        return this.offScreenGraphics2D.getTransform();
    }

    public final Color getColor() {
        return this.offScreenGraphics2D.getColor();
    }

    public final Composite getComposite() {
        return this.offScreenGraphics2D.getComposite();
    }

    public final Font getFont() {
        return this.offScreenGraphics2D.getFont();
    }

    public final FontMetrics getFontMetrics(Font font) {
        return this.offScreenGraphics2D.getFontMetrics(font);
    }

    public final FontRenderContext getFontRenderContext() {
        return this.offScreenGraphics2D.getFontRenderContext();
    }

    public final GraphicsConfiguration getDeviceConfiguration() {
        return this.offScreenGraphics2D.getDeviceConfiguration();
    }

    public final Object getRenderingHint(RenderingHints.Key key) {
        return this.offScreenGraphics2D.getRenderingHint(key);
    }

    public final Paint getPaint() {
        return this.offScreenGraphics2D.getPaint();
    }

    public final Rectangle getClipBounds() {
        return this.offScreenGraphics2D.getClipBounds();
    }

    public final RenderingHints getRenderingHints() {
        return this.offScreenGraphics2D.getRenderingHints();
    }

    public final Shape getClip() {
        return this.offScreenGraphics2D.getClip();
    }

    public final Stroke getStroke() {
        return this.offScreenGraphics2D.getStroke();
    }

    public final boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        this.validate(0.0f, 0.0f, image.getWidth(imageObserver), image.getHeight(imageObserver), affineTransform);
        return this.offScreenGraphics2D.drawImage(image, affineTransform, imageObserver);
    }

    public final void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        if (bufferedImageOp != null) {
            bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        }
        this.validate(n, n2, n + bufferedImage.getWidth(), n2 + bufferedImage.getHeight());
        this.offScreenGraphics2D.drawImage(bufferedImage, null, n, n2);
    }

    public final boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.validate(n, n2, n + image.getWidth(imageObserver), n2 + image.getWidth(imageObserver));
        return this.offScreenGraphics2D.drawImage(image, n, n2, imageObserver);
    }

    public final boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.validate(n, n2, n + n3, n2 + n4);
        return this.offScreenGraphics2D.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    public final boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        this.validate(n, n2, n + n3, n2 + n4);
        return this.offScreenGraphics2D.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public final void drawImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        this.validate(n, n2, n3, n4);
        this.offScreenGraphics2D.drawImage(bufferedImage, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public final boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        this.validate(n, n2, n3, n4);
        return this.offScreenGraphics2D.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public final boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        this.validate(n, n2, n3, n4);
        return this.offScreenGraphics2D.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public final boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        this.validate(n, n2, n + image.getWidth(imageObserver), n2 + image.getHeight(imageObserver));
        return this.offScreenGraphics2D.drawImage(image, n, n2, color, imageObserver);
    }

    public final boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return this.offScreenGraphics2D.hit(rectangle, shape, bl);
    }

    public final void addRenderingHints(Map map) {
        this.offScreenGraphics2D.addRenderingHints(map);
    }

    public final void clipRect(int n, int n2, int n3, int n4) {
        this.offScreenGraphics2D.clipRect(n, n2, n3, n4);
    }

    public final void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.validate(n + n5, n2 + n6, n + n5 + n3, n2 + n6 + n4);
        this.offScreenGraphics2D.copyArea(n, n2, n3, n4, n5, n6);
    }

    public final void draw(Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.validate(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        this.offScreenGraphics2D.draw(shape);
    }

    public final void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.validate();
        this.offScreenGraphics2D.drawArc(n, n2, n3, n4, n5, n6);
    }

    public final void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.validate();
        this.offScreenGraphics2D.drawGlyphVector(glyphVector, f, f2);
    }

    public final void drawLine(int n, int n2, int n3, int n4) {
        if (!this.strokeSet) {
            int n5;
            int n6;
            int n7;
            int n8;
            if (n > n3) {
                n8 = n3;
                n7 = n;
            } else {
                n8 = n;
                n7 = n3;
            }
            if (n2 > n4) {
                n6 = n4;
                n5 = n2;
            } else {
                n6 = n2;
                n5 = n4;
            }
            this.validate(n8, n6, n7, n5);
        } else {
            this.validate();
        }
        this.offScreenGraphics2D.drawLine(n, n2, n3, n4);
    }

    public final void drawOval(int n, int n2, int n3, int n4) {
        this.validate();
        this.offScreenGraphics2D.drawOval(n, n2, n3, n4);
    }

    public final void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.validate();
        this.offScreenGraphics2D.drawPolygon(nArray, nArray2, n);
    }

    public final void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.validate();
        this.offScreenGraphics2D.drawPolyline(nArray, nArray2, n);
    }

    public final void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.validate(0.0f, 0.0f, renderableImage.getWidth(), renderableImage.getHeight(), affineTransform);
        this.offScreenGraphics2D.drawRenderableImage(renderableImage, affineTransform);
    }

    public final void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.validate(0.0f, 0.0f, renderedImage.getWidth(), renderedImage.getHeight(), affineTransform);
        this.offScreenGraphics2D.drawRenderedImage(renderedImage, affineTransform);
    }

    public final void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.validate();
        this.offScreenGraphics2D.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public final void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.validate();
        this.offScreenGraphics2D.drawString(attributedCharacterIterator, n, n2);
    }

    public final void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        this.validate();
        this.offScreenGraphics2D.drawString(attributedCharacterIterator, f, f2);
    }

    public final void drawString(String string, float f, float f2) {
        TextLayout textLayout = new TextLayout(string, this.getFont(), this.getFontRenderContext());
        Rectangle2D rectangle2D = textLayout.getBounds();
        float f3 = (float)rectangle2D.getX();
        float f4 = (float)rectangle2D.getY();
        this.validate(f3 + f, f4 + f2, f3 + f + (float)rectangle2D.getWidth(), f4 + f2 + (float)rectangle2D.getHeight());
        this.offScreenGraphics2D.drawString(string, f, f2);
    }

    public final void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public final void fill(Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.validate(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        this.offScreenGraphics2D.fill(shape);
    }

    public final void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.validate();
        this.offScreenGraphics2D.fillArc(n, n2, n3, n4, n5, n6);
    }

    public final void fillOval(int n, int n2, int n3, int n4) {
        this.validate();
        this.offScreenGraphics2D.fillOval(n, n2, n3, n4);
    }

    public final void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.validate();
        this.offScreenGraphics2D.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public final void rotate(double d) {
        this.offScreenGraphics2D.rotate(d);
    }

    public final void rotate(double d, double d2, double d3) {
        this.offScreenGraphics2D.rotate(d, d2, d3);
    }

    public final void scale(double d, double d2) {
        this.offScreenGraphics2D.scale(d, d2);
    }

    public final void setClip(Shape shape) {
        this.offScreenGraphics2D.setClip(shape);
    }

    public final void setClip(int n, int n2, int n3, int n4) {
        this.offScreenGraphics2D.setClip(n, n2, n3, n4);
    }

    public final void setColor(Color color) {
        this.offScreenGraphics2D.setColor(color);
    }

    public final void setComposite(Composite composite) {
        this.offScreenGraphics2D.setComposite(composite);
    }

    public final void setFont(Font font) {
        this.offScreenGraphics2D.setFont(font);
    }

    public final void setPaint(Paint paint) {
        this.offScreenGraphics2D.setPaint(paint);
    }

    public final void setPaintMode() {
        this.xOrModeColor = null;
        this.offScreenGraphics2D.setPaintMode();
    }

    public final void setRenderingHint(RenderingHints.Key key, Object object) {
        this.offScreenGraphics2D.setRenderingHint(key, object);
    }

    public final void setRenderingHints(Map map) {
        this.offScreenGraphics2D.setRenderingHints(map);
    }

    public final void setStroke(Stroke stroke) {
        this.strokeSet = stroke != null;
        this.offScreenGraphics2D.setStroke(stroke);
    }

    public final void setTransform(AffineTransform affineTransform) {
        this.offScreenGraphics2D.setTransform(affineTransform);
    }

    public final void setXORMode(Color color) {
        this.xOrModeColor = color;
        this.offScreenGraphics2D.setXORMode(color);
    }

    public final void shear(double d, double d2) {
        this.offScreenGraphics2D.shear(d, d2);
    }

    public final void transform(AffineTransform affineTransform) {
        this.offScreenGraphics2D.transform(affineTransform);
    }

    public final void translate(double d, double d2) {
        this.offScreenGraphics2D.translate(d, d2);
    }

    public final void translate(int n, int n2) {
        this.offScreenGraphics2D.translate(n, n2);
    }

    public boolean hitClip(int n, int n2, int n3, int n4) {
        return this.offScreenGraphics2D.hitClip(n, n2, n3, n4);
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.validate();
        this.offScreenGraphics2D.draw3DRect(n, n2, n3, n4, bl);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.validate();
        this.offScreenGraphics2D.drawBytes(byArray, n, n2, n3, n4);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.validate();
        this.offScreenGraphics2D.drawChars(cArray, n, n2, n3, n4);
    }

    public void drawPolygon(Polygon polygon) {
        this.validate();
        this.offScreenGraphics2D.drawPolygon(polygon);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.validate();
        this.offScreenGraphics2D.drawRect(n, n2, n3, n4);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.validate();
        this.offScreenGraphics2D.fill3DRect(n, n2, n3, n4, bl);
    }

    public void fillPolygon(Polygon polygon) {
        this.validate();
        this.offScreenGraphics2D.fillPolygon(polygon);
    }

    public final void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.validate();
        this.offScreenGraphics2D.fillPolygon(nArray, nArray2, n);
    }

    public final void fillRect(int n, int n2, int n3, int n4) {
        this.validate();
        this.offScreenGraphics2D.fillRect(n, n2, n3, n4);
    }

    public void dispose() {
        if (Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doDispose();
        } else {
            boolean bl = Thread.currentThread() != this.canvas3d.view.universe.behaviorScheduler;
            this.sendRenderMessage(bl, 26, null, null, null);
        }
    }

    public void doDispose() {
        if (this.hasBeenDisposed) {
            return;
        }
        if (this.objectId != -1) {
            Canvas3D.freeTexture(this.canvas3d.ctx, this.objectId);
            VirtualUniverse.mc.freeTexture2DId(this.objectId);
            this.objectId = -1;
        }
        this.offScreenGraphics2D.dispose();
        this.hasBeenDisposed = true;
    }

    public void drawAndFlushImage(BufferedImage bufferedImage, int n, int n2, ImageObserver imageObserver) {
        if (this.hasBeenDisposed) {
            throw new IllegalStateException(J3dI18N.getString("J3DGraphics2D0"));
        }
        if (!this.initCtx || !this.abgr || bufferedImage.getType() != 6) {
            this.drawImage((Image)bufferedImage, n, n2, imageObserver);
            this.flush(false);
            return;
        }
        if (Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doDrawAndFlushImage(bufferedImage, n, n2, imageObserver);
        } else {
            boolean bl = Thread.currentThread() != this.canvas3d.view.universe.behaviorScheduler;
            this.sendRenderMessage(bl, 24, bufferedImage, new Point(n, n2), imageObserver);
        }
    }

    void doDrawAndFlushImage(BufferedImage bufferedImage, int n, int n2, ImageObserver imageObserver) {
        int n3;
        int n4;
        assert (!this.hasBeenDisposed);
        int n5 = bufferedImage.getWidth(imageObserver);
        int n6 = bufferedImage.getHeight(imageObserver);
        if (this.canvas3d.ctx == null) {
            this.canvas3d.getGraphicsContext3D().doClear();
        }
        this.data = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        AffineTransform affineTransform = this.getTransform();
        this.ptSrc.x = n;
        this.ptSrc.y = n2;
        affineTransform.transform(this.ptSrc, this.ptDst1);
        int n7 = (int)this.ptDst1.x;
        int n8 = (int)this.ptDst1.y;
        int n9 = n7 + n5 > this.width ? this.width - n7 : n5;
        if (n7 < 0) {
            n4 = -n7;
            n7 = 0;
        } else {
            n4 = 0;
        }
        int n10 = n8 + n6 > this.height ? this.height - n8 : n6;
        if (n8 < 0) {
            n3 = -n8;
            n8 = 0;
        } else {
            n3 = 0;
        }
        if (n10 - n3 > 0 && n9 - n4 > 0) {
            this.copyDataToCanvas(n7, n8, n4, n3, n9, n10, n5, n6);
        }
    }

    void copyDataToCanvas(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        try {
            if (!this.canvas3d.drawingSurfaceObject.renderLock()) {
                return;
            }
            if (!this.initTexMap) {
                if (this.objectId == -1) {
                    this.objectId = VirtualUniverse.mc.getTexture2DId();
                }
                this.texWidth = J3DGraphics2DImpl.getGreaterPowerOf2(n7);
                this.texHeight = J3DGraphics2DImpl.getGreaterPowerOf2(n8);
                if (!this.canvas3d.initTexturemapping(this.canvas3d.ctx, this.texWidth, this.texHeight, this.objectId)) {
                    this.initTexMap = false;
                    VirtualUniverse.mc.freeTexture2DId(this.objectId);
                    this.objectId = -1;
                    System.err.println("J3DGraphics2DImpl.copyDataToCanvas() : Fail to get texture resources ...");
                } else {
                    this.initTexMap = true;
                }
            }
            if (this.initTexMap) {
                this.canvas3d.texturemapping(this.canvas3d.ctx, n, n2, n3, n4, n5, n6, this.texWidth, this.texHeight, n7, this.abgr ? 4 : 8, this.objectId, this.data, this.width, this.height);
            }
            this.canvas3d.drawingSurfaceObject.unLock();
        }
        catch (NullPointerException nullPointerException) {
            this.canvas3d.drawingSurfaceObject.unLock();
            throw nullPointerException;
        }
        this.clearOffScreen();
        this.runMonitor(2);
    }

    void clearOffScreen() {
        Composite composite = this.offScreenGraphics2D.getComposite();
        Color color = this.offScreenGraphics2D.getColor();
        this.offScreenGraphics2D.setComposite(AlphaComposite.Src);
        this.offScreenGraphics2D.setColor(blackTransparent);
        this.offScreenGraphics2D.fillRect(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
        this.offScreenGraphics2D.setComposite(composite);
        this.offScreenGraphics2D.setColor(color);
    }

    static int getGreaterPowerOf2(int n) {
        int n2 = -1;
        if (n >= 0) {
            for (n2 = 1; n2 < n; n2 <<= 1) {
            }
        }
        return n2;
    }

    synchronized void runMonitor(int n) {
        if (n == 0) {
            while (this.threadWaiting) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        } else if (n == 2) {
            this.notify();
            this.threadWaiting = false;
        }
    }
}

