/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import java.io.IOException;
import org.geotools.data.FIDReader;
import org.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import org.geotools.feature.FeatureType;

public class ShapeFIDReader
implements FIDReader {
    protected static final String CLOSE_MESG = "Close has already been called on this FIDReader";
    private boolean opened;
    private IndexedShapefileDataStore.Reader reader;
    private int len;
    protected StringBuffer buffer;

    public ShapeFIDReader(String typeName, IndexedShapefileDataStore.Reader reader) {
        this.buffer = new StringBuffer(typeName);
        this.buffer.append('.');
        this.len = typeName.length() + 1;
        this.opened = true;
        this.reader = reader;
    }

    public ShapeFIDReader(FeatureType featureType, IndexedShapefileDataStore.Reader reader) {
        this(featureType.getTypeName(), reader);
    }

    public void close() {
        this.opened = false;
    }

    public boolean hasNext() throws IOException {
        if (!this.opened) {
            throw new IOException(CLOSE_MESG);
        }
        return true;
    }

    public String next() throws IOException {
        if (!this.opened) {
            throw new IOException(CLOSE_MESG);
        }
        this.buffer.delete(this.len, this.buffer.length());
        this.buffer.append(this.reader.getRecordNumber() - 1);
        return this.buffer.toString();
    }
}

