/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.io;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.unijena.jams.JAMS;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.runtime.RuntimeException;

public class GenericDataWriter {
    private String fileName;
    public BufferedWriter writer;
    private ArrayList<String> header = new ArrayList();
    private ArrayList<String> comments = new ArrayList();
    private ArrayList<Object> data;
    private boolean headerClosed = false;

    public GenericDataWriter() {
    }

    public GenericDataWriter(String fileName) {
        this.setFileName(fileName);
    }

    private void openFile() {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.fileName));
        }
        catch (IOException ioe) {
            JAMS.handle(ioe);
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException ioe) {
            JAMS.handle(ioe);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.openFile();
    }

    public void addColumn(String name) {
        if (!this.headerClosed) {
            this.header.add(name);
        }
    }

    public void addComment(String comment) {
        if (!this.headerClosed) {
            this.comments.add("# " + comment);
        }
    }

    public void writeHeader() {
        String s = "";
        Iterator<String> i = this.comments.iterator();
        while (i.hasNext()) {
            s = s + i.next() + "\n";
        }
        i = this.header.iterator();
        if (i.hasNext()) {
            s = s + i.next();
        }
        while (i.hasNext()) {
            s = s + "\t" + i.next();
        }
        try {
            this.writer.write(s);
            this.writer.newLine();
        }
        catch (IOException ioe) {
            JAMS.handle(ioe);
        }
        this.headerClosed = true;
        this.data = new ArrayList(this.header.size());
    }

    public void addData(Object o) {
        this.data.add(o);
    }

    public void writeLine(String line) {
        try {
            this.writer.write(line);
            this.writer.newLine();
        }
        catch (IOException ioe) {
            JAMS.handle(ioe);
        }
    }

    public void write(String line) {
        try {
            this.writer.write(line);
        }
        catch (IOException ioe) {
            JAMS.handle(ioe);
        }
    }

    public void writeData() throws RuntimeException {
        String s = "";
        if (this.data.size() != this.header.size()) {
            throw new RuntimeException("Wrong number of output columns!");
        }
        Iterator<Object> i = this.data.iterator();
        if (i.hasNext()) {
            s = i.next().toString();
        }
        while (i.hasNext()) {
            s = s + "\t" + i.next().toString();
        }
        try {
            this.writer.write(s);
            this.writer.newLine();
        }
        catch (IOException ioe) {
            JAMS.handle(ioe);
        }
        this.data.clear();
    }

    public void writeData(int prec) throws RuntimeException {
        String s = "";
        if (this.data.size() != this.header.size()) {
            throw new RuntimeException("Wrong number of output columns!");
        }
        Iterator<Object> i = this.data.iterator();
        if (i.hasNext()) {
            s = i.next().toString();
        }
        while (i.hasNext()) {
            double val = ((JAMSDouble)i.next()).getValue();
            String dStr = String.format(Locale.US, "%." + prec + "f", val);
            s = s + "\t" + dStr;
        }
        try {
            this.writer.write(s);
            this.writer.newLine();
        }
        catch (IOException ioe) {
            JAMS.handle(ioe);
        }
        this.data.clear();
    }

    public void close() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException ioe) {
            JAMS.handle(ioe);
        }
    }
}

