/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.runtime;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import org.unijena.jams.JAMSProperties;
import org.unijena.jams.JAMSTools;
import org.unijena.jams.ModelConfig;
import org.unijena.jams.ModelPreprocessor;
import org.unijena.jams.data.JAMSData;
import org.unijena.jams.io.JAMSModelLoader;
import org.unijena.jams.model.JAMSGUIComponent;
import org.unijena.jams.model.JAMSModel;
import org.unijena.jams.runtime.JAMSClassLoader;
import org.unijena.jams.runtime.JAMSLog;
import org.unijena.jams.runtime.JAMSRuntime;
import org.w3c.dom.Document;

public class StandardRuntime
implements JAMSRuntime {
    private HashMap<String, JAMSData> dataHandles = new HashMap();
    private JAMSLog errorLog = new JAMSLog();
    private JAMSLog infoLog = new JAMSLog();
    private int debugLevel = 1;
    private RunState runState = new RunState();
    private ArrayList<JAMSGUIComponent> guiComponents = new ArrayList();
    private JButton stopButton;
    private JButton closeButton;
    private JFrame frame;
    private JAMSModel model;
    private PrintStream infoStream;
    private PrintStream errorStream;
    private boolean guiEnabled = false;
    private ClassLoader classLoader;

    @Override
    public void loadModel(Document modelDocument, JAMSProperties properties) {
        long start = System.currentTimeMillis();
        int debugLevel = Integer.parseInt(properties.getProperty("debug", "1"));
        this.setDebugLevel(debugLevel);
        int verbose = Integer.parseInt(properties.getProperty("verbose", "1"));
        if (verbose != 0) {
            this.addInfoLogObserver(new Observer(){

                @Override
                public void update(Observable obs, Object obj) {
                    System.out.print(obj);
                }
            });
            this.addErrorLogObserver(new Observer(){

                @Override
                public void update(Observable obs, Object obj) {
                    System.out.print(obj);
                }
            });
        }
        try {
            if (properties.getProperty("infolog") != null && !properties.getProperty("infolog").equals("")) {
                this.infoStream = new PrintStream(properties.getProperty("infolog"));
            }
        }
        catch (FileNotFoundException fnfe) {
            this.handle(fnfe);
        }
        try {
            if (properties.getProperty("errorlog") != null && !properties.getProperty("errorlog").equals("")) {
                this.errorStream = new PrintStream(properties.getProperty("errorlog"));
            }
        }
        catch (FileNotFoundException fnfe) {
            this.handle(fnfe);
        }
        String[] libs = JAMSTools.toArray(properties.getProperty("libs", ""), ";");
        this.classLoader = JAMSClassLoader.createClassLoader(libs, this);
        ModelConfig config = new ModelConfig(modelDocument);
        ModelPreprocessor preProc = new ModelPreprocessor(modelDocument, config, this);
        preProc.process();
        JAMSModelLoader modelLoader = new JAMSModelLoader(modelDocument, null, this);
        this.model = modelLoader.getModel();
        int wEnable = Integer.parseInt(properties.getProperty("windowenable", "1"));
        if (wEnable != 0) {
            int width = Integer.parseInt(properties.getProperty("windowwidth", "600"));
            int height = Integer.parseInt(properties.getProperty("windowheight", "400"));
            int ontop = Integer.parseInt(properties.getProperty("windowontop", "0"));
            this.initGUI(this.model.getName(), ontop == 1, width, height);
            this.guiEnabled = true;
        }
        long end = System.currentTimeMillis();
        this.println("JAMS model setup time: " + (end - start) + " ms", 1);
    }

    @Override
    public void runModel() {
        if (this.getRunState() != 1) {
            return;
        }
        if (this.guiEnabled) {
            this.frame.setVisible(true);
        }
        long start = System.currentTimeMillis();
        if (this.getRunState() == 1) {
            this.model.init();
        }
        if (this.getRunState() == 1) {
            this.model.run();
        }
        if (this.getRunState() == 1) {
            this.model.cleanup();
        }
        long end = System.currentTimeMillis();
        this.println("JAMS model execution time: " + (end - start) + " ms", 1);
        this.sendHalt();
        if (this.infoStream != null) {
            this.infoStream.print(this.getInfoLog());
            this.infoStream.close();
        }
        if (this.errorStream != null) {
            this.errorStream.print(this.getErrorLog());
            this.errorStream.close();
        }
        this.model = null;
        Runtime.getRuntime().gc();
    }

    @Override
    public void initGUI(String title, boolean ontop, int width, int height) {
        if (this.guiComponents.size() == 0) {
            return;
        }
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(2);
        this.frame.setTitle(title);
        this.frame.setName(title);
        this.frame.setAlwaysOnTop(ontop);
        this.frame.setIconImage(new ImageIcon(ClassLoader.getSystemResource("resources/images/JAMSicon16.png")).getImage());
        this.frame.setPreferredSize(new Dimension(width, height));
        ListIterator<JAMSGUIComponent> i = this.guiComponents.listIterator();
        if (this.guiComponents.size() > 1) {
            JTabbedPane tabbedPane = new JTabbedPane();
            while (i.hasNext()) {
                JAMSGUIComponent comp = i.next();
                tabbedPane.addTab(comp.getInstanceName(), comp.getPanel());
            }
            this.frame.getContentPane().add((Component)tabbedPane, "Center");
        } else {
            while (i.hasNext()) {
                this.frame.getContentPane().add((Component)i.next().getPanel(), "Center");
            }
        }
        JToolBar toolBar = new JToolBar();
        toolBar.setPreferredSize(new Dimension(0, 50));
        this.stopButton = new JButton();
        this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelStop.png")));
        this.stopButton.setEnabled(true);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StandardRuntime.this.sendHalt();
                StandardRuntime.this.stopButton.setEnabled(false);
            }
        });
        toolBar.add(this.stopButton);
        this.closeButton = new JButton();
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/Shutdown.png")));
        this.closeButton.setEnabled(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StandardRuntime.this.sendHalt();
                StandardRuntime.this.frame.dispose();
                Runtime.getRuntime().gc();
            }
        });
        toolBar.add(this.closeButton);
        this.frame.add((Component)toolBar, "North");
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StandardRuntime.this.sendHalt();
                StandardRuntime.this.frame.dispose();
                Runtime.getRuntime().gc();
            }
        });
        this.addRunStateObserver(new Observer(){

            @Override
            public void update(Observable obs, Object obj) {
                StandardRuntime.this.stopButton.setEnabled(false);
                if (StandardRuntime.this.getRunState() == 0) {
                    StandardRuntime.this.closeButton.setEnabled(true);
                }
            }
        });
        this.frame.pack();
        this.frame.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - (double)width) / 2, (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() - (double)height) / 2);
    }

    @Override
    public HashMap<String, JAMSData> getDataHandles() {
        return this.dataHandles;
    }

    public void setDataHandles(HashMap<String, JAMSData> dataHandles) {
        this.dataHandles = dataHandles;
    }

    @Override
    public void println(String s, int debugLevel) {
        if (debugLevel <= this.getDebugLevel()) {
            this.sendInfoMsg(s);
        }
    }

    @Override
    public void println(String s) {
        this.sendInfoMsg(s);
    }

    @Override
    public int getDebugLevel() {
        return this.debugLevel;
    }

    @Override
    public void setDebugLevel(int aDebugLevel) {
        this.debugLevel = aDebugLevel;
    }

    @Override
    public void handle(Exception ex) {
        this.handle(ex, false);
    }

    @Override
    public void handle(Exception ex, String cName) {
        this.sendErrorMsg("Exception occured in component " + cName);
        this.handle(ex, false);
    }

    @Override
    public void handle(Exception ex, boolean proceed) {
        if (this.getDebugLevel() <= 1) {
            this.sendErrorMsg(ex.toString());
        } else {
            this.sendErrorMsg(ex.toString());
            this.sendErrorMsg(JAMSTools.getStackTraceString(ex.getStackTrace()));
        }
        if (!proceed) {
            this.sendHalt();
        }
    }

    @Override
    public void sendHalt() {
        this.runState.setState(0);
    }

    @Override
    public void sendHalt(String str) {
        this.sendErrorMsg(str);
        this.sendHalt();
    }

    @Override
    public void sendErrorMsg(String str) {
        this.errorLog.print("ERROR: " + str + "\n");
    }

    @Override
    public void sendInfoMsg(String str) {
        this.infoLog.print("INFO: " + str + "\n");
    }

    @Override
    public void addRunStateObserver(Observer o) {
        this.runState.addObserver(o);
    }

    @Override
    public int getRunState() {
        return this.runState.getState();
    }

    @Override
    public void addInfoLogObserver(Observer o) {
        this.infoLog.addObserver(o);
    }

    @Override
    public void addErrorLogObserver(Observer o) {
        this.errorLog.addObserver(o);
    }

    @Override
    public String getErrorLog() {
        return this.errorLog.getLogString();
    }

    @Override
    public String getInfoLog() {
        return this.infoLog.getLogString();
    }

    @Override
    public void addGUIComponent(JAMSGUIComponent component) {
        this.guiComponents.add(component);
    }

    @Override
    public JFrame getFrame() {
        return this.frame;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    class RunState
    extends Observable {
        private int state = 1;

        RunState() {
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
            this.setChanged();
            this.notifyObservers();
        }
    }
}

