/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.event.AbstractGTComponent;
import org.geotools.event.GTList;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.resources.Utilities;
import org.geotools.styling.Fill;
import org.geotools.styling.FillImpl;
import org.geotools.styling.Font;
import org.geotools.styling.FontImpl;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.PointPlacementImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.opengis.util.Cloneable;

public class TextSymbolizerImpl
extends AbstractGTComponent
implements TextSymbolizer2,
Cloneable {
    private static final FilterFactory filterFactory = FilterFactoryFinder.createFilterFactory();
    private Fill fill;
    private List fonts = new GTList(this, "fonts");
    private Halo halo;
    private LabelPlacement placement;
    private String geometryPropertyName = null;
    private Expression label = null;
    private Graphic graphic = null;
    private Expression priority = null;
    private HashMap optionsMap = null;

    protected TextSymbolizerImpl() {
        this.fill = new FillImpl();
        this.fill.setColor((Expression)filterFactory.createLiteralExpression("#000000"));
        this.halo = null;
        this.placement = new PointPlacementImpl();
    }

    public String geometryPropertyName() {
        return this.geometryPropertyName;
    }

    public Fill getFill() {
        return this.fill;
    }

    public void setFill(Fill fill) {
        if (this.fill == fill) {
            return;
        }
        Fill old = this.fill;
        this.fill = fill;
        this.fireChildChanged("fill", fill, old);
    }

    public Font[] getFonts() {
        if (this.fonts.size() == 0) {
            this.fonts.add(new FontImpl());
        }
        return this.fonts.toArray(new Font[0]);
    }

    public void addFont(Font font) {
        this.fonts.add(font);
    }

    public void setFonts(Font[] fonts) {
        List<Font> newFonts = Arrays.asList(fonts);
        this.fonts.clear();
        this.fonts.addAll(newFonts);
    }

    public Halo getHalo() {
        return this.halo;
    }

    public void setHalo(Halo halo) {
        if (this.halo == halo) {
            return;
        }
        Halo old = this.halo;
        this.halo = halo;
        this.fireChildChanged("halo", halo, old);
    }

    public Expression getLabel() {
        return this.label;
    }

    public void setLabel(Expression label) {
        Expression old = this.label;
        this.label = label;
        this.fireChildChanged("label", label, old);
    }

    public LabelPlacement getPlacement() {
        return this.placement;
    }

    public void setPlacement(LabelPlacement labelPlacement) {
        if (this.placement == labelPlacement) {
            return;
        }
        LabelPlacement old = this.placement;
        this.placement = labelPlacement;
        this.fireChildChanged("placement", labelPlacement, old);
    }

    public LabelPlacement getLabelPlacement() {
        return this.getPlacement();
    }

    public void setLabelPlacement(LabelPlacement labelPlacement) {
        this.setPlacement(labelPlacement);
    }

    public String getGeometryPropertyName() {
        return this.geometryPropertyName;
    }

    public void setGeometryPropertyName(String geometryPropertyName) {
        this.geometryPropertyName = geometryPropertyName;
        this.fireChanged();
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((TextSymbolizer)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.fill != null) {
            result = 1000003 * result + this.fill.hashCode();
        }
        if (this.fonts != null) {
            result = 1000003 * result + ((Object)this.fonts).hashCode();
        }
        if (this.halo != null) {
            result = 1000003 * result + this.halo.hashCode();
        }
        if (this.placement != null) {
            result = 1000003 * result + this.placement.hashCode();
        }
        if (this.geometryPropertyName != null) {
            result = 1000003 * result + this.geometryPropertyName.hashCode();
        }
        if (this.label != null) {
            result = 1000003 * result + this.label.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth instanceof TextSymbolizerImpl) {
            TextSymbolizerImpl other = (TextSymbolizerImpl)oth;
            return Utilities.equals((Object)this.geometryPropertyName, (Object)other.geometryPropertyName) && Utilities.equals((Object)this.label, (Object)other.label) && Utilities.equals((Object)this.halo, (Object)other.halo) && Utilities.equals((Object)this.fonts, (Object)other.fonts) && Utilities.equals((Object)this.placement, (Object)other.placement) && Utilities.equals((Object)this.fill, (Object)other.fill);
        }
        return false;
    }

    public void setPriority(Expression priority) {
        if (this.priority == priority) {
            return;
        }
        Expression old = this.priority;
        this.priority = priority;
        this.fireChildChanged("priority", priority, old);
    }

    public Expression getPriority() {
        return this.priority;
    }

    public void addToOptions(String key, String value) {
        if (this.optionsMap == null) {
            this.optionsMap = new HashMap();
        }
        this.optionsMap.put(key, value.trim());
        this.fireChanged();
    }

    public String getOption(String key) {
        if (this.optionsMap == null) {
            return null;
        }
        return (String)this.optionsMap.get(key);
    }

    public Map getOptions() {
        return this.optionsMap;
    }

    public Graphic getGraphic() {
        return this.graphic;
    }

    public void setGraphic(Graphic graphic) {
        if (this.graphic == graphic) {
            return;
        }
        Graphic old = this.graphic;
        this.graphic = graphic;
        this.fireChildChanged("graphic", graphic, old);
    }
}

