/*
 * Decompiled with CFR 0.152.
 */
package javax.units;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.HashMap;
import javax.units.AddConverter;
import javax.units.Converter;
import javax.units.MultiplyConverter;
import javax.units.ProductUnit;
import javax.units.TransformedUnit;
import javax.units.Unit;

public abstract class UnitFormat
extends Format {
    private static final HashMap LABEL_UNIT = new HashMap();
    private static final HashMap UNIT_LABEL = new HashMap();
    private static final HashMap ALIAS_UNIT = new HashMap();
    private static final int DEFAULT = 0;
    private static final int SYSTEM_NAME = 1;
    private static final int NAME = 2;
    private static final int EXPONENT = 3;
    private static final int MARKUP = 4;
    private static final int ESCAPE = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Unit label(Unit unit, String string) {
        Serializable serializable;
        if (string != null) {
            if (Unit.searchSymbol(string) != null) {
                throw new IllegalArgumentException("Label: " + string + " is a known symbol");
            }
            serializable = (Unit)LABEL_UNIT.get(string);
            if (serializable != null && serializable != unit) {
                throw new IllegalArgumentException("Label: " + string + " is attached to a different unit" + " (must be detached first)");
            }
        }
        serializable = UnitFormat.class;
        synchronized (serializable) {
            String string2 = (String)UNIT_LABEL.remove(unit);
            LABEL_UNIT.remove(string2);
            Unit unit2 = (Unit)LABEL_UNIT.remove(string);
            UNIT_LABEL.remove(unit2);
            LABEL_UNIT.put(string, unit);
            UNIT_LABEL.put(unit, string);
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Unit alias(Unit unit, String string) {
        Class clazz = UnitFormat.class;
        synchronized (clazz) {
            ALIAS_UNIT.put(string, unit);
        }
        return unit;
    }

    public static final UnitFormat getInstance() {
        return UnitFormat.getStandardInstance();
    }

    public static final UnitFormat getStandardInstance() {
        return Standard.INSTANCE;
    }

    public static final UnitFormat getAsciiInstance() {
        return Ascii.INSTANCE;
    }

    public static final UnitFormat getHtmlInstance() {
        return Html.INSTANCE;
    }

    public static boolean isUnitIdentifierPart(char c) {
        return c > '\"' && (c <= '%' || c > '?') && c != '^' && c != '\u00b9' && c != '\u00b2' && c != '\u00b3' && c != '\u00b7';
    }

    public abstract StringBuffer format(Object var1, StringBuffer var2, FieldPosition var3);

    public final Object parseObject(String string, ParsePosition parsePosition) {
        try {
            int n = parsePosition.getIndex();
            Unit unit = this.parseUnit(string.substring(n));
            parsePosition.setIndex(string.length());
            return unit;
        }
        catch (ParseException parseException) {
            parsePosition.setErrorIndex(parseException.getErrorOffset());
            return null;
        }
    }

    public Unit parseUnit(CharSequence charSequence) throws ParseException {
        int n = 0;
        CharSequence charSequence2 = null;
        CharSequence charSequence3 = null;
        CharSequence charSequence4 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        Unit unit = Unit.ONE;
        for (int i = 0; i <= charSequence.length(); ++i) {
            char c = i < charSequence.length() ? (char)charSequence.charAt(i) : (char)' ';
            switch (n) {
                case 0: {
                    if (c == '[') {
                        n2 = i;
                        n = 1;
                        bl3 = true;
                        break;
                    }
                    if (UnitFormat.isUnitIdentifierPart(c)) {
                        n2 = i;
                        n = 2;
                        bl3 = true;
                        break;
                    }
                    if (UnitFormat.isExponent(c)) {
                        n2 = i;
                        n = 3;
                        break;
                    }
                    if (c == '<') {
                        n = 4;
                        break;
                    }
                    if (c != 38) break;
                    n = 5;
                    break;
                }
                case 1: {
                    if (c == '[') {
                        ++n3;
                        break;
                    }
                    if (c == ']' && n3 == 0) {
                        charSequence2 = charSequence.subSequence(n2, i + 1);
                        n = 0;
                        break;
                    }
                    if (c != 93) break;
                    --n3;
                    break;
                }
                case 2: {
                    if (UnitFormat.isUnitIdentifierPart(c)) break;
                    charSequence2 = charSequence.subSequence(n2, i);
                    if (UnitFormat.isExponent(c)) {
                        n2 = i;
                        n = 3;
                        break;
                    }
                    if (c == '<') {
                        n = 4;
                        break;
                    }
                    if (c == '&') {
                        n = 5;
                        break;
                    }
                    n = 0;
                    break;
                }
                case 3: {
                    if (UnitFormat.isExponent(c)) break;
                    if (charSequence3 == null) {
                        charSequence3 = charSequence.subSequence(n2, i);
                    } else {
                        bl2 = false;
                        charSequence4 = charSequence.subSequence(n2, i);
                    }
                    if (c == '[') {
                        n2 = i;
                        n = 1;
                        bl3 = true;
                        break;
                    }
                    if (UnitFormat.isUnitIdentifierPart(c)) {
                        n2 = i;
                        n = 2;
                        bl3 = true;
                        break;
                    }
                    if (c == '<') {
                        n = 4;
                        break;
                    }
                    if (c == '&') {
                        n = 5;
                        break;
                    }
                    n = 0;
                    break;
                }
                case 4: {
                    if (c != 62) break;
                    n = 0;
                    break;
                }
                case 5: {
                    if (c != 59) break;
                    n = 0;
                    break;
                }
                default: {
                    throw new InternalError("state " + n + " unknown");
                }
            }
            if (c == '/' && n == 0) {
                bl2 = true;
            }
            if (i == charSequence.length()) {
                if (n == 2) {
                    charSequence2 = charSequence.subSequence(n2, charSequence.length());
                } else if (n == 3) {
                    if (charSequence3 == null) {
                        charSequence3 = charSequence.subSequence(n2, charSequence.length());
                    } else {
                        charSequence4 = charSequence.subSequence(n2, charSequence.length());
                    }
                }
                bl3 = true;
            }
            if (!bl3) continue;
            if (charSequence2 != null) {
                Unit unit2 = this.unitFor(charSequence2);
                if (unit2 != null) {
                    int n4 = UnitFormat.parseExponent(charSequence3);
                    int n5 = UnitFormat.parseExponent(charSequence4);
                    n4 = bl ? -n4 : n4;
                    unit = unit.multiply(unit2.pow(n4).root(n5));
                } else {
                    throw new ParseException("Label: " + charSequence2 + " not recognized", i);
                }
            }
            bl = bl2 ? !bl : bl;
            bl3 = false;
            charSequence2 = null;
            charSequence3 = null;
            charSequence4 = null;
            bl2 = false;
        }
        return unit;
    }

    private static boolean isExponent(char c) {
        return Character.isDigit(c) || c == '-' || c == '\u00b9' || c == '\u00b2' || c == '\u00b3';
    }

    private static int parseExponent(CharSequence charSequence) {
        if (charSequence != null) {
            boolean bl = false;
            int n = 0;
            for (int i = 0; i < charSequence.length(); ++i) {
                int n2 = charSequence.charAt(i);
                if (n2 == 45) {
                    bl = true;
                    continue;
                }
                if (n2 == 43) continue;
                if (n2 == 185) {
                    n2 = 49;
                } else if (n2 == 178) {
                    n2 = 50;
                } else if (n2 == 179) {
                    n2 = 51;
                }
                n = n * 10 + (n2 - 48);
            }
            return bl ? -n : n;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String labelFor(Unit unit) {
        Object object;
        Serializable serializable = UnitFormat.class;
        synchronized (serializable) {
            object = (String)UNIT_LABEL.get(unit);
            if (object != null) {
                return object;
            }
        }
        if (unit._symbol != null) {
            return unit._symbol;
        }
        if (unit instanceof TransformedUnit) {
            serializable = (TransformedUnit)unit;
            object = ((TransformedUnit)serializable).getSystemUnit();
            Converter converter = ((Unit)serializable).getConverterTo((Unit)object);
            if (converter instanceof AddConverter) {
                return "[" + object + "+" + ((AddConverter)converter).getOffset() + "]";
            }
            if (converter instanceof MultiplyConverter) {
                return "[" + object + "*" + ((MultiplyConverter)converter).derivative(0.0) + "]";
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Unit unitFor(CharSequence charSequence) {
        Serializable serializable = UnitFormat.class;
        synchronized (serializable) {
            Unit unit = (Unit)LABEL_UNIT.get(charSequence);
            if (unit != null) {
                return unit;
            }
            unit = (Unit)ALIAS_UNIT.get(charSequence);
            if (unit != null) {
                return unit;
            }
        }
        serializable = Unit.searchSymbol(charSequence);
        if (serializable != null) {
            return serializable;
        }
        return null;
    }

    private static void append(StringBuffer stringBuffer, String string, int n, int n2) {
        stringBuffer.append(string);
        if (n != 1 || n2 != 1) {
            if (n == 2 && n2 == 1) {
                stringBuffer.append('\u00b2');
            } else if (n == 3 && n2 == 1) {
                stringBuffer.append('\u00b3');
            } else {
                stringBuffer.append("^" + String.valueOf(n));
                if (n2 != 1) {
                    stringBuffer.append(':' + String.valueOf(n2));
                }
            }
        }
    }

    static {
        try {
            Class.forName("javax.units.SI");
            Class.forName("javax.units.NonSI");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static final class Ascii
    extends UnitFormat {
        private static final Ascii INSTANCE = new Ascii();

        private Ascii() {
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            Object object2;
            if (object instanceof Unit && (object2 = this.labelFor((Unit)object)) != null) {
                stringBuffer.append((String)object2);
                return stringBuffer;
            }
            if (object instanceof ProductUnit) {
                object2 = (ProductUnit)object;
                int n = stringBuffer.length();
                for (int i = 0; i < ((ProductUnit)object2).size(); ++i) {
                    if (n != stringBuffer.length()) {
                        stringBuffer.append(" ");
                    }
                    String string = this.labelFor(((ProductUnit)object2).get(i).getUnit());
                    int n2 = ((ProductUnit)object2).get(i).getPow();
                    int n3 = ((ProductUnit)object2).get(i).getRoot();
                    stringBuffer.append(string);
                    if (n2 == 1 && n3 == 1) continue;
                    stringBuffer.append("^" + String.valueOf(n2));
                    if (n3 == 1) continue;
                    stringBuffer.append(":" + String.valueOf(n3));
                }
            } else {
                throw new IllegalArgumentException("Cannot format given Object as a Unit");
            }
            return stringBuffer;
        }
    }

    private static final class Html
    extends UnitFormat {
        private static final Html INSTANCE = new Html();

        private Html() {
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            Object object2;
            if (object instanceof Unit && (object2 = this.labelFor((Unit)object)) != null) {
                stringBuffer.append((String)object2);
                return stringBuffer;
            }
            if (object instanceof ProductUnit) {
                object2 = (ProductUnit)object;
                int n = stringBuffer.length();
                for (int i = 0; i < ((ProductUnit)object2).size(); ++i) {
                    if (n != stringBuffer.length()) {
                        stringBuffer.append("&#183;");
                    }
                    String string = this.labelFor(((ProductUnit)object2).get(i).getUnit());
                    int n2 = ((ProductUnit)object2).get(i).getPow();
                    int n3 = ((ProductUnit)object2).get(i).getRoot();
                    stringBuffer.append(string);
                    if (n2 == 1 && n3 == 1) continue;
                    stringBuffer.append("<sup>" + String.valueOf(n2));
                    if (n3 != 1) {
                        stringBuffer.append(":" + String.valueOf(n3));
                    }
                    stringBuffer.append("</sup>");
                }
            } else {
                throw new IllegalArgumentException("Cannot format given Object as a Unit");
            }
            return stringBuffer;
        }
    }

    private static final class Standard
    extends UnitFormat {
        private static final Standard INSTANCE = new Standard();

        private Standard() {
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            Object object2;
            if (object instanceof Unit && (object2 = this.labelFor((Unit)object)) != null) {
                stringBuffer.append((String)object2);
                return stringBuffer;
            }
            if (object instanceof ProductUnit) {
                int n;
                int n2;
                String string;
                int n3;
                object2 = (ProductUnit)object;
                int n4 = 0;
                int n5 = stringBuffer.length();
                for (n3 = 0; n3 < ((ProductUnit)object2).size(); ++n3) {
                    string = this.labelFor(((ProductUnit)object2).get(n3).getUnit());
                    n2 = ((ProductUnit)object2).get(n3).getPow();
                    n = ((ProductUnit)object2).get(n3).getRoot();
                    if (n2 >= 0) {
                        if (n5 != stringBuffer.length()) {
                            stringBuffer.append('\u00b7');
                        }
                        UnitFormat.append(stringBuffer, string, n2, n);
                        continue;
                    }
                    ++n4;
                }
                if (n4 != 0) {
                    if (n5 == stringBuffer.length()) {
                        stringBuffer.append('1');
                    }
                    stringBuffer.append('/');
                    if (n4 > 1) {
                        stringBuffer.append('(');
                    }
                    n5 = stringBuffer.length();
                    for (n3 = 0; n3 < ((ProductUnit)object2).size(); ++n3) {
                        string = this.labelFor(((ProductUnit)object2).get(n3).getUnit());
                        n2 = ((ProductUnit)object2).get(n3).getPow();
                        n = ((ProductUnit)object2).get(n3).getRoot();
                        if (n2 >= 0) continue;
                        if (n5 != stringBuffer.length()) {
                            stringBuffer.append('\u00b7');
                        }
                        UnitFormat.append(stringBuffer, string, -n2, n);
                    }
                    if (n4 > 1) {
                        stringBuffer.append(')');
                    }
                }
            } else {
                throw new IllegalArgumentException("Cannot format given Object as a Unit");
            }
            return stringBuffer;
        }
    }
}

