/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSEntityEnumerator;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;
import org.unijena.jams.runtime.RuntimeException;

public class FullSetEntityWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="EntitySet")
    public JAMSEntityCollection entitySet;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file name")
    public JAMSString fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file header descriptions")
    public JAMSString header;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file attribute names")
    public JAMSString attributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="entity attribute name for weight [attName | none]")
    public JAMSString weight;
    private GenericDataWriter writer;
    private String[] attrs;
    private boolean headerWritten;
    int nEnts = 0;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        this.writer = new GenericDataWriter(this.dirName.getValue() + "/" + this.fileName.getValue());
        this.writer.addComment("J2K model output" + this.header.getValue());
        this.writer.addComment("");
        this.nEnts = this.entitySet.getEntityArray().length;
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        if (!this.headerWritten) {
            this.writer.addColumn("date/time");
            JAMSEntityEnumerator enEnum = this.entitySet.getEntityEnumerator();
            enEnum.reset();
            boolean cont = true;
            while (cont) {
                Object ob = this.entitySet.getCurrent().getObject(this.attributeName.getValue());
                int length = 0;
                length = ob.getClass().getName().contains("DoubleArray") ? ((JAMSDoubleArray)this.entitySet.getCurrent().getObject(this.attributeName.getValue())).getValue().length : 0;
                for (int i = 0; i < length; ++i) {
                    this.writer.addColumn("HRU_" + (int)this.entitySet.getCurrent().getDouble("ID") + "[" + i + "]");
                }
                if (length == 0) {
                    this.writer.addColumn("HRU_" + (int)this.entitySet.getCurrent().getDouble("ID"));
                }
                if (enEnum.hasNext()) {
                    enEnum.next();
                    cont = true;
                    continue;
                }
                cont = false;
            }
            this.writer.writeHeader();
            this.headerWritten = true;
        }
        this.writer.addData((Object)this.time);
        JAMSEntityEnumerator ee = this.entitySet.getEntityEnumerator();
        ee.reset();
        int setCounter = 0;
        boolean cont = true;
        while (cont) {
            double val;
            Object ob;
            double weightVal = 1.0;
            if (!this.weight.getValue().equals("none")) {
                weightVal = ((JAMSDouble)this.entitySet.getCurrent().getObject(this.weight.getValue())).getValue();
            }
            if ((ob = this.entitySet.getCurrent().getObject(this.attributeName.getValue())).getClass().getName().contains("DoubleArray")) {
                double[] da = ((JAMSDoubleArray)this.entitySet.getCurrent().getObject(this.attributeName.getValue())).getValue();
                for (int i = 0; i < da.length; ++i) {
                    val = da[i] / weightVal;
                    this.writer.addData((Object)("" + val));
                }
            } else {
                double da = ((JAMSDouble)this.entitySet.getCurrent().getObject(this.attributeName.getValue())).getValue();
                val = da / weightVal;
                this.writer.addData((Object)("" + val));
            }
            if (setCounter < this.nEnts - 1) {
                ++setCounter;
            }
            if (ee.hasNext() && setCounter < this.nEnts) {
                ee.next();
                cont = true;
                continue;
            }
            cont = false;
        }
        try {
            this.writer.writeData();
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().handle((Exception)((Object)jre));
        }
    }

    public void cleanup() {
        this.writer.close();
    }
}

