/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import java.util.StringTokenizer;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSEntityEnumerator;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;
import org.unijena.jams.runtime.RuntimeException;

public class EntityAttributeWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="EntitySet")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file name")
    public JAMSString fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file header descriptions")
    public JAMSString header;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file attribute names")
    public JAMSString attributeNames;
    private GenericDataWriter writer;
    private boolean headerWritten;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        this.writer = new GenericDataWriter(this.dirName.getValue() + "/" + this.fileName.getValue());
        this.writer.addComment("J2K model output" + this.header.getValue());
        this.writer.addComment("");
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        StringTokenizer tok = new StringTokenizer(this.attributeNames.getValue(), ";");
        String[] attributes = new String[tok.countTokens()];
        int counter = 0;
        while (tok.hasMoreTokens()) {
            attributes[counter] = tok.nextToken();
            ++counter;
        }
        if (!this.headerWritten) {
            for (int i = 0; i < attributes.length; ++i) {
                this.writer.addColumn(attributes[i]);
            }
            this.writer.writeHeader();
            this.headerWritten = true;
        }
        JAMSEntityEnumerator e = this.entities.getEntityEnumerator();
        e.reset();
        while (e.hasNext()) {
            JAMSEntity entity = e.next();
            for (int i = 0; i < attributes.length; ++i) {
                this.writer.addData(entity.getObject(attributes[i]));
            }
            try {
                this.writer.writeData();
            }
            catch (RuntimeException jre) {
                this.getModel().getRuntime().handle((Exception)((Object)jre));
            }
        }
    }

    public void cleanup() {
        this.writer.close();
    }
}

